/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.databasecenter.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.databasecenter.v1beta.DatabaseCenterClient;
import com.google.cloud.databasecenter.v1beta.QueryProductsRequest;
import com.google.cloud.databasecenter.v1beta.QueryProductsResponse;
import com.google.cloud.databasecenter.v1beta.stub.DatabaseCenterStub;
import com.google.cloud.databasecenter.v1beta.stub.DatabaseCenterStubSettings;
import com.google.cloud.databasecenter.v1beta.stub.GrpcDatabaseCenterCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcDatabaseCenterStub
extends DatabaseCenterStub {
    private static final MethodDescriptor<QueryProductsRequest, QueryProductsResponse> queryProductsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.databasecenter.v1beta.DatabaseCenter/QueryProducts").setRequestMarshaller(ProtoUtils.marshaller((Message)QueryProductsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)QueryProductsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<QueryProductsRequest, QueryProductsResponse> queryProductsCallable;
    private final UnaryCallable<QueryProductsRequest, DatabaseCenterClient.QueryProductsPagedResponse> queryProductsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDatabaseCenterStub create(DatabaseCenterStubSettings settings) throws IOException {
        return new GrpcDatabaseCenterStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDatabaseCenterStub create(ClientContext clientContext) throws IOException {
        return new GrpcDatabaseCenterStub(DatabaseCenterStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDatabaseCenterStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDatabaseCenterStub(DatabaseCenterStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDatabaseCenterStub(DatabaseCenterStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDatabaseCenterCallableFactory());
    }

    protected GrpcDatabaseCenterStub(DatabaseCenterStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings queryProductsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(queryProductsMethodDescriptor).build();
        this.queryProductsCallable = callableFactory.createUnaryCallable(queryProductsTransportSettings, settings.queryProductsSettings(), clientContext);
        this.queryProductsPagedCallable = callableFactory.createPagedCallable(queryProductsTransportSettings, settings.queryProductsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<QueryProductsRequest, QueryProductsResponse> queryProductsCallable() {
        return this.queryProductsCallable;
    }

    @Override
    public UnaryCallable<QueryProductsRequest, DatabaseCenterClient.QueryProductsPagedResponse> queryProductsPagedCallable() {
        return this.queryProductsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

