/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class Role
implements Serializable {
    private static final long serialVersionUID = -7779252712160972508L;
    private static final String ROLE_PREFIX = "roles/";
    private final String value;

    private Role(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Role viewer() {
        return Role.of("viewer");
    }

    public static Role editor() {
        return Role.of("editor");
    }

    public static Role owner() {
        return Role.of("owner");
    }

    public static Role of(String value) {
        String string;
        Preconditions.checkNotNull((Object)value);
        if (value.startsWith(ROLE_PREFIX)) {
            string = value;
        } else {
            String string2 = String.valueOf(ROLE_PREFIX);
            String string3 = String.valueOf(value);
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return new Role(string);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Role && Objects.equals(this.value, ((Role)obj).getValue());
    }
}

