/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.client.extensions.appengine.http.UrlFetchTransport;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.http.HttpTransportFactory;
import com.google.cloud.NoCredentials;
import com.google.cloud.Service;
import com.google.cloud.ServiceFactory;
import com.google.cloud.ServiceOptions;
import com.google.cloud.spi.ServiceRpcFactory;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;

public abstract class HttpServiceOptions<ServiceT extends Service<OptionsT>, ServiceRpcT, OptionsT extends HttpServiceOptions<ServiceT, ServiceRpcT, OptionsT>>
extends ServiceOptions<ServiceT, ServiceRpcT, OptionsT> {
    private static final long serialVersionUID = 4765436436821178975L;
    private final int connectTimeout;
    private final int readTimeout;
    private final String httpTransportFactoryClassName;
    private transient HttpTransportFactory httpTransportFactory;

    protected HttpServiceOptions(Class<? extends ServiceFactory<ServiceT, OptionsT>> serviceFactoryClass, Class<? extends ServiceRpcFactory<ServiceRpcT, OptionsT>> rpcFactoryClass, Builder<ServiceT, ServiceRpcT, OptionsT, ?> builder) {
        super(serviceFactoryClass, rpcFactoryClass, builder);
        this.httpTransportFactory = (HttpTransportFactory)MoreObjects.firstNonNull((Object)((Builder)builder).httpTransportFactory, (Object)HttpServiceOptions.getFromServiceLoader(HttpTransportFactory.class, DefaultHttpTransportFactory.INSTANCE));
        this.httpTransportFactoryClassName = this.httpTransportFactory.getClass().getName();
        this.connectTimeout = ((Builder)builder).connectTimeout;
        this.readTimeout = ((Builder)builder).readTimeout;
    }

    @Deprecated
    public HttpTransportFactory httpTransportFactory() {
        return this.getHttpTransportFactory();
    }

    public HttpTransportFactory getHttpTransportFactory() {
        return this.httpTransportFactory;
    }

    @Deprecated
    public HttpRequestInitializer httpRequestInitializer() {
        return this.getHttpRequestInitializer();
    }

    public HttpRequestInitializer getHttpRequestInitializer() {
        Credentials scopedCredentials = this.getScopedCredentials();
        HttpCredentialsAdapter delegate = scopedCredentials != null && scopedCredentials != NoCredentials.getInstance() ? new HttpCredentialsAdapter(scopedCredentials) : null;
        return new HttpRequestInitializer((HttpRequestInitializer)delegate){
            final /* synthetic */ HttpRequestInitializer val$delegate;
            {
                this.val$delegate = httpRequestInitializer;
            }

            public void initialize(HttpRequest httpRequest) throws IOException {
                if (this.val$delegate != null) {
                    this.val$delegate.initialize(httpRequest);
                }
                if (HttpServiceOptions.this.connectTimeout >= 0) {
                    httpRequest.setConnectTimeout(HttpServiceOptions.this.connectTimeout);
                }
                if (HttpServiceOptions.this.readTimeout >= 0) {
                    httpRequest.setReadTimeout(HttpServiceOptions.this.readTimeout);
                }
            }
        };
    }

    public int connectTimeout() {
        return this.getConnectTimeout();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Deprecated
    public int readTimeout() {
        return this.getReadTimeout();
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    protected int baseHashCode() {
        return Objects.hash(super.baseHashCode(), this.httpTransportFactoryClassName, this.connectTimeout, this.readTimeout);
    }

    @Override
    protected boolean baseEquals(HttpServiceOptions<?, ?, ?> other) {
        return super.baseEquals(other) && Objects.equals(this.httpTransportFactoryClassName, other.httpTransportFactoryClassName) && Objects.equals(this.connectTimeout, other.connectTimeout) && Objects.equals(this.readTimeout, other.readTimeout);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.httpTransportFactory = (HttpTransportFactory)HttpServiceOptions.newInstance(this.httpTransportFactoryClassName);
    }

    protected static abstract class Builder<ServiceT extends Service<OptionsT>, ServiceRpcT, OptionsT extends HttpServiceOptions<ServiceT, ServiceRpcT, OptionsT>, B extends Builder<ServiceT, ServiceRpcT, OptionsT, B>>
    extends ServiceOptions.Builder<ServiceT, ServiceRpcT, OptionsT, B> {
        private HttpTransportFactory httpTransportFactory;
        private int connectTimeout = -1;
        private int readTimeout = -1;

        protected Builder() {
        }

        protected Builder(HttpServiceOptions<ServiceT, ServiceRpcT, OptionsT> options) {
            super(options);
            this.httpTransportFactory = ((HttpServiceOptions)options).httpTransportFactory;
            this.connectTimeout = ((HttpServiceOptions)options).connectTimeout;
            this.readTimeout = ((HttpServiceOptions)options).readTimeout;
        }

        @Override
        protected abstract HttpServiceOptions<ServiceT, ServiceRpcT, OptionsT> build();

        @Override
        protected B self() {
            return (B)this;
        }

        @Deprecated
        public B httpTransportFactory(HttpTransportFactory httpTransportFactory) {
            return this.setHttpTransportFactory(httpTransportFactory);
        }

        public B setHttpTransportFactory(HttpTransportFactory httpTransportFactory) {
            this.httpTransportFactory = httpTransportFactory;
            return (B)this.self();
        }

        @Deprecated
        public B connectTimeout(int connectTimeout) {
            return this.setConnectTimeout(connectTimeout);
        }

        public B setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return (B)this.self();
        }

        @Deprecated
        public B readTimeout(int readTimeout) {
            return this.setReadTimeout(readTimeout);
        }

        public B setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return (B)this.self();
        }
    }

    public static class DefaultHttpTransportFactory
    implements HttpTransportFactory {
        private static final HttpTransportFactory INSTANCE = new DefaultHttpTransportFactory();

        public HttpTransport create() {
            if (ServiceOptions.getAppEngineAppId() != null) {
                try {
                    return new UrlFetchTransport();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new NetHttpTransport();
        }
    }
}

