/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class Clock {
    private static final Clock DEFAULT_TIME_SOURCE = new DefaultClock();

    public abstract long millis();

    public static Clock defaultClock() {
        return DEFAULT_TIME_SOURCE;
    }

    private static class DefaultClock
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = -5077300394286703864L;

        private DefaultClock() {
        }

        @Override
        public long millis() {
            return System.currentTimeMillis();
        }

        private Object readResolve() throws ObjectStreamException {
            return DEFAULT_TIME_SOURCE;
        }
    }
}

