/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.Clock;
import com.google.cloud.RetryParams;
import com.google.cloud.Service;
import com.google.cloud.ServiceFactory;
import com.google.cloud.spi.ServiceRpcFactory;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class ServiceOptions<ServiceT extends Service<OptionsT>, ServiceRpcT, OptionsT extends ServiceOptions<ServiceT, ServiceRpcT, OptionsT>>
implements Serializable {
    private static final String DEFAULT_HOST = "https://www.googleapis.com";
    private static final String LEGACY_PROJECT_ENV_NAME = "GCLOUD_PROJECT";
    private static final String PROJECT_ENV_NAME = "GOOGLE_CLOUD_PROJECT";
    private static final String MANIFEST_ARTIFACT_ID_KEY = "artifactId";
    private static final String MANIFEST_VERSION_KEY = "Implementation-Version";
    private static final String ARTIFACT_ID = "google-cloud-core";
    private static final String LIBRARY_NAME = "gcloud-java";
    private static final String LIBRARY_VERSION = ServiceOptions.defaultLibraryVersion();
    private static final String APPLICATION_NAME = LIBRARY_VERSION == null ? "gcloud-java" : "gcloud-java/" + LIBRARY_VERSION;
    private static final long serialVersionUID = -5714029257168617973L;
    private static final String META_FILE_ROOT = "/META-INF/maven/";
    private static final String META_VERSION_KEY = "version";
    private final String projectId;
    private final String host;
    private final RetryParams retryParams;
    private final String serviceRpcFactoryClassName;
    private final String serviceFactoryClassName;
    private final Clock clock;
    private final Credentials credentials;
    private transient ServiceRpcFactory<ServiceRpcT, OptionsT> serviceRpcFactory;
    private transient ServiceFactory<ServiceT, OptionsT> serviceFactory;
    private transient ServiceT service;
    private transient ServiceRpcT rpc;

    protected ServiceOptions(Class<? extends ServiceFactory<ServiceT, OptionsT>> serviceFactoryClass, Class<? extends ServiceRpcFactory<ServiceRpcT, OptionsT>> rpcFactoryClass, Builder<ServiceT, ServiceRpcT, OptionsT, ?> builder) {
        String string = this.projectId = ((Builder)builder).projectId != null ? ((Builder)builder).projectId : this.getDefaultProject();
        if (this.projectIdRequired()) {
            Preconditions.checkArgument((this.projectId != null ? 1 : 0) != 0, (Object)"A project ID is required for this service but could not be determined from the builder or the environment.  Please set a project ID using the builder.");
        }
        this.host = (String)MoreObjects.firstNonNull((Object)((Builder)builder).host, (Object)this.getDefaultHost());
        this.credentials = ((Builder)builder).credentials != null ? ((Builder)builder).credentials : ServiceOptions.defaultCredentials();
        this.retryParams = (RetryParams)MoreObjects.firstNonNull((Object)((Builder)builder).retryParams, (Object)this.defaultRetryParams());
        this.serviceFactory = (ServiceFactory)MoreObjects.firstNonNull((Object)((Builder)builder).serviceFactory, ServiceOptions.getFromServiceLoader(serviceFactoryClass, this.getDefaultServiceFactory()));
        this.serviceFactoryClassName = this.serviceFactory.getClass().getName();
        this.serviceRpcFactory = (ServiceRpcFactory)MoreObjects.firstNonNull((Object)((Builder)builder).serviceRpcFactory, ServiceOptions.getFromServiceLoader(rpcFactoryClass, this.getDefaultRpcFactory()));
        this.serviceRpcFactoryClassName = this.serviceRpcFactory.getClass().getName();
        this.clock = (Clock)MoreObjects.firstNonNull((Object)((Builder)builder).clock, (Object)Clock.defaultClock());
    }

    protected boolean projectIdRequired() {
        return true;
    }

    private static GoogleCredentials defaultCredentials() {
        try {
            return GoogleCredentials.getApplicationDefault();
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected static String appEngineAppId() {
        return System.getProperty("com.google.appengine.application.id");
    }

    @Deprecated
    protected String defaultHost() {
        return this.getDefaultHost();
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    @Deprecated
    protected String defaultProject() {
        return this.getDefaultProject();
    }

    protected String getDefaultProject() {
        String projectId = System.getProperty(PROJECT_ENV_NAME, System.getenv(PROJECT_ENV_NAME));
        if (projectId == null) {
            projectId = System.getProperty(LEGACY_PROJECT_ENV_NAME, System.getenv(LEGACY_PROJECT_ENV_NAME));
        }
        if (projectId == null) {
            projectId = ServiceOptions.appEngineProjectId();
        }
        if (projectId == null) {
            projectId = ServiceOptions.serviceAccountProjectId();
        }
        return projectId != null ? projectId : ServiceOptions.googleCloudProjectId();
    }

    private static String activeGoogleCloudConfig(File configDir) {
        String activeGoogleCloudConfig = null;
        try {
            activeGoogleCloudConfig = Files.readFirstLine((File)new File(configDir, "active_config"), (Charset)Charset.defaultCharset());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (String)MoreObjects.firstNonNull(activeGoogleCloudConfig, (Object)"default");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String googleCloudProjectId() {
        File configDir = System.getenv().containsKey("CLOUDSDK_CONFIG") ? new File(System.getenv("CLOUDSDK_CONFIG")) : (ServiceOptions.isWindows() && System.getenv().containsKey("APPDATA") ? new File(System.getenv("APPDATA"), "gcloud") : new File(System.getProperty("user.home"), ".config/gcloud"));
        String activeConfig = ServiceOptions.activeGoogleCloudConfig(configDir);
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(new File(configDir, "configurations/config_" + activeConfig));
        }
        catch (FileNotFoundException newConfigFileNotFoundEx) {
            try {
                fileReader = new FileReader(new File(configDir, "properties"));
            }
            catch (FileNotFoundException oldConfigFileNotFoundEx) {
                // empty catch block
            }
        }
        if (fileReader != null) {
            try (BufferedReader reader = new BufferedReader(fileReader);){
                String line;
                String section = null;
                Pattern projectPattern = Pattern.compile("^project\\s*=\\s*(.*)$");
                Pattern sectionPattern = Pattern.compile("^\\[(.*)\\]$");
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty() || line.startsWith(";")) continue;
                    Matcher matcher = sectionPattern.matcher(line = line.trim());
                    if (matcher.matches()) {
                        section = matcher.group(1);
                        continue;
                    }
                    if (section != null && !section.equals("core") || !(matcher = projectPattern.matcher(line)).matches()) continue;
                    String string = matcher.group(1);
                    return string;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        try {
            URL url = new URL("http://metadata/computeMetadata/v1/project/project-id");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("X-Google-Metadata-Request", "True");
            InputStream input = connection.getInputStream();
            if (connection.getResponseCode() != 200) return null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                String string = reader.readLine();
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    }

    protected static String appEngineProjectId() {
        try {
            Class<?> factoryClass = Class.forName("com.google.appengine.api.appidentity.AppIdentityServiceFactory");
            Class<?> serviceClass = Class.forName("com.google.appengine.api.appidentity.AppIdentityService");
            Method method = factoryClass.getMethod("getAppIdentityService", new Class[0]);
            Object appIdentityService = method.invoke(null, new Object[0]);
            method = serviceClass.getMethod("getServiceAccountName", new Class[0]);
            String serviceAccountName = (String)method.invoke(appIdentityService, new Object[0]);
            int indexOfAtSign = serviceAccountName.indexOf(64);
            return serviceAccountName.substring(0, indexOfAtSign);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    protected static String serviceAccountProjectId() {
        String project = null;
        String credentialsPath = System.getenv("GOOGLE_APPLICATION_CREDENTIALS");
        if (credentialsPath != null) {
            try (FileInputStream credentialsStream = new FileInputStream(credentialsPath);){
                JSONObject json = new JSONObject(new JSONTokener((InputStream)credentialsStream));
                project = json.getString("project_id");
            }
            catch (IOException | JSONException throwable) {
                // empty catch block
            }
        }
        return project;
    }

    @Deprecated
    public ServiceT service() {
        return this.getService();
    }

    public ServiceT getService() {
        if (this.service == null) {
            this.service = this.serviceFactory.create(this);
        }
        return this.service;
    }

    @Deprecated
    public ServiceRpcT rpc() {
        return this.getRpc();
    }

    public ServiceRpcT getRpc() {
        if (this.rpc == null) {
            this.rpc = this.serviceRpcFactory.create(this);
        }
        return this.rpc;
    }

    @Deprecated
    public String projectId() {
        return this.getProjectId();
    }

    public String getProjectId() {
        return this.projectId;
    }

    @Deprecated
    public String host() {
        return this.getHost();
    }

    public String getHost() {
        return this.host;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Credentials getScopedCredentials() {
        Credentials credentialsToReturn = this.credentials;
        if (this.credentials instanceof GoogleCredentials && ((GoogleCredentials)this.credentials).createScopedRequired()) {
            credentialsToReturn = ((GoogleCredentials)this.credentials).createScoped(this.getScopes());
        }
        return credentialsToReturn;
    }

    @Deprecated
    public RetryParams retryParams() {
        return this.getRetryParams();
    }

    public RetryParams getRetryParams() {
        return this.retryParams;
    }

    @Deprecated
    public Clock clock() {
        return this.getClock();
    }

    public Clock getClock() {
        return this.clock;
    }

    @Deprecated
    public String applicationName() {
        return this.getApplicationName();
    }

    public String getApplicationName() {
        return APPLICATION_NAME;
    }

    @Deprecated
    public String libraryName() {
        return this.getLibraryName();
    }

    public String getLibraryName() {
        return LIBRARY_NAME;
    }

    public String libraryVersion() {
        return this.getLibraryVersion();
    }

    public String getLibraryVersion() {
        return LIBRARY_VERSION;
    }

    protected int baseHashCode() {
        return Objects.hash(this.projectId, this.host, this.credentials, this.retryParams, this.serviceFactoryClassName, this.serviceRpcFactoryClassName, this.clock);
    }

    protected boolean baseEquals(ServiceOptions<?, ?, ?> other) {
        return Objects.equals(this.projectId, other.projectId) && Objects.equals(this.host, other.host) && Objects.equals(this.credentials, other.credentials) && Objects.equals(this.retryParams, other.retryParams) && Objects.equals(this.serviceFactoryClassName, other.serviceFactoryClassName) && Objects.equals(this.serviceRpcFactoryClassName, other.serviceRpcFactoryClassName) && Objects.equals(this.clock, this.clock);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.serviceFactory = (ServiceFactory)ServiceOptions.newInstance(this.serviceFactoryClassName);
        this.serviceRpcFactory = (ServiceRpcFactory)ServiceOptions.newInstance(this.serviceRpcFactoryClassName);
    }

    static <T> T newInstance(String className) throws IOException, ClassNotFoundException {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    protected ServiceFactory<ServiceT, OptionsT> defaultServiceFactory() {
        return this.getDefaultServiceFactory();
    }

    protected abstract ServiceFactory<ServiceT, OptionsT> getDefaultServiceFactory();

    @Deprecated
    protected ServiceRpcFactory<ServiceRpcT, OptionsT> defaultRpcFactory() {
        return this.getDefaultRpcFactory();
    }

    protected abstract ServiceRpcFactory<ServiceRpcT, OptionsT> getDefaultRpcFactory();

    @Deprecated
    protected Set<String> scopes() {
        return this.getScopes();
    }

    protected abstract Set<String> getScopes();

    public abstract <B extends Builder<ServiceT, ServiceRpcT, OptionsT, B>> B toBuilder();

    protected RetryParams defaultRetryParams() {
        return RetryParams.getDefaultInstance();
    }

    static <T> T getFromServiceLoader(Class<? extends T> clazz, T defaultInstance) {
        return (T)Iterables.getFirst(ServiceLoader.load(clazz), defaultInstance);
    }

    private static String defaultLibraryVersion() {
        String version = ServiceOptions.getPomVersion();
        if (version == null) {
            version = ServiceOptions.getManifestVersion();
        }
        return version;
    }

    private static String getPomVersion() {
        try {
            Properties properties = new Properties();
            String mavenPropertiesPath = META_FILE_ROOT + ServiceOptions.class.getPackage().getName() + "/" + ARTIFACT_ID + "/pom.properties";
            InputStream inputStream = ServiceOptions.class.getResourceAsStream(mavenPropertiesPath);
            if (inputStream != null) {
                properties.load(inputStream);
                return properties.getProperty(META_VERSION_KEY, "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getManifestVersion() {
        String version = null;
        try {
            Enumeration<URL> resources = ServiceOptions.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements() && version == null) {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                Attributes manifestAttributes = manifest.getMainAttributes();
                String artifactId = manifestAttributes.getValue(MANIFEST_ARTIFACT_ID_KEY);
                if (artifactId == null || !artifactId.equals(ARTIFACT_ID)) continue;
                version = manifestAttributes.getValue(MANIFEST_VERSION_KEY);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version;
    }

    protected static abstract class Builder<ServiceT extends Service<OptionsT>, ServiceRpcT, OptionsT extends ServiceOptions<ServiceT, ServiceRpcT, OptionsT>, B extends Builder<ServiceT, ServiceRpcT, OptionsT, B>> {
        private String projectId;
        private String host;
        private Credentials credentials;
        private RetryParams retryParams;
        private ServiceFactory<ServiceT, OptionsT> serviceFactory;
        private ServiceRpcFactory<ServiceRpcT, OptionsT> serviceRpcFactory;
        private Clock clock;

        protected Builder() {
        }

        protected Builder(ServiceOptions<ServiceT, ServiceRpcT, OptionsT> options) {
            this.projectId = ((ServiceOptions)options).projectId;
            this.host = ((ServiceOptions)options).host;
            this.credentials = ((ServiceOptions)options).credentials;
            this.retryParams = ((ServiceOptions)options).retryParams;
            this.serviceFactory = ((ServiceOptions)options).serviceFactory;
            this.serviceRpcFactory = ((ServiceOptions)options).serviceRpcFactory;
            this.clock = ((ServiceOptions)options).clock;
        }

        protected abstract ServiceOptions<ServiceT, ServiceRpcT, OptionsT> build();

        protected B self() {
            return (B)this;
        }

        @Deprecated
        public B serviceFactory(ServiceFactory<ServiceT, OptionsT> serviceFactory) {
            return this.setServiceFactory(serviceFactory);
        }

        public B setServiceFactory(ServiceFactory<ServiceT, OptionsT> serviceFactory) {
            this.serviceFactory = serviceFactory;
            return this.self();
        }

        @Deprecated
        public B clock(Clock clock) {
            return this.setClock(clock);
        }

        public B setClock(Clock clock) {
            this.clock = clock;
            return this.self();
        }

        @Deprecated
        public B projectId(String projectId) {
            return this.setProjectId(projectId);
        }

        public B setProjectId(String projectId) {
            this.projectId = projectId;
            return this.self();
        }

        @Deprecated
        public B host(String host) {
            return this.setHost(host);
        }

        public B setHost(String host) {
            this.host = host;
            return this.self();
        }

        public B setCredentials(Credentials credentials) {
            this.credentials = (Credentials)Preconditions.checkNotNull((Object)credentials);
            return this.self();
        }

        @Deprecated
        public B retryParams(RetryParams retryParams) {
            return this.setRetryParams(retryParams);
        }

        public B setRetryParams(RetryParams retryParams) {
            this.retryParams = retryParams;
            return this.self();
        }

        @Deprecated
        public B serviceRpcFactory(ServiceRpcFactory<ServiceRpcT, OptionsT> serviceRpcFactory) {
            return this.setServiceRpcFactory(serviceRpcFactory);
        }

        public B setServiceRpcFactory(ServiceRpcFactory<ServiceRpcT, OptionsT> serviceRpcFactory) {
            this.serviceRpcFactory = serviceRpcFactory;
            return this.self();
        }
    }
}

