/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.Service;
import com.google.cloud.ServiceFactory;
import com.google.cloud.ServiceOptions;
import com.google.cloud.spi.ServiceRpcFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import io.grpc.internal.SharedResourceHolder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joda.time.Duration;

public abstract class GrpcServiceOptions<ServiceT extends Service<OptionsT>, ServiceRpcT, OptionsT extends GrpcServiceOptions<ServiceT, ServiceRpcT, OptionsT>>
extends ServiceOptions<ServiceT, ServiceRpcT, OptionsT> {
    private static final long serialVersionUID = -3093986242928037007L;
    private final String executorFactoryClassName;
    private final int initialTimeout;
    private final double timeoutMultiplier;
    private final int maxTimeout;
    private transient ExecutorFactory<ScheduledExecutorService> executorFactory;
    private static final SharedResourceHolder.Resource<ScheduledExecutorService> EXECUTOR = new SharedResourceHolder.Resource<ScheduledExecutorService>(){

        public ScheduledExecutorService create() {
            ScheduledThreadPoolExecutor service = new ScheduledThreadPoolExecutor(8);
            service.setKeepAliveTime(5L, TimeUnit.SECONDS);
            service.allowCoreThreadTimeOut(true);
            service.setRemoveOnCancelPolicy(true);
            return service;
        }

        public void close(ScheduledExecutorService instance) {
            instance.shutdown();
        }
    };

    protected GrpcServiceOptions(Class<? extends ServiceFactory<ServiceT, OptionsT>> serviceFactoryClass, Class<? extends ServiceRpcFactory<ServiceRpcT, OptionsT>> rpcFactoryClass, Builder<ServiceT, ServiceRpcT, OptionsT, ?> builder) {
        super(serviceFactoryClass, rpcFactoryClass, builder);
        this.executorFactory = (ExecutorFactory)MoreObjects.firstNonNull((Object)((Builder)builder).executorFactory, (Object)GrpcServiceOptions.getFromServiceLoader(ExecutorFactory.class, DefaultExecutorFactory.INSTANCE));
        this.executorFactoryClassName = this.executorFactory.getClass().getName();
        this.initialTimeout = ((Builder)builder).initialTimeout;
        this.timeoutMultiplier = ((Builder)builder).timeoutMultiplier;
        this.maxTimeout = ((Builder)builder).maxTimeout <= this.initialTimeout ? this.initialTimeout : ((Builder)builder).maxTimeout;
    }

    @Deprecated
    protected ExecutorFactory<ScheduledExecutorService> executorFactory() {
        return this.getExecutorFactory();
    }

    protected ExecutorFactory<ScheduledExecutorService> getExecutorFactory() {
        return this.executorFactory;
    }

    @Deprecated
    protected UnaryCallSettings.Builder apiCallSettings() {
        return this.getApiCallSettings();
    }

    protected UnaryCallSettings.Builder getApiCallSettings() {
        RetrySettings.Builder builder = RetrySettings.newBuilder().setTotalTimeout(Duration.millis((long)this.getRetryParams().getTotalRetryPeriodMillis())).setInitialRpcTimeout(Duration.millis((long)this.getInitialTimeout())).setRpcTimeoutMultiplier(this.getTimeoutMultiplier()).setMaxRpcTimeout(Duration.millis((long)this.getMaxTimeout())).setInitialRetryDelay(Duration.millis((long)this.getRetryParams().getInitialRetryDelayMillis())).setRetryDelayMultiplier(this.getRetryParams().getRetryDelayBackoffFactor()).setMaxRetryDelay(Duration.millis((long)this.getRetryParams().getMaxRetryDelayMillis()));
        return UnaryCallSettings.newBuilder().setRetrySettingsBuilder(builder);
    }

    protected ChannelProvider getChannelProvider() {
        HostAndPort hostAndPort = HostAndPort.fromString((String)this.getHost());
        InstantiatingChannelProvider.Builder builder = InstantiatingChannelProvider.newBuilder().setServiceAddress(hostAndPort.getHostText()).setPort(hostAndPort.getPort()).setClientLibHeader(this.getLibraryName(), (String)MoreObjects.firstNonNull((Object)this.getLibraryVersion(), (Object)""));
        Credentials scopedCredentials = this.getScopedCredentials();
        if (scopedCredentials != null && scopedCredentials != NoCredentials.getInstance()) {
            builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)scopedCredentials));
        }
        return builder.build();
    }

    @Deprecated
    public int initialTimeout() {
        return this.getInitialTimeout();
    }

    public int getInitialTimeout() {
        return this.initialTimeout;
    }

    @Deprecated
    public double timeoutMultiplier() {
        return this.getTimeoutMultiplier();
    }

    public double getTimeoutMultiplier() {
        return this.timeoutMultiplier;
    }

    @Deprecated
    public int maxTimeout() {
        return this.getMaxTimeout();
    }

    public int getMaxTimeout() {
        return this.maxTimeout;
    }

    @Override
    protected int baseHashCode() {
        return Objects.hash(super.baseHashCode(), this.executorFactoryClassName, this.initialTimeout, this.timeoutMultiplier, this.maxTimeout);
    }

    @Override
    protected boolean baseEquals(GrpcServiceOptions<?, ?, ?> other) {
        return super.baseEquals(other) && Objects.equals(this.executorFactoryClassName, other.executorFactoryClassName) && Objects.equals(this.initialTimeout, other.initialTimeout) && Objects.equals(this.timeoutMultiplier, other.timeoutMultiplier) && Objects.equals(this.maxTimeout, other.maxTimeout);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.executorFactory = (ExecutorFactory)GrpcServiceOptions.newInstance(this.executorFactoryClassName);
    }

    protected static abstract class Builder<ServiceT extends Service<OptionsT>, ServiceRpcT, OptionsT extends GrpcServiceOptions<ServiceT, ServiceRpcT, OptionsT>, B extends Builder<ServiceT, ServiceRpcT, OptionsT, B>>
    extends ServiceOptions.Builder<ServiceT, ServiceRpcT, OptionsT, B> {
        private ExecutorFactory executorFactory;
        private int initialTimeout = 20000;
        private double timeoutMultiplier = 1.5;
        private int maxTimeout = 100000;

        protected Builder() {
        }

        protected Builder(GrpcServiceOptions<ServiceT, ServiceRpcT, OptionsT> options) {
            super(options);
            this.executorFactory = ((GrpcServiceOptions)options).executorFactory;
            this.initialTimeout = ((GrpcServiceOptions)options).initialTimeout;
            this.timeoutMultiplier = ((GrpcServiceOptions)options).timeoutMultiplier;
            this.maxTimeout = ((GrpcServiceOptions)options).maxTimeout;
        }

        @Override
        protected abstract GrpcServiceOptions<ServiceT, ServiceRpcT, OptionsT> build();

        @Deprecated
        public B executorFactory(ExecutorFactory<ScheduledExecutorService> executorFactory) {
            return this.setExecutorFactory(executorFactory);
        }

        public B setExecutorFactory(ExecutorFactory<ScheduledExecutorService> executorFactory) {
            this.executorFactory = executorFactory;
            return (B)((Builder)this.self());
        }

        @Deprecated
        public B initialTimeout(int initialTimeout) {
            return this.setInitialTimeout(initialTimeout);
        }

        public B setInitialTimeout(int initialTimeout) {
            Preconditions.checkArgument((initialTimeout > 0 ? 1 : 0) != 0, (Object)"Initial timeout must be > 0");
            this.initialTimeout = initialTimeout;
            return (B)((Builder)this.self());
        }

        @Deprecated
        public B timeoutMultiplier(double timeoutMultiplier) {
            return this.setTimeoutMultiplier(timeoutMultiplier);
        }

        public B setTimeoutMultiplier(double timeoutMultiplier) {
            Preconditions.checkArgument((timeoutMultiplier >= 1.0 ? 1 : 0) != 0, (Object)"Timeout multiplier must be >= 1");
            this.timeoutMultiplier = timeoutMultiplier;
            return (B)((Builder)this.self());
        }

        @Deprecated
        public B maxTimeout(int maxTimeout) {
            return this.setMaxTimeout(maxTimeout);
        }

        public B setMaxTimeout(int maxTimeout) {
            this.maxTimeout = maxTimeout;
            return (B)((Builder)this.self());
        }
    }

    @VisibleForTesting
    static class DefaultExecutorFactory
    implements ExecutorFactory<ScheduledExecutorService> {
        private static final DefaultExecutorFactory INSTANCE = new DefaultExecutorFactory();

        DefaultExecutorFactory() {
        }

        @Override
        public ScheduledExecutorService get() {
            return (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)EXECUTOR);
        }

        @Override
        public synchronized void release(ScheduledExecutorService executor) {
            SharedResourceHolder.release((SharedResourceHolder.Resource)EXECUTOR, (Object)executor);
        }
    }

    public static interface ExecutorFactory<T extends ExecutorService> {
        public T get();

        public void release(T var1);
    }
}

