/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.Identity;
import com.google.cloud.Role;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import com.google.iam.v1.Binding;
import com.google.iam.v1.Policy;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Policy
implements Serializable {
    private static final long serialVersionUID = -3348914530232544290L;
    private final Map<Role, Set<Identity>> bindings;
    private final String etag;
    private final int version;

    private Policy(Builder builder) {
        ImmutableMap.Builder bindingsBuilder = ImmutableMap.builder();
        for (Map.Entry binding : builder.bindings.entrySet()) {
            bindingsBuilder.put(binding.getKey(), (Object)ImmutableSet.copyOf((Collection)((Collection)binding.getValue())));
        }
        this.bindings = bindingsBuilder.build();
        this.etag = builder.etag;
        this.version = builder.version;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Map<Role, Set<Identity>> bindings() {
        return this.bindings;
    }

    public String etag() {
        return this.etag;
    }

    public int version() {
        return this.version;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bindings", this.bindings).add("etag", (Object)this.etag).add("version", this.version).toString();
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.bindings, this.etag, this.version);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)obj;
        return Objects.equals(this.bindings, other.bindings()) && Objects.equals(this.etag, other.etag()) && Objects.equals(this.version, other.version());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Role, Set<Identity>> bindings = new HashMap<Role, Set<Identity>>();
        private String etag;
        private int version;

        protected Builder() {
        }

        protected Builder(Policy policy) {
            this.bindings(policy.bindings);
            this.etag(policy.etag);
            this.version(policy.version);
        }

        public final Builder bindings(Map<Role, Set<Identity>> bindings) {
            Preconditions.checkNotNull(bindings, (Object)"The provided map of bindings cannot be null.");
            for (Map.Entry<Role, Set<Identity>> binding : bindings.entrySet()) {
                Preconditions.checkNotNull((Object)binding.getKey(), (Object)"The role cannot be null.");
                Set<Identity> identities = binding.getValue();
                Preconditions.checkNotNull(identities, (Object)"A role cannot be assigned to a null set of identities.");
                Preconditions.checkArgument((!identities.contains(null) ? 1 : 0) != 0, (Object)"Null identities are not permitted.");
            }
            this.bindings.clear();
            for (Map.Entry<Role, Set<Identity>> binding : bindings.entrySet()) {
                this.bindings.put(binding.getKey(), new HashSet(binding.getValue()));
            }
            return this;
        }

        public final Builder removeRole(Role role) {
            this.bindings.remove(role);
            return this;
        }

        public final Builder addIdentity(Role role, Identity first, Identity ... others) {
            String nullIdentityMessage = "Null identities are not permitted.";
            Preconditions.checkNotNull((Object)first, (Object)nullIdentityMessage);
            Preconditions.checkNotNull((Object)others, (Object)nullIdentityMessage);
            for (Identity identity : others) {
                Preconditions.checkNotNull((Object)identity, (Object)nullIdentityMessage);
            }
            LinkedHashSet<Identity> toAdd = new LinkedHashSet<Identity>();
            toAdd.add(first);
            toAdd.addAll(Arrays.asList(others));
            Set<Identity> identities = this.bindings.get(Preconditions.checkNotNull((Object)role, (Object)"The role cannot be null."));
            if (identities == null) {
                identities = new HashSet<Identity>();
                this.bindings.put(role, identities);
            }
            identities.addAll(toAdd);
            return this;
        }

        public final Builder removeIdentity(Role role, Identity first, Identity ... others) {
            Set<Identity> identities = this.bindings.get(role);
            if (identities != null) {
                identities.remove(first);
                identities.removeAll(Arrays.asList(others));
            }
            if (identities != null && identities.isEmpty()) {
                this.bindings.remove(role);
            }
            return this;
        }

        protected final Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        protected final Builder version(int version) {
            this.version = version;
            return this;
        }

        public final Policy build() {
            return new Policy(this);
        }
    }

    public static class DefaultMarshaller
    extends Marshaller<com.google.iam.v1.Policy> {
        @Override
        protected Policy fromPb(com.google.iam.v1.Policy policyPb) {
            HashMap<Role, Set<Identity>> bindings = new HashMap<Role, Set<Identity>>();
            for (Binding bindingPb : policyPb.getBindingsList()) {
                bindings.put(Role.of(bindingPb.getRole()), (Set<Identity>)ImmutableSet.copyOf((Collection)Lists.transform((List)bindingPb.getMembersList(), (Function)IDENTITY_VALUE_OF_FUNCTION)));
            }
            return Policy.builder().bindings(bindings).etag(policyPb.getEtag().isEmpty() ? null : BaseEncoding.base64().encode(policyPb.getEtag().toByteArray())).version(policyPb.getVersion()).build();
        }

        @Override
        protected com.google.iam.v1.Policy toPb(Policy policy) {
            Policy.Builder policyBuilder = com.google.iam.v1.Policy.newBuilder();
            LinkedList<Binding> bindingPbList = new LinkedList<Binding>();
            for (Map.Entry<Role, Set<Identity>> binding : policy.bindings().entrySet()) {
                Binding.Builder bindingBuilder = Binding.newBuilder();
                bindingBuilder.setRole(binding.getKey().value());
                bindingBuilder.addAllMembers((Iterable)Lists.transform(new ArrayList(binding.getValue()), (Function)IDENTITY_STR_VALUE_FUNCTION));
                bindingPbList.add(bindingBuilder.build());
            }
            policyBuilder.addAllBindings(bindingPbList);
            if (policy.etag != null) {
                policyBuilder.setEtag(ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)policy.etag)));
            }
            policyBuilder.setVersion(policy.version);
            return policyBuilder.build();
        }
    }

    public static abstract class Marshaller<T> {
        protected static final Function<String, Identity> IDENTITY_VALUE_OF_FUNCTION = new Function<String, Identity>(){

            public Identity apply(String identityPb) {
                return Identity.valueOf(identityPb);
            }
        };
        protected static final Function<Identity, String> IDENTITY_STR_VALUE_FUNCTION = new Function<Identity, String>(){

            public String apply(Identity identity) {
                return identity.strValue();
            }
        };

        protected abstract Policy fromPb(T var1);

        protected abstract T toPb(Policy var1);
    }
}

