/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class RetryParams
implements Serializable {
    private static final long serialVersionUID = -8492751576749007700L;
    public static final long DEFAULT_TOTAL_RETRY_PERIOD_MILLIS = 50000L;
    public static final int DEFAULT_RETRY_MIN_ATTEMPTS = 3;
    public static final int DEFAULT_RETRY_MAX_ATTEMPTS = 6;
    public static final long DEFAULT_INITIAL_RETRY_DELAY_MILLIS = 1000L;
    public static final long DEFAULT_MAX_RETRY_DELAY_MILLIS = 32000L;
    public static final double DEFAULT_RETRY_DELAY_BACKOFF_FACTOR = 2.0;
    private final int retryMinAttempts;
    private final int retryMaxAttempts;
    private final long initialRetryDelayMillis;
    private final long maxRetryDelayMillis;
    private final double retryDelayBackoffFactor;
    private final long totalRetryPeriodMillis;
    private static final RetryParams DEFAULT_INSTANCE = new RetryParams(new Builder());
    private static final RetryParams NO_RETRIES = RetryParams.newBuilder().setRetryMaxAttempts(1).setRetryMinAttempts(1).build();

    private RetryParams(Builder builder) {
        this.retryMinAttempts = builder.retryMinAttempts;
        this.retryMaxAttempts = builder.retryMaxAttempts;
        this.initialRetryDelayMillis = builder.initialRetryDelayMillis;
        this.maxRetryDelayMillis = builder.maxRetryDelayMillis;
        this.retryDelayBackoffFactor = builder.retryDelayBackoffFactor;
        this.totalRetryPeriodMillis = builder.totalRetryPeriodMillis;
        Preconditions.checkArgument((this.retryMinAttempts >= 0 ? 1 : 0) != 0, (Object)"retryMinAttempts must not be negative");
        Preconditions.checkArgument((this.retryMaxAttempts >= this.retryMinAttempts ? 1 : 0) != 0, (Object)"retryMaxAttempts must not be smaller than retryMinAttempts");
        Preconditions.checkArgument((this.initialRetryDelayMillis >= 0L ? 1 : 0) != 0, (Object)"initialRetryDelayMillis must not be negative");
        Preconditions.checkArgument((this.maxRetryDelayMillis >= this.initialRetryDelayMillis ? 1 : 0) != 0, (Object)"maxRetryDelayMillis must not be smaller than initialRetryDelayMillis");
        Preconditions.checkArgument((this.retryDelayBackoffFactor >= 0.0 ? 1 : 0) != 0, (Object)"retryDelayBackoffFactor must not be negative");
        Preconditions.checkArgument((this.totalRetryPeriodMillis >= 0L ? 1 : 0) != 0, (Object)"totalRetryPeriodMillis must not be negative");
    }

    public static RetryParams getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static RetryParams noRetries() {
        return NO_RETRIES;
    }

    public int getRetryMinAttempts() {
        return this.retryMinAttempts;
    }

    public int getRetryMaxAttempts() {
        return this.retryMaxAttempts;
    }

    public long getInitialRetryDelayMillis() {
        return this.initialRetryDelayMillis;
    }

    public long getMaxRetryDelayMillis() {
        return this.maxRetryDelayMillis;
    }

    public double getRetryDelayBackoffFactor() {
        return this.retryDelayBackoffFactor;
    }

    public long getTotalRetryPeriodMillis() {
        return this.totalRetryPeriodMillis;
    }

    public int hashCode() {
        return Objects.hash(this.retryMinAttempts, this.retryMaxAttempts, this.initialRetryDelayMillis, this.maxRetryDelayMillis, this.retryDelayBackoffFactor, this.totalRetryPeriodMillis);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetryParams)) {
            return false;
        }
        RetryParams other = (RetryParams)obj;
        return this.retryMinAttempts == other.retryMinAttempts && this.retryMaxAttempts == other.retryMaxAttempts && this.initialRetryDelayMillis == other.initialRetryDelayMillis && this.maxRetryDelayMillis == other.maxRetryDelayMillis && this.retryDelayBackoffFactor == other.retryDelayBackoffFactor && this.totalRetryPeriodMillis == other.totalRetryPeriodMillis;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        toStringHelper.add("retryMinAttempts", this.retryMinAttempts);
        toStringHelper.add("retryMaxAttempts", this.retryMaxAttempts);
        toStringHelper.add("initialRetryDelayMillis", this.initialRetryDelayMillis);
        toStringHelper.add("maxRetryDelayMillis", this.maxRetryDelayMillis);
        toStringHelper.add("retryDelayBackoffFactor", this.retryDelayBackoffFactor);
        toStringHelper.add("totalRetryPeriodMillis", this.totalRetryPeriodMillis);
        return toStringHelper.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private int retryMinAttempts;
        private int retryMaxAttempts;
        private long initialRetryDelayMillis;
        private long maxRetryDelayMillis;
        private double retryDelayBackoffFactor;
        private long totalRetryPeriodMillis;

        private Builder() {
            this((RetryParams)null);
        }

        Builder(RetryParams retryParams) {
            if (retryParams == null) {
                this.retryMinAttempts = 3;
                this.retryMaxAttempts = 6;
                this.initialRetryDelayMillis = 1000L;
                this.maxRetryDelayMillis = 32000L;
                this.retryDelayBackoffFactor = 2.0;
                this.totalRetryPeriodMillis = 50000L;
            } else {
                this.retryMinAttempts = retryParams.getRetryMinAttempts();
                this.retryMaxAttempts = retryParams.getRetryMaxAttempts();
                this.initialRetryDelayMillis = retryParams.getInitialRetryDelayMillis();
                this.maxRetryDelayMillis = retryParams.getMaxRetryDelayMillis();
                this.retryDelayBackoffFactor = retryParams.getRetryDelayBackoffFactor();
                this.totalRetryPeriodMillis = retryParams.getTotalRetryPeriodMillis();
            }
        }

        public Builder setRetryMinAttempts(int retryMinAttempts) {
            this.retryMinAttempts = retryMinAttempts;
            return this;
        }

        public Builder setRetryMaxAttempts(int retryMaxAttempts) {
            this.retryMaxAttempts = retryMaxAttempts;
            return this;
        }

        public Builder setInitialRetryDelayMillis(long initialRetryDelayMillis) {
            this.initialRetryDelayMillis = initialRetryDelayMillis;
            return this;
        }

        public Builder setMaxRetryDelayMillis(long maxRetryDelayMillis) {
            this.maxRetryDelayMillis = maxRetryDelayMillis;
            return this;
        }

        public Builder setRetryDelayBackoffFactor(double retryDelayBackoffFactor) {
            this.retryDelayBackoffFactor = retryDelayBackoffFactor;
            return this;
        }

        public Builder setTotalRetryPeriodMillis(long totalRetryPeriodMillis) {
            this.totalRetryPeriodMillis = totalRetryPeriodMillis;
            return this;
        }

        public RetryParams build() {
            return new RetryParams(this);
        }
    }
}

