/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateDocumentRequest;
import com.google.cloud.contentwarehouse.v1.CreateDocumentResponse;
import com.google.cloud.contentwarehouse.v1.DeleteDocumentRequest;
import com.google.cloud.contentwarehouse.v1.Document;
import com.google.cloud.contentwarehouse.v1.DocumentServiceClient;
import com.google.cloud.contentwarehouse.v1.FetchAclRequest;
import com.google.cloud.contentwarehouse.v1.FetchAclResponse;
import com.google.cloud.contentwarehouse.v1.GetDocumentRequest;
import com.google.cloud.contentwarehouse.v1.SearchDocumentsRequest;
import com.google.cloud.contentwarehouse.v1.SearchDocumentsResponse;
import com.google.cloud.contentwarehouse.v1.SetAclRequest;
import com.google.cloud.contentwarehouse.v1.SetAclResponse;
import com.google.cloud.contentwarehouse.v1.UpdateDocumentRequest;
import com.google.cloud.contentwarehouse.v1.UpdateDocumentResponse;
import com.google.cloud.contentwarehouse.v1.stub.DocumentServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.DocumentServiceStubSettings;
import com.google.cloud.contentwarehouse.v1.stub.GrpcDocumentServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcDocumentServiceStub
extends DocumentServiceStub {
    private static final MethodDescriptor<CreateDocumentRequest, CreateDocumentResponse> createDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.DocumentService/CreateDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CreateDocumentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetDocumentRequest, Document> getDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.DocumentService/GetDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Document.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateDocumentRequest, UpdateDocumentResponse> updateDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.DocumentService/UpdateDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)UpdateDocumentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteDocumentRequest, Empty> deleteDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.DocumentService/DeleteDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchDocumentsRequest, SearchDocumentsResponse> searchDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.DocumentService/SearchDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchDocumentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<FetchAclRequest, FetchAclResponse> fetchAclMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.DocumentService/FetchAcl").setRequestMarshaller(ProtoUtils.marshaller((Message)FetchAclRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FetchAclResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SetAclRequest, SetAclResponse> setAclMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.DocumentService/SetAcl").setRequestMarshaller(ProtoUtils.marshaller((Message)SetAclRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SetAclResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateDocumentRequest, CreateDocumentResponse> createDocumentCallable;
    private final UnaryCallable<GetDocumentRequest, Document> getDocumentCallable;
    private final UnaryCallable<UpdateDocumentRequest, UpdateDocumentResponse> updateDocumentCallable;
    private final UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable;
    private final UnaryCallable<SearchDocumentsRequest, SearchDocumentsResponse> searchDocumentsCallable;
    private final UnaryCallable<SearchDocumentsRequest, DocumentServiceClient.SearchDocumentsPagedResponse> searchDocumentsPagedCallable;
    private final UnaryCallable<FetchAclRequest, FetchAclResponse> fetchAclCallable;
    private final UnaryCallable<SetAclRequest, SetAclResponse> setAclCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDocumentServiceStub create(DocumentServiceStubSettings settings) throws IOException {
        return new GrpcDocumentServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDocumentServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDocumentServiceStub(DocumentServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDocumentServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDocumentServiceStub(DocumentServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDocumentServiceStub(DocumentServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDocumentServiceCallableFactory());
    }

    protected GrpcDocumentServiceStub(DocumentServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings searchDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchDocumentsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings fetchAclTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(fetchAclMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings setAclTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setAclMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        this.createDocumentCallable = callableFactory.createUnaryCallable(createDocumentTransportSettings, settings.createDocumentSettings(), clientContext);
        this.getDocumentCallable = callableFactory.createUnaryCallable(getDocumentTransportSettings, settings.getDocumentSettings(), clientContext);
        this.updateDocumentCallable = callableFactory.createUnaryCallable(updateDocumentTransportSettings, settings.updateDocumentSettings(), clientContext);
        this.deleteDocumentCallable = callableFactory.createUnaryCallable(deleteDocumentTransportSettings, settings.deleteDocumentSettings(), clientContext);
        this.searchDocumentsCallable = callableFactory.createUnaryCallable(searchDocumentsTransportSettings, settings.searchDocumentsSettings(), clientContext);
        this.searchDocumentsPagedCallable = callableFactory.createPagedCallable(searchDocumentsTransportSettings, settings.searchDocumentsSettings(), clientContext);
        this.fetchAclCallable = callableFactory.createUnaryCallable(fetchAclTransportSettings, settings.fetchAclSettings(), clientContext);
        this.setAclCallable = callableFactory.createUnaryCallable(setAclTransportSettings, settings.setAclSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateDocumentRequest, CreateDocumentResponse> createDocumentCallable() {
        return this.createDocumentCallable;
    }

    @Override
    public UnaryCallable<GetDocumentRequest, Document> getDocumentCallable() {
        return this.getDocumentCallable;
    }

    @Override
    public UnaryCallable<UpdateDocumentRequest, UpdateDocumentResponse> updateDocumentCallable() {
        return this.updateDocumentCallable;
    }

    @Override
    public UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable() {
        return this.deleteDocumentCallable;
    }

    @Override
    public UnaryCallable<SearchDocumentsRequest, SearchDocumentsResponse> searchDocumentsCallable() {
        return this.searchDocumentsCallable;
    }

    @Override
    public UnaryCallable<SearchDocumentsRequest, DocumentServiceClient.SearchDocumentsPagedResponse> searchDocumentsPagedCallable() {
        return this.searchDocumentsPagedCallable;
    }

    @Override
    public UnaryCallable<FetchAclRequest, FetchAclResponse> fetchAclCallable() {
        return this.fetchAclCallable;
    }

    @Override
    public UnaryCallable<SetAclRequest, SetAclResponse> setAclCallable() {
        return this.setAclCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

