/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.RunPipelineMetadata;
import com.google.cloud.contentwarehouse.v1.RunPipelineRequest;
import com.google.cloud.contentwarehouse.v1.RunPipelineResponse;
import com.google.cloud.contentwarehouse.v1.stub.GrpcPipelineServiceCallableFactory;
import com.google.cloud.contentwarehouse.v1.stub.PipelineServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.PipelineServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcPipelineServiceStub
extends PipelineServiceStub {
    private static final MethodDescriptor<RunPipelineRequest, Operation> runPipelineMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.PipelineService/RunPipeline").setRequestMarshaller(ProtoUtils.marshaller((Message)RunPipelineRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<RunPipelineRequest, Operation> runPipelineCallable;
    private final OperationCallable<RunPipelineRequest, RunPipelineResponse, RunPipelineMetadata> runPipelineOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPipelineServiceStub create(PipelineServiceStubSettings settings) throws IOException {
        return new GrpcPipelineServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPipelineServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcPipelineServiceStub(PipelineServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPipelineServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPipelineServiceStub(PipelineServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPipelineServiceStub(PipelineServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPipelineServiceCallableFactory());
    }

    protected GrpcPipelineServiceStub(PipelineServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings runPipelineTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(runPipelineMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.runPipelineCallable = callableFactory.createUnaryCallable(runPipelineTransportSettings, settings.runPipelineSettings(), clientContext);
        this.runPipelineOperationCallable = callableFactory.createOperationCallable(runPipelineTransportSettings, settings.runPipelineOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<RunPipelineRequest, Operation> runPipelineCallable() {
        return this.runPipelineCallable;
    }

    @Override
    public OperationCallable<RunPipelineRequest, RunPipelineResponse, RunPipelineMetadata> runPipelineOperationCallable() {
        return this.runPipelineOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

