/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.LocationName;
import com.google.cloud.contentwarehouse.v1.PipelineServiceSettings;
import com.google.cloud.contentwarehouse.v1.RunPipelineMetadata;
import com.google.cloud.contentwarehouse.v1.RunPipelineRequest;
import com.google.cloud.contentwarehouse.v1.RunPipelineResponse;
import com.google.cloud.contentwarehouse.v1.stub.PipelineServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.PipelineServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class PipelineServiceClient
implements BackgroundResource {
    private final PipelineServiceSettings settings;
    private final PipelineServiceStub stub;
    private final OperationsClient httpJsonOperationsClient;
    private final com.google.longrunning.OperationsClient operationsClient;

    public static final PipelineServiceClient create() throws IOException {
        return PipelineServiceClient.create(PipelineServiceSettings.newBuilder().build());
    }

    public static final PipelineServiceClient create(PipelineServiceSettings settings) throws IOException {
        return new PipelineServiceClient(settings);
    }

    public static final PipelineServiceClient create(PipelineServiceStub stub) {
        return new PipelineServiceClient(stub);
    }

    protected PipelineServiceClient(PipelineServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PipelineServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected PipelineServiceClient(PipelineServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final PipelineServiceSettings getSettings() {
        return this.settings;
    }

    public PipelineServiceStub getStub() {
        return this.stub;
    }

    public final com.google.longrunning.OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<RunPipelineResponse, RunPipelineMetadata> runPipelineAsync(LocationName name) {
        RunPipelineRequest request = RunPipelineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.runPipelineAsync(request);
    }

    public final OperationFuture<RunPipelineResponse, RunPipelineMetadata> runPipelineAsync(String name) {
        RunPipelineRequest request = RunPipelineRequest.newBuilder().setName(name).build();
        return this.runPipelineAsync(request);
    }

    public final OperationFuture<RunPipelineResponse, RunPipelineMetadata> runPipelineAsync(RunPipelineRequest request) {
        return this.runPipelineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RunPipelineRequest, RunPipelineResponse, RunPipelineMetadata> runPipelineOperationCallable() {
        return this.stub.runPipelineOperationCallable();
    }

    public final UnaryCallable<RunPipelineRequest, Operation> runPipelineCallable() {
        return this.stub.runPipelineCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

