/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateDocumentLinkRequest;
import com.google.cloud.contentwarehouse.v1.DeleteDocumentLinkRequest;
import com.google.cloud.contentwarehouse.v1.DocumentLink;
import com.google.cloud.contentwarehouse.v1.DocumentLinkServiceClient;
import com.google.cloud.contentwarehouse.v1.ListLinkedSourcesRequest;
import com.google.cloud.contentwarehouse.v1.ListLinkedSourcesResponse;
import com.google.cloud.contentwarehouse.v1.ListLinkedTargetsRequest;
import com.google.cloud.contentwarehouse.v1.ListLinkedTargetsResponse;
import com.google.cloud.contentwarehouse.v1.stub.DocumentLinkServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.DocumentLinkServiceStubSettings;
import com.google.cloud.contentwarehouse.v1.stub.GrpcDocumentLinkServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcDocumentLinkServiceStub
extends DocumentLinkServiceStub {
    private static final MethodDescriptor<ListLinkedTargetsRequest, ListLinkedTargetsResponse> listLinkedTargetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.DocumentLinkService/ListLinkedTargets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLinkedTargetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLinkedTargetsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLinkedSourcesRequest, ListLinkedSourcesResponse> listLinkedSourcesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.DocumentLinkService/ListLinkedSources").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLinkedSourcesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLinkedSourcesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateDocumentLinkRequest, DocumentLink> createDocumentLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.DocumentLinkService/CreateDocumentLink").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDocumentLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DocumentLink.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteDocumentLinkRequest, Empty> deleteDocumentLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.DocumentLinkService/DeleteDocumentLink").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDocumentLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final UnaryCallable<ListLinkedTargetsRequest, ListLinkedTargetsResponse> listLinkedTargetsCallable;
    private final UnaryCallable<ListLinkedSourcesRequest, ListLinkedSourcesResponse> listLinkedSourcesCallable;
    private final UnaryCallable<ListLinkedSourcesRequest, DocumentLinkServiceClient.ListLinkedSourcesPagedResponse> listLinkedSourcesPagedCallable;
    private final UnaryCallable<CreateDocumentLinkRequest, DocumentLink> createDocumentLinkCallable;
    private final UnaryCallable<DeleteDocumentLinkRequest, Empty> deleteDocumentLinkCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDocumentLinkServiceStub create(DocumentLinkServiceStubSettings settings) throws IOException {
        return new GrpcDocumentLinkServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDocumentLinkServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDocumentLinkServiceStub(DocumentLinkServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDocumentLinkServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDocumentLinkServiceStub(DocumentLinkServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDocumentLinkServiceStub(DocumentLinkServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDocumentLinkServiceCallableFactory());
    }

    protected GrpcDocumentLinkServiceStub(DocumentLinkServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listLinkedTargetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLinkedTargetsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listLinkedSourcesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLinkedSourcesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings createDocumentLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDocumentLinkMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings deleteDocumentLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDocumentLinkMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.listLinkedTargetsCallable = callableFactory.createUnaryCallable(listLinkedTargetsTransportSettings, settings.listLinkedTargetsSettings(), clientContext);
        this.listLinkedSourcesCallable = callableFactory.createUnaryCallable(listLinkedSourcesTransportSettings, settings.listLinkedSourcesSettings(), clientContext);
        this.listLinkedSourcesPagedCallable = callableFactory.createPagedCallable(listLinkedSourcesTransportSettings, settings.listLinkedSourcesSettings(), clientContext);
        this.createDocumentLinkCallable = callableFactory.createUnaryCallable(createDocumentLinkTransportSettings, settings.createDocumentLinkSettings(), clientContext);
        this.deleteDocumentLinkCallable = callableFactory.createUnaryCallable(deleteDocumentLinkTransportSettings, settings.deleteDocumentLinkSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListLinkedTargetsRequest, ListLinkedTargetsResponse> listLinkedTargetsCallable() {
        return this.listLinkedTargetsCallable;
    }

    @Override
    public UnaryCallable<ListLinkedSourcesRequest, ListLinkedSourcesResponse> listLinkedSourcesCallable() {
        return this.listLinkedSourcesCallable;
    }

    @Override
    public UnaryCallable<ListLinkedSourcesRequest, DocumentLinkServiceClient.ListLinkedSourcesPagedResponse> listLinkedSourcesPagedCallable() {
        return this.listLinkedSourcesPagedCallable;
    }

    @Override
    public UnaryCallable<CreateDocumentLinkRequest, DocumentLink> createDocumentLinkCallable() {
        return this.createDocumentLinkCallable;
    }

    @Override
    public UnaryCallable<DeleteDocumentLinkRequest, Empty> deleteDocumentLinkCallable() {
        return this.deleteDocumentLinkCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

