/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.ListRegionZonesRequest;
import com.google.cloud.compute.v1.RegionZonesSettings;
import com.google.cloud.compute.v1.Zone;
import com.google.cloud.compute.v1.ZoneList;
import com.google.cloud.compute.v1.stub.RegionZonesStub;
import com.google.cloud.compute.v1.stub.RegionZonesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionZonesClient
implements BackgroundResource {
    private final RegionZonesSettings settings;
    private final RegionZonesStub stub;

    public static final RegionZonesClient create() throws IOException {
        return RegionZonesClient.create(RegionZonesSettings.newBuilder().build());
    }

    public static final RegionZonesClient create(RegionZonesSettings settings) throws IOException {
        return new RegionZonesClient(settings);
    }

    public static final RegionZonesClient create(RegionZonesStub stub) {
        return new RegionZonesClient(stub);
    }

    protected RegionZonesClient(RegionZonesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionZonesStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionZonesClient(RegionZonesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionZonesSettings getSettings() {
        return this.settings;
    }

    public RegionZonesStub getStub() {
        return this.stub;
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionZonesRequest request = ListRegionZonesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionZonesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionZonesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionZonesRequest, ZoneList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionZonesRequest, ZoneList, Zone, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionZonesRequest, ZoneList, Zone, ListPage> {
        private ListPage(PageContext<ListRegionZonesRequest, ZoneList, Zone> context, ZoneList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionZonesRequest, ZoneList, Zone> context, ZoneList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionZonesRequest, ZoneList, Zone> context, ApiFuture<ZoneList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionZonesRequest, ZoneList, Zone, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionZonesRequest, ZoneList, Zone> context, ApiFuture<ZoneList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

