/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.GetIamPolicyInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.GetInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.GetOperationalStatusInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.GlobalSetPolicyRequest;
import com.google.cloud.compute.v1.InsertInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.InterconnectAttachmentGroup;
import com.google.cloud.compute.v1.InterconnectAttachmentGroupsGetOperationalStatusResponse;
import com.google.cloud.compute.v1.InterconnectAttachmentGroupsListResponse;
import com.google.cloud.compute.v1.InterconnectAttachmentGroupsSettings;
import com.google.cloud.compute.v1.ListInterconnectAttachmentGroupsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.TestIamPermissionsInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.InterconnectAttachmentGroupsStub;
import com.google.cloud.compute.v1.stub.InterconnectAttachmentGroupsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InterconnectAttachmentGroupsClient
implements BackgroundResource {
    private final InterconnectAttachmentGroupsSettings settings;
    private final InterconnectAttachmentGroupsStub stub;

    public static final InterconnectAttachmentGroupsClient create() throws IOException {
        return InterconnectAttachmentGroupsClient.create(InterconnectAttachmentGroupsSettings.newBuilder().build());
    }

    public static final InterconnectAttachmentGroupsClient create(InterconnectAttachmentGroupsSettings settings) throws IOException {
        return new InterconnectAttachmentGroupsClient(settings);
    }

    public static final InterconnectAttachmentGroupsClient create(InterconnectAttachmentGroupsStub stub) {
        return new InterconnectAttachmentGroupsClient(stub);
    }

    protected InterconnectAttachmentGroupsClient(InterconnectAttachmentGroupsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InterconnectAttachmentGroupsStubSettings)settings.getStubSettings()).createStub();
    }

    protected InterconnectAttachmentGroupsClient(InterconnectAttachmentGroupsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InterconnectAttachmentGroupsSettings getSettings() {
        return this.settings;
    }

    public InterconnectAttachmentGroupsStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String interconnectAttachmentGroup) {
        DeleteInterconnectAttachmentGroupRequest request = DeleteInterconnectAttachmentGroupRequest.newBuilder().setProject(project).setInterconnectAttachmentGroup(interconnectAttachmentGroup).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteInterconnectAttachmentGroupRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInterconnectAttachmentGroupRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteInterconnectAttachmentGroupRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final InterconnectAttachmentGroup get(String project, String interconnectAttachmentGroup) {
        GetInterconnectAttachmentGroupRequest request = GetInterconnectAttachmentGroupRequest.newBuilder().setProject(project).setInterconnectAttachmentGroup(interconnectAttachmentGroup).build();
        return this.get(request);
    }

    public final InterconnectAttachmentGroup get(GetInterconnectAttachmentGroupRequest request) {
        return (InterconnectAttachmentGroup)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInterconnectAttachmentGroupRequest, InterconnectAttachmentGroup> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String resource) {
        GetIamPolicyInterconnectAttachmentGroupRequest request = GetIamPolicyInterconnectAttachmentGroupRequest.newBuilder().setProject(project).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyInterconnectAttachmentGroupRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyInterconnectAttachmentGroupRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final InterconnectAttachmentGroupsGetOperationalStatusResponse getOperationalStatus(String project, String interconnectAttachmentGroup) {
        GetOperationalStatusInterconnectAttachmentGroupRequest request = GetOperationalStatusInterconnectAttachmentGroupRequest.newBuilder().setProject(project).setInterconnectAttachmentGroup(interconnectAttachmentGroup).build();
        return this.getOperationalStatus(request);
    }

    public final InterconnectAttachmentGroupsGetOperationalStatusResponse getOperationalStatus(GetOperationalStatusInterconnectAttachmentGroupRequest request) {
        return (InterconnectAttachmentGroupsGetOperationalStatusResponse)this.getOperationalStatusCallable().call((Object)request);
    }

    public final UnaryCallable<GetOperationalStatusInterconnectAttachmentGroupRequest, InterconnectAttachmentGroupsGetOperationalStatusResponse> getOperationalStatusCallable() {
        return this.stub.getOperationalStatusCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, InterconnectAttachmentGroup interconnectAttachmentGroupResource) {
        InsertInterconnectAttachmentGroupRequest request = InsertInterconnectAttachmentGroupRequest.newBuilder().setProject(project).setInterconnectAttachmentGroupResource(interconnectAttachmentGroupResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertInterconnectAttachmentGroupRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertInterconnectAttachmentGroupRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertInterconnectAttachmentGroupRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListInterconnectAttachmentGroupsRequest request = ListInterconnectAttachmentGroupsRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListInterconnectAttachmentGroupsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInterconnectAttachmentGroupsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String interconnectAttachmentGroup, InterconnectAttachmentGroup interconnectAttachmentGroupResource) {
        PatchInterconnectAttachmentGroupRequest request = PatchInterconnectAttachmentGroupRequest.newBuilder().setProject(project).setInterconnectAttachmentGroup(interconnectAttachmentGroup).setInterconnectAttachmentGroupResource(interconnectAttachmentGroupResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchInterconnectAttachmentGroupRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchInterconnectAttachmentGroupRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchInterconnectAttachmentGroupRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Policy setIamPolicy(String project, String resource, GlobalSetPolicyRequest globalSetPolicyRequestResource) {
        SetIamPolicyInterconnectAttachmentGroupRequest request = SetIamPolicyInterconnectAttachmentGroupRequest.newBuilder().setProject(project).setResource(resource).setGlobalSetPolicyRequestResource(globalSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyInterconnectAttachmentGroupRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyInterconnectAttachmentGroupRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsInterconnectAttachmentGroupRequest request = TestIamPermissionsInterconnectAttachmentGroupRequest.newBuilder().setProject(project).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsInterconnectAttachmentGroupRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsInterconnectAttachmentGroupRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroup, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroup, ListPage> {
        private ListPage(PageContext<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroup> context, InterconnectAttachmentGroupsListResponse response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroup> context, InterconnectAttachmentGroupsListResponse response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroup> context, ApiFuture<InterconnectAttachmentGroupsListResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroup, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroup> context, ApiFuture<InterconnectAttachmentGroupsListResponse> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

