/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionUrlMapRequest;
import com.google.cloud.compute.v1.GetRegionUrlMapRequest;
import com.google.cloud.compute.v1.InsertRegionUrlMapRequest;
import com.google.cloud.compute.v1.ListRegionUrlMapsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionUrlMapRequest;
import com.google.cloud.compute.v1.RegionUrlMapsClient;
import com.google.cloud.compute.v1.UpdateRegionUrlMapRequest;
import com.google.cloud.compute.v1.UrlMap;
import com.google.cloud.compute.v1.UrlMapList;
import com.google.cloud.compute.v1.UrlMapsValidateResponse;
import com.google.cloud.compute.v1.ValidateRegionUrlMapRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionOperationsStub;
import com.google.cloud.compute.v1.stub.HttpJsonRegionUrlMapsCallableFactory;
import com.google.cloud.compute.v1.stub.RegionUrlMapsStub;
import com.google.cloud.compute.v1.stub.RegionUrlMapsStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonRegionUrlMapsStub
extends RegionUrlMapsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Operation.getDescriptor()).build();
    private static final ApiMethodDescriptor<DeleteRegionUrlMapRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionUrlMaps/Delete").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/urlMaps/{urlMap}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        serializer.putPathParam(fields, "urlMap", (Object)request.getUrlMap());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<GetRegionUrlMapRequest, UrlMap> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionUrlMaps/Get").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/urlMaps/{urlMap}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        serializer.putPathParam(fields, "urlMap", (Object)request.getUrlMap());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)UrlMap.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<InsertRegionUrlMapRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionUrlMaps/Insert").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/urlMaps", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("urlMapResource", (Message)request.getUrlMapResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<ListRegionUrlMapsRequest, UrlMapList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionUrlMaps/List").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/urlMaps", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)UrlMapList.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<PatchRegionUrlMapRequest, Operation> patchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionUrlMaps/Patch").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/urlMaps/{urlMap}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        serializer.putPathParam(fields, "urlMap", (Object)request.getUrlMap());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("urlMapResource", (Message)request.getUrlMapResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<UpdateRegionUrlMapRequest, Operation> updateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionUrlMaps/Update").setHttpMethod("PUT").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/urlMaps/{urlMap}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        serializer.putPathParam(fields, "urlMap", (Object)request.getUrlMap());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("urlMapResource", (Message)request.getUrlMapResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<ValidateRegionUrlMapRequest, UrlMapsValidateResponse> validateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionUrlMaps/Validate").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/urlMaps/{urlMap}/validate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        serializer.putPathParam(fields, "urlMap", (Object)request.getUrlMap());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("regionUrlMapsValidateRequestResource", (Message)request.getRegionUrlMapsValidateRequestResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)UrlMapsValidateResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<DeleteRegionUrlMapRequest, Operation> deleteCallable;
    private final OperationCallable<DeleteRegionUrlMapRequest, Operation, Operation> deleteOperationCallable;
    private final UnaryCallable<GetRegionUrlMapRequest, UrlMap> getCallable;
    private final UnaryCallable<InsertRegionUrlMapRequest, Operation> insertCallable;
    private final OperationCallable<InsertRegionUrlMapRequest, Operation, Operation> insertOperationCallable;
    private final UnaryCallable<ListRegionUrlMapsRequest, UrlMapList> listCallable;
    private final UnaryCallable<ListRegionUrlMapsRequest, RegionUrlMapsClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<PatchRegionUrlMapRequest, Operation> patchCallable;
    private final OperationCallable<PatchRegionUrlMapRequest, Operation, Operation> patchOperationCallable;
    private final UnaryCallable<UpdateRegionUrlMapRequest, Operation> updateCallable;
    private final OperationCallable<UpdateRegionUrlMapRequest, Operation, Operation> updateOperationCallable;
    private final UnaryCallable<ValidateRegionUrlMapRequest, UrlMapsValidateResponse> validateCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonRegionOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRegionUrlMapsStub create(RegionUrlMapsStubSettings settings) throws IOException {
        return new HttpJsonRegionUrlMapsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRegionUrlMapsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRegionUrlMapsStub(RegionUrlMapsStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonRegionUrlMapsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRegionUrlMapsStub(RegionUrlMapsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRegionUrlMapsStub(RegionUrlMapsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRegionUrlMapsCallableFactory());
    }

    protected HttpJsonRegionUrlMapsStub(RegionUrlMapsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonRegionOperationsStub.create(clientContext, callableFactory);
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("region", String.valueOf(request.getRegion()));
            builder.add("url_map", String.valueOf(request.getUrlMap()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("region", String.valueOf(request.getRegion()));
            builder.add("url_map", String.valueOf(request.getUrlMap()));
            return builder.build();
        }).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("region", String.valueOf(request.getRegion()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("region", String.valueOf(request.getRegion()));
            return builder.build();
        }).build();
        HttpJsonCallSettings patchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("region", String.valueOf(request.getRegion()));
            builder.add("url_map", String.valueOf(request.getUrlMap()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("region", String.valueOf(request.getRegion()));
            builder.add("url_map", String.valueOf(request.getUrlMap()));
            return builder.build();
        }).build();
        HttpJsonCallSettings validateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(validateMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("region", String.valueOf(request.getRegion()));
            builder.add("url_map", String.valueOf(request.getUrlMap()));
            return builder.build();
        }).build();
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.deleteOperationCallable = callableFactory.createOperationCallable(deleteTransportSettings, settings.deleteOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.insertOperationCallable = callableFactory.createOperationCallable(insertTransportSettings, settings.insertOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.patchCallable = callableFactory.createUnaryCallable(patchTransportSettings, settings.patchSettings(), clientContext);
        this.patchOperationCallable = callableFactory.createOperationCallable(patchTransportSettings, settings.patchOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateCallable = callableFactory.createUnaryCallable(updateTransportSettings, settings.updateSettings(), clientContext);
        this.updateOperationCallable = callableFactory.createOperationCallable(updateTransportSettings, settings.updateOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.validateCallable = callableFactory.createUnaryCallable(validateTransportSettings, settings.validateSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(deleteMethodDescriptor);
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(insertMethodDescriptor);
        methodDescriptors.add(listMethodDescriptor);
        methodDescriptors.add(patchMethodDescriptor);
        methodDescriptors.add(updateMethodDescriptor);
        methodDescriptors.add(validateMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<DeleteRegionUrlMapRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public OperationCallable<DeleteRegionUrlMapRequest, Operation, Operation> deleteOperationCallable() {
        return this.deleteOperationCallable;
    }

    @Override
    public UnaryCallable<GetRegionUrlMapRequest, UrlMap> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<InsertRegionUrlMapRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public OperationCallable<InsertRegionUrlMapRequest, Operation, Operation> insertOperationCallable() {
        return this.insertOperationCallable;
    }

    @Override
    public UnaryCallable<ListRegionUrlMapsRequest, UrlMapList> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ListRegionUrlMapsRequest, RegionUrlMapsClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<PatchRegionUrlMapRequest, Operation> patchCallable() {
        return this.patchCallable;
    }

    @Override
    public OperationCallable<PatchRegionUrlMapRequest, Operation, Operation> patchOperationCallable() {
        return this.patchOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateRegionUrlMapRequest, Operation> updateCallable() {
        return this.updateCallable;
    }

    @Override
    public OperationCallable<UpdateRegionUrlMapRequest, Operation, Operation> updateOperationCallable() {
        return this.updateOperationCallable;
    }

    @Override
    public UnaryCallable<ValidateRegionUrlMapRequest, UrlMapsValidateResponse> validateCallable() {
        return this.validateCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

