/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListStoragePoolTypesRequest;
import com.google.cloud.compute.v1.GetStoragePoolTypeRequest;
import com.google.cloud.compute.v1.ListStoragePoolTypesRequest;
import com.google.cloud.compute.v1.StoragePoolType;
import com.google.cloud.compute.v1.StoragePoolTypeAggregatedList;
import com.google.cloud.compute.v1.StoragePoolTypeList;
import com.google.cloud.compute.v1.StoragePoolTypesClient;
import com.google.cloud.compute.v1.StoragePoolTypesScopedList;
import com.google.cloud.compute.v1.stub.HttpJsonStoragePoolTypesStub;
import com.google.cloud.compute.v1.stub.StoragePoolTypesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StoragePoolTypesStubSettings
extends StubSettings<StoragePoolTypesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, StoragePoolTypesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<GetStoragePoolTypeRequest, StoragePoolType> getSettings;
    private final PagedCallSettings<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolTypesClient.ListPagedResponse> listSettings;
    private static final PagedListDescriptor<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, Map.Entry<String, StoragePoolTypesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, Map.Entry<String, StoragePoolTypesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListStoragePoolTypesRequest injectToken(AggregatedListStoragePoolTypesRequest payload, String token) {
            return AggregatedListStoragePoolTypesRequest.newBuilder((AggregatedListStoragePoolTypesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListStoragePoolTypesRequest injectPageSize(AggregatedListStoragePoolTypesRequest payload, int pageSize) {
            return AggregatedListStoragePoolTypesRequest.newBuilder((AggregatedListStoragePoolTypesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListStoragePoolTypesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(StoragePoolTypeAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, StoragePoolTypesScopedList>> extractResources(StoragePoolTypeAggregatedList payload) {
            return payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolType> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolType>(){

        public String emptyToken() {
            return "";
        }

        public ListStoragePoolTypesRequest injectToken(ListStoragePoolTypesRequest payload, String token) {
            return ListStoragePoolTypesRequest.newBuilder((ListStoragePoolTypesRequest)payload).setPageToken(token).build();
        }

        public ListStoragePoolTypesRequest injectPageSize(ListStoragePoolTypesRequest payload, int pageSize) {
            return ListStoragePoolTypesRequest.newBuilder((ListStoragePoolTypesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListStoragePoolTypesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(StoragePoolTypeList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<StoragePoolType> extractResources(StoragePoolTypeList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, StoragePoolTypesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, StoragePoolTypesClient.AggregatedListPagedResponse>(){

        public ApiFuture<StoragePoolTypesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList> callable, AggregatedListStoragePoolTypesRequest request, ApiCallContext context, ApiFuture<StoragePoolTypeAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StoragePoolTypesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, Map.Entry<String, StoragePoolTypesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolTypesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolTypesClient.ListPagedResponse>(){

        public ApiFuture<StoragePoolTypesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListStoragePoolTypesRequest, StoragePoolTypeList> callable, ListStoragePoolTypesRequest request, ApiCallContext context, ApiFuture<StoragePoolTypeList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StoragePoolTypesClient.ListPagedResponse.createAsync((PageContext<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolType>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, StoragePoolTypesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<GetStoragePoolTypeRequest, StoragePoolType> getSettings() {
        return this.getSettings;
    }

    public PagedCallSettings<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolTypesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public StoragePoolTypesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonStoragePoolTypesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return StoragePoolTypesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(StoragePoolTypesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected StoragePoolTypesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<StoragePoolTypesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, StoragePoolTypesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<GetStoragePoolTypeRequest, StoragePoolType> getSettings;
        private final PagedCallSettings.Builder<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolTypesClient.ListPagedResponse> listSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.getSettings, this.listSettings);
            Builder.initDefaults(this);
        }

        protected Builder(StoragePoolTypesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.getSettings, this.listSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(StoragePoolTypesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)StoragePoolTypesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)StoragePoolTypesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(StoragePoolTypesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, StoragePoolTypesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<GetStoragePoolTypeRequest, StoragePoolType> getSettings() {
            return this.getSettings;
        }

        public PagedCallSettings.Builder<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolTypesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public StoragePoolTypesStubSettings build() throws IOException {
            return new StoragePoolTypesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

