/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListPublicDelegatedPrefixesRequest;
import com.google.cloud.compute.v1.AnnouncePublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.DeletePublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.GetPublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.InsertPublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.ListPublicDelegatedPrefixesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchPublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.PublicDelegatedPrefix;
import com.google.cloud.compute.v1.PublicDelegatedPrefixAggregatedList;
import com.google.cloud.compute.v1.PublicDelegatedPrefixList;
import com.google.cloud.compute.v1.PublicDelegatedPrefixesClient;
import com.google.cloud.compute.v1.PublicDelegatedPrefixesScopedList;
import com.google.cloud.compute.v1.WithdrawPublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.stub.HttpJsonPublicDelegatedPrefixesStub;
import com.google.cloud.compute.v1.stub.PublicDelegatedPrefixesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class PublicDelegatedPrefixesStubSettings
extends StubSettings<PublicDelegatedPrefixesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, PublicDelegatedPrefixesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<AnnouncePublicDelegatedPrefixeRequest, Operation> announceSettings;
    private final OperationCallSettings<AnnouncePublicDelegatedPrefixeRequest, Operation, Operation> announceOperationSettings;
    private final UnaryCallSettings<DeletePublicDelegatedPrefixeRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeletePublicDelegatedPrefixeRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetPublicDelegatedPrefixeRequest, PublicDelegatedPrefix> getSettings;
    private final UnaryCallSettings<InsertPublicDelegatedPrefixeRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertPublicDelegatedPrefixeRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefixesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchPublicDelegatedPrefixeRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchPublicDelegatedPrefixeRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<WithdrawPublicDelegatedPrefixeRequest, Operation> withdrawSettings;
    private final OperationCallSettings<WithdrawPublicDelegatedPrefixeRequest, Operation, Operation> withdrawOperationSettings;
    private static final PagedListDescriptor<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, Map.Entry<String, PublicDelegatedPrefixesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, Map.Entry<String, PublicDelegatedPrefixesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListPublicDelegatedPrefixesRequest injectToken(AggregatedListPublicDelegatedPrefixesRequest payload, String token) {
            return AggregatedListPublicDelegatedPrefixesRequest.newBuilder((AggregatedListPublicDelegatedPrefixesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListPublicDelegatedPrefixesRequest injectPageSize(AggregatedListPublicDelegatedPrefixesRequest payload, int pageSize) {
            return AggregatedListPublicDelegatedPrefixesRequest.newBuilder((AggregatedListPublicDelegatedPrefixesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListPublicDelegatedPrefixesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(PublicDelegatedPrefixAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, PublicDelegatedPrefixesScopedList>> extractResources(PublicDelegatedPrefixAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix>(){

        public String emptyToken() {
            return "";
        }

        public ListPublicDelegatedPrefixesRequest injectToken(ListPublicDelegatedPrefixesRequest payload, String token) {
            return ListPublicDelegatedPrefixesRequest.newBuilder((ListPublicDelegatedPrefixesRequest)payload).setPageToken(token).build();
        }

        public ListPublicDelegatedPrefixesRequest injectPageSize(ListPublicDelegatedPrefixesRequest payload, int pageSize) {
            return ListPublicDelegatedPrefixesRequest.newBuilder((ListPublicDelegatedPrefixesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListPublicDelegatedPrefixesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(PublicDelegatedPrefixList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PublicDelegatedPrefix> extractResources(PublicDelegatedPrefixList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, PublicDelegatedPrefixesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, PublicDelegatedPrefixesClient.AggregatedListPagedResponse>(){

        public ApiFuture<PublicDelegatedPrefixesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList> callable, AggregatedListPublicDelegatedPrefixesRequest request, ApiCallContext context, ApiFuture<PublicDelegatedPrefixAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PublicDelegatedPrefixesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, Map.Entry<String, PublicDelegatedPrefixesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefixesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefixesClient.ListPagedResponse>(){

        public ApiFuture<PublicDelegatedPrefixesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList> callable, ListPublicDelegatedPrefixesRequest request, ApiCallContext context, ApiFuture<PublicDelegatedPrefixList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PublicDelegatedPrefixesClient.ListPagedResponse.createAsync((PageContext<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, PublicDelegatedPrefixesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<AnnouncePublicDelegatedPrefixeRequest, Operation> announceSettings() {
        return this.announceSettings;
    }

    public OperationCallSettings<AnnouncePublicDelegatedPrefixeRequest, Operation, Operation> announceOperationSettings() {
        return this.announceOperationSettings;
    }

    public UnaryCallSettings<DeletePublicDelegatedPrefixeRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeletePublicDelegatedPrefixeRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetPublicDelegatedPrefixeRequest, PublicDelegatedPrefix> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertPublicDelegatedPrefixeRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertPublicDelegatedPrefixeRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefixesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchPublicDelegatedPrefixeRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchPublicDelegatedPrefixeRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<WithdrawPublicDelegatedPrefixeRequest, Operation> withdrawSettings() {
        return this.withdrawSettings;
    }

    public OperationCallSettings<WithdrawPublicDelegatedPrefixeRequest, Operation, Operation> withdrawOperationSettings() {
        return this.withdrawOperationSettings;
    }

    public PublicDelegatedPrefixesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPublicDelegatedPrefixesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PublicDelegatedPrefixesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PublicDelegatedPrefixesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PublicDelegatedPrefixesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.announceSettings = settingsBuilder.announceSettings().build();
        this.announceOperationSettings = settingsBuilder.announceOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.withdrawSettings = settingsBuilder.withdrawSettings().build();
        this.withdrawOperationSettings = settingsBuilder.withdrawOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PublicDelegatedPrefixesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, PublicDelegatedPrefixesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<AnnouncePublicDelegatedPrefixeRequest, Operation> announceSettings;
        private final OperationCallSettings.Builder<AnnouncePublicDelegatedPrefixeRequest, Operation, Operation> announceOperationSettings;
        private final UnaryCallSettings.Builder<DeletePublicDelegatedPrefixeRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeletePublicDelegatedPrefixeRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetPublicDelegatedPrefixeRequest, PublicDelegatedPrefix> getSettings;
        private final UnaryCallSettings.Builder<InsertPublicDelegatedPrefixeRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertPublicDelegatedPrefixeRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefixesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchPublicDelegatedPrefixeRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchPublicDelegatedPrefixeRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<WithdrawPublicDelegatedPrefixeRequest, Operation> withdrawSettings;
        private final OperationCallSettings.Builder<WithdrawPublicDelegatedPrefixeRequest, Operation, Operation> withdrawOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.announceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.announceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.withdrawSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.withdrawOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.announceSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.withdrawSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PublicDelegatedPrefixesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.announceSettings = settings.announceSettings.toBuilder();
            this.announceOperationSettings = settings.announceOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.withdrawSettings = settings.withdrawSettings.toBuilder();
            this.withdrawOperationSettings = settings.withdrawOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.announceSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.withdrawSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PublicDelegatedPrefixesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PublicDelegatedPrefixesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PublicDelegatedPrefixesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PublicDelegatedPrefixesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.announceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.withdrawSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.announceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.withdrawOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixAggregatedList, PublicDelegatedPrefixesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<AnnouncePublicDelegatedPrefixeRequest, Operation> announceSettings() {
            return this.announceSettings;
        }

        public OperationCallSettings.Builder<AnnouncePublicDelegatedPrefixeRequest, Operation, Operation> announceOperationSettings() {
            return this.announceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeletePublicDelegatedPrefixeRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeletePublicDelegatedPrefixeRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetPublicDelegatedPrefixeRequest, PublicDelegatedPrefix> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertPublicDelegatedPrefixeRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertPublicDelegatedPrefixeRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefixesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchPublicDelegatedPrefixeRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchPublicDelegatedPrefixeRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<WithdrawPublicDelegatedPrefixeRequest, Operation> withdrawSettings() {
            return this.withdrawSettings;
        }

        public OperationCallSettings.Builder<WithdrawPublicDelegatedPrefixeRequest, Operation, Operation> withdrawOperationSettings() {
            return this.withdrawOperationSettings;
        }

        public PublicDelegatedPrefixesStubSettings build() throws IOException {
            return new PublicDelegatedPrefixesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

