/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListTargetHttpsProxiesRequest;
import com.google.cloud.compute.v1.DeleteTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.GetTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.InsertTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.ListTargetHttpsProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetQuicOverrideTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetSslCertificatesTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetSslPolicyTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetUrlMapTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.TargetHttpsProxiesClient;
import com.google.cloud.compute.v1.TargetHttpsProxiesScopedList;
import com.google.cloud.compute.v1.TargetHttpsProxy;
import com.google.cloud.compute.v1.TargetHttpsProxyAggregatedList;
import com.google.cloud.compute.v1.TargetHttpsProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetHttpsProxiesStub;
import com.google.cloud.compute.v1.stub.TargetHttpsProxiesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class TargetHttpsProxiesStubSettings
extends StubSettings<TargetHttpsProxiesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteTargetHttpsProxyRequest, Operation> deleteSettings;
    private final UnaryCallSettings<GetTargetHttpsProxyRequest, TargetHttpsProxy> getSettings;
    private final UnaryCallSettings<InsertTargetHttpsProxyRequest, Operation> insertSettings;
    private final PagedCallSettings<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxiesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchTargetHttpsProxyRequest, Operation> patchSettings;
    private final UnaryCallSettings<SetQuicOverrideTargetHttpsProxyRequest, Operation> setQuicOverrideSettings;
    private final UnaryCallSettings<SetSslCertificatesTargetHttpsProxyRequest, Operation> setSslCertificatesSettings;
    private final UnaryCallSettings<SetSslPolicyTargetHttpsProxyRequest, Operation> setSslPolicySettings;
    private final UnaryCallSettings<SetUrlMapTargetHttpsProxyRequest, Operation> setUrlMapSettings;
    private static final PagedListDescriptor<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, Map.Entry<String, TargetHttpsProxiesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, Map.Entry<String, TargetHttpsProxiesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListTargetHttpsProxiesRequest injectToken(AggregatedListTargetHttpsProxiesRequest payload, String token) {
            return AggregatedListTargetHttpsProxiesRequest.newBuilder((AggregatedListTargetHttpsProxiesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListTargetHttpsProxiesRequest injectPageSize(AggregatedListTargetHttpsProxiesRequest payload, int pageSize) {
            return AggregatedListTargetHttpsProxiesRequest.newBuilder((AggregatedListTargetHttpsProxiesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListTargetHttpsProxiesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetHttpsProxyAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, TargetHttpsProxiesScopedList>> extractResources(TargetHttpsProxyAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetHttpsProxiesRequest injectToken(ListTargetHttpsProxiesRequest payload, String token) {
            return ListTargetHttpsProxiesRequest.newBuilder((ListTargetHttpsProxiesRequest)payload).setPageToken(token).build();
        }

        public ListTargetHttpsProxiesRequest injectPageSize(ListTargetHttpsProxiesRequest payload, int pageSize) {
            return ListTargetHttpsProxiesRequest.newBuilder((ListTargetHttpsProxiesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListTargetHttpsProxiesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetHttpsProxyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetHttpsProxy> extractResources(TargetHttpsProxyList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesClient.AggregatedListPagedResponse>(){

        public ApiFuture<TargetHttpsProxiesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList> callable, AggregatedListTargetHttpsProxiesRequest request, ApiCallContext context, ApiFuture<TargetHttpsProxyAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetHttpsProxiesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, Map.Entry<String, TargetHttpsProxiesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxiesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxiesClient.ListPagedResponse>(){

        public ApiFuture<TargetHttpsProxiesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetHttpsProxiesRequest, TargetHttpsProxyList> callable, ListTargetHttpsProxiesRequest request, ApiCallContext context, ApiFuture<TargetHttpsProxyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetHttpsProxiesClient.ListPagedResponse.createAsync((PageContext<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteTargetHttpsProxyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<GetTargetHttpsProxyRequest, TargetHttpsProxy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertTargetHttpsProxyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxiesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchTargetHttpsProxyRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public UnaryCallSettings<SetQuicOverrideTargetHttpsProxyRequest, Operation> setQuicOverrideSettings() {
        return this.setQuicOverrideSettings;
    }

    public UnaryCallSettings<SetSslCertificatesTargetHttpsProxyRequest, Operation> setSslCertificatesSettings() {
        return this.setSslCertificatesSettings;
    }

    public UnaryCallSettings<SetSslPolicyTargetHttpsProxyRequest, Operation> setSslPolicySettings() {
        return this.setSslPolicySettings;
    }

    public UnaryCallSettings<SetUrlMapTargetHttpsProxyRequest, Operation> setUrlMapSettings() {
        return this.setUrlMapSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetHttpsProxiesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTargetHttpsProxiesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TargetHttpsProxiesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TargetHttpsProxiesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TargetHttpsProxiesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.setQuicOverrideSettings = settingsBuilder.setQuicOverrideSettings().build();
        this.setSslCertificatesSettings = settingsBuilder.setSslCertificatesSettings().build();
        this.setSslPolicySettings = settingsBuilder.setSslPolicySettings().build();
        this.setUrlMapSettings = settingsBuilder.setUrlMapSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TargetHttpsProxiesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteTargetHttpsProxyRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<GetTargetHttpsProxyRequest, TargetHttpsProxy> getSettings;
        private final UnaryCallSettings.Builder<InsertTargetHttpsProxyRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxiesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchTargetHttpsProxyRequest, Operation> patchSettings;
        private final UnaryCallSettings.Builder<SetQuicOverrideTargetHttpsProxyRequest, Operation> setQuicOverrideSettings;
        private final UnaryCallSettings.Builder<SetSslCertificatesTargetHttpsProxyRequest, Operation> setSslCertificatesSettings;
        private final UnaryCallSettings.Builder<SetSslPolicyTargetHttpsProxyRequest, Operation> setSslPolicySettings;
        private final UnaryCallSettings.Builder<SetUrlMapTargetHttpsProxyRequest, Operation> setUrlMapSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setQuicOverrideSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSslCertificatesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSslPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.setQuicOverrideSettings, this.setSslCertificatesSettings, this.setSslPolicySettings, this.setUrlMapSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TargetHttpsProxiesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.setQuicOverrideSettings = settings.setQuicOverrideSettings.toBuilder();
            this.setSslCertificatesSettings = settings.setSslCertificatesSettings.toBuilder();
            this.setSslPolicySettings = settings.setSslPolicySettings.toBuilder();
            this.setUrlMapSettings = settings.setUrlMapSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.setQuicOverrideSettings, this.setSslCertificatesSettings, this.setSslPolicySettings, this.setUrlMapSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TargetHttpsProxiesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TargetHttpsProxiesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TargetHttpsProxiesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TargetHttpsProxiesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TargetHttpsProxiesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setQuicOverrideSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setSslCertificatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setSslPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteTargetHttpsProxyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<GetTargetHttpsProxyRequest, TargetHttpsProxy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertTargetHttpsProxyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxiesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchTargetHttpsProxyRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public UnaryCallSettings.Builder<SetQuicOverrideTargetHttpsProxyRequest, Operation> setQuicOverrideSettings() {
            return this.setQuicOverrideSettings;
        }

        public UnaryCallSettings.Builder<SetSslCertificatesTargetHttpsProxyRequest, Operation> setSslCertificatesSettings() {
            return this.setSslCertificatesSettings;
        }

        public UnaryCallSettings.Builder<SetSslPolicyTargetHttpsProxyRequest, Operation> setSslPolicySettings() {
            return this.setSslPolicySettings;
        }

        public UnaryCallSettings.Builder<SetUrlMapTargetHttpsProxyRequest, Operation> setUrlMapSettings() {
            return this.setUrlMapSettings;
        }

        public TargetHttpsProxiesStubSettings build() throws IOException {
            return new TargetHttpsProxiesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

