/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListSslCertificatesRequest;
import com.google.cloud.compute.v1.DeleteSslCertificateRequest;
import com.google.cloud.compute.v1.GetSslCertificateRequest;
import com.google.cloud.compute.v1.InsertSslCertificateRequest;
import com.google.cloud.compute.v1.ListSslCertificatesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SslCertificate;
import com.google.cloud.compute.v1.SslCertificateAggregatedList;
import com.google.cloud.compute.v1.SslCertificateList;
import com.google.cloud.compute.v1.SslCertificatesClient;
import com.google.cloud.compute.v1.SslCertificatesScopedList;
import com.google.cloud.compute.v1.stub.HttpJsonSslCertificatesStub;
import com.google.cloud.compute.v1.stub.SslCertificatesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class SslCertificatesStubSettings
extends StubSettings<SslCertificatesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, SslCertificatesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteSslCertificateRequest, Operation> deleteSettings;
    private final UnaryCallSettings<GetSslCertificateRequest, SslCertificate> getSettings;
    private final UnaryCallSettings<InsertSslCertificateRequest, Operation> insertSettings;
    private final PagedCallSettings<ListSslCertificatesRequest, SslCertificateList, SslCertificatesClient.ListPagedResponse> listSettings;
    private static final PagedListDescriptor<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, Map.Entry<String, SslCertificatesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, Map.Entry<String, SslCertificatesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListSslCertificatesRequest injectToken(AggregatedListSslCertificatesRequest payload, String token) {
            return AggregatedListSslCertificatesRequest.newBuilder((AggregatedListSslCertificatesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListSslCertificatesRequest injectPageSize(AggregatedListSslCertificatesRequest payload, int pageSize) {
            return AggregatedListSslCertificatesRequest.newBuilder((AggregatedListSslCertificatesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListSslCertificatesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SslCertificateAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, SslCertificatesScopedList>> extractResources(SslCertificateAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListSslCertificatesRequest, SslCertificateList, SslCertificate> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListSslCertificatesRequest, SslCertificateList, SslCertificate>(){

        public String emptyToken() {
            return "";
        }

        public ListSslCertificatesRequest injectToken(ListSslCertificatesRequest payload, String token) {
            return ListSslCertificatesRequest.newBuilder((ListSslCertificatesRequest)payload).setPageToken(token).build();
        }

        public ListSslCertificatesRequest injectPageSize(ListSslCertificatesRequest payload, int pageSize) {
            return ListSslCertificatesRequest.newBuilder((ListSslCertificatesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListSslCertificatesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SslCertificateList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SslCertificate> extractResources(SslCertificateList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, SslCertificatesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, SslCertificatesClient.AggregatedListPagedResponse>(){

        public ApiFuture<SslCertificatesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList> callable, AggregatedListSslCertificatesRequest request, ApiCallContext context, ApiFuture<SslCertificateAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SslCertificatesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, Map.Entry<String, SslCertificatesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSslCertificatesRequest, SslCertificateList, SslCertificatesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListSslCertificatesRequest, SslCertificateList, SslCertificatesClient.ListPagedResponse>(){

        public ApiFuture<SslCertificatesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListSslCertificatesRequest, SslCertificateList> callable, ListSslCertificatesRequest request, ApiCallContext context, ApiFuture<SslCertificateList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SslCertificatesClient.ListPagedResponse.createAsync((PageContext<ListSslCertificatesRequest, SslCertificateList, SslCertificate>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, SslCertificatesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteSslCertificateRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<GetSslCertificateRequest, SslCertificate> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertSslCertificateRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListSslCertificatesRequest, SslCertificateList, SslCertificatesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SslCertificatesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSslCertificatesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SslCertificatesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SslCertificatesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SslCertificatesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SslCertificatesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, SslCertificatesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteSslCertificateRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<GetSslCertificateRequest, SslCertificate> getSettings;
        private final UnaryCallSettings.Builder<InsertSslCertificateRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListSslCertificatesRequest, SslCertificateList, SslCertificatesClient.ListPagedResponse> listSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SslCertificatesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SslCertificatesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SslCertificatesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SslCertificatesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SslCertificatesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(SslCertificatesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, SslCertificatesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteSslCertificateRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<GetSslCertificateRequest, SslCertificate> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertSslCertificateRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListSslCertificatesRequest, SslCertificateList, SslCertificatesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public SslCertificatesStubSettings build() throws IOException {
            return new SslCertificatesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

