/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddInstancesInstanceGroupRequest;
import com.google.cloud.compute.v1.AggregatedListInstanceGroupsRequest;
import com.google.cloud.compute.v1.DeleteInstanceGroupRequest;
import com.google.cloud.compute.v1.GetInstanceGroupRequest;
import com.google.cloud.compute.v1.InsertInstanceGroupRequest;
import com.google.cloud.compute.v1.InstanceGroup;
import com.google.cloud.compute.v1.InstanceGroupAggregatedList;
import com.google.cloud.compute.v1.InstanceGroupList;
import com.google.cloud.compute.v1.InstanceGroupsClient;
import com.google.cloud.compute.v1.InstanceGroupsListInstances;
import com.google.cloud.compute.v1.InstanceGroupsScopedList;
import com.google.cloud.compute.v1.InstanceWithNamedPorts;
import com.google.cloud.compute.v1.ListInstanceGroupsRequest;
import com.google.cloud.compute.v1.ListInstancesInstanceGroupsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RemoveInstancesInstanceGroupRequest;
import com.google.cloud.compute.v1.SetNamedPortsInstanceGroupRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInstanceGroupsStub;
import com.google.cloud.compute.v1.stub.InstanceGroupsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class InstanceGroupsStubSettings
extends StubSettings<InstanceGroupsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddInstancesInstanceGroupRequest, Operation> addInstancesSettings;
    private final PagedCallSettings<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, InstanceGroupsClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteInstanceGroupRequest, Operation> deleteSettings;
    private final UnaryCallSettings<GetInstanceGroupRequest, InstanceGroup> getSettings;
    private final UnaryCallSettings<InsertInstanceGroupRequest, Operation> insertSettings;
    private final PagedCallSettings<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroupsClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceGroupsClient.ListInstancesPagedResponse> listInstancesSettings;
    private final UnaryCallSettings<RemoveInstancesInstanceGroupRequest, Operation> removeInstancesSettings;
    private final UnaryCallSettings<SetNamedPortsInstanceGroupRequest, Operation> setNamedPortsSettings;
    private static final PagedListDescriptor<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, Map.Entry<String, InstanceGroupsScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, Map.Entry<String, InstanceGroupsScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListInstanceGroupsRequest injectToken(AggregatedListInstanceGroupsRequest payload, String token) {
            return AggregatedListInstanceGroupsRequest.newBuilder((AggregatedListInstanceGroupsRequest)payload).setPageToken(token).build();
        }

        public AggregatedListInstanceGroupsRequest injectPageSize(AggregatedListInstanceGroupsRequest payload, int pageSize) {
            return AggregatedListInstanceGroupsRequest.newBuilder((AggregatedListInstanceGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListInstanceGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceGroupAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, InstanceGroupsScopedList>> extractResources(InstanceGroupAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroup> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListInstanceGroupsRequest injectToken(ListInstanceGroupsRequest payload, String token) {
            return ListInstanceGroupsRequest.newBuilder((ListInstanceGroupsRequest)payload).setPageToken(token).build();
        }

        public ListInstanceGroupsRequest injectPageSize(ListInstanceGroupsRequest payload, int pageSize) {
            return ListInstanceGroupsRequest.newBuilder((ListInstanceGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInstanceGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceGroupList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceGroup> extractResources(InstanceGroupList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceWithNamedPorts> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceWithNamedPorts>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesInstanceGroupsRequest injectToken(ListInstancesInstanceGroupsRequest payload, String token) {
            return ListInstancesInstanceGroupsRequest.newBuilder((ListInstancesInstanceGroupsRequest)payload).setPageToken(token).build();
        }

        public ListInstancesInstanceGroupsRequest injectPageSize(ListInstancesInstanceGroupsRequest payload, int pageSize) {
            return ListInstancesInstanceGroupsRequest.newBuilder((ListInstancesInstanceGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesInstanceGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceGroupsListInstances payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceWithNamedPorts> extractResources(InstanceGroupsListInstances payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, InstanceGroupsClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, InstanceGroupsClient.AggregatedListPagedResponse>(){

        public ApiFuture<InstanceGroupsClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList> callable, AggregatedListInstanceGroupsRequest request, ApiCallContext context, ApiFuture<InstanceGroupAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceGroupsClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, Map.Entry<String, InstanceGroupsScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroupsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroupsClient.ListPagedResponse>(){

        public ApiFuture<InstanceGroupsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstanceGroupsRequest, InstanceGroupList> callable, ListInstanceGroupsRequest request, ApiCallContext context, ApiFuture<InstanceGroupList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceGroupsClient.ListPagedResponse.createAsync((PageContext<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceGroupsClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceGroupsClient.ListInstancesPagedResponse>(){

        public ApiFuture<InstanceGroupsClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances> callable, ListInstancesInstanceGroupsRequest request, ApiCallContext context, ApiFuture<InstanceGroupsListInstances> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceGroupsClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceWithNamedPorts>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddInstancesInstanceGroupRequest, Operation> addInstancesSettings() {
        return this.addInstancesSettings;
    }

    public PagedCallSettings<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, InstanceGroupsClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteInstanceGroupRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<GetInstanceGroupRequest, InstanceGroup> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertInstanceGroupRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroupsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceGroupsClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<RemoveInstancesInstanceGroupRequest, Operation> removeInstancesSettings() {
        return this.removeInstancesSettings;
    }

    public UnaryCallSettings<SetNamedPortsInstanceGroupRequest, Operation> setNamedPortsSettings() {
        return this.setNamedPortsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstanceGroupsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInstanceGroupsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InstanceGroupsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InstanceGroupsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InstanceGroupsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addInstancesSettings = settingsBuilder.addInstancesSettings().build();
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.removeInstancesSettings = settingsBuilder.removeInstancesSettings().build();
        this.setNamedPortsSettings = settingsBuilder.setNamedPortsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InstanceGroupsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddInstancesInstanceGroupRequest, Operation> addInstancesSettings;
        private final PagedCallSettings.Builder<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, InstanceGroupsClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceGroupRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<GetInstanceGroupRequest, InstanceGroup> getSettings;
        private final UnaryCallSettings.Builder<InsertInstanceGroupRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroupsClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceGroupsClient.ListInstancesPagedResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<RemoveInstancesInstanceGroupRequest, Operation> removeInstancesSettings;
        private final UnaryCallSettings.Builder<SetNamedPortsInstanceGroupRequest, Operation> setNamedPortsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.removeInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setNamedPortsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addInstancesSettings, this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.listInstancesSettings, this.removeInstancesSettings, this.setNamedPortsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(InstanceGroupsStubSettings settings) {
            super((StubSettings)settings);
            this.addInstancesSettings = settings.addInstancesSettings.toBuilder();
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.removeInstancesSettings = settings.removeInstancesSettings.toBuilder();
            this.setNamedPortsSettings = settings.setNamedPortsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addInstancesSettings, this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.listInstancesSettings, this.removeInstancesSettings, this.setNamedPortsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InstanceGroupsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InstanceGroupsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InstanceGroupsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(InstanceGroupsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(InstanceGroupsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setNamedPortsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddInstancesInstanceGroupRequest, Operation> addInstancesSettings() {
            return this.addInstancesSettings;
        }

        public PagedCallSettings.Builder<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, InstanceGroupsClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceGroupRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceGroupRequest, InstanceGroup> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertInstanceGroupRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroupsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceGroupsClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<RemoveInstancesInstanceGroupRequest, Operation> removeInstancesSettings() {
            return this.removeInstancesSettings;
        }

        public UnaryCallSettings.Builder<SetNamedPortsInstanceGroupRequest, Operation> setNamedPortsSettings() {
            return this.setNamedPortsSettings;
        }

        public InstanceGroupsStubSettings build() throws IOException {
            return new InstanceGroupsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

