/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListForwardingRulesRequest;
import com.google.cloud.compute.v1.DeleteForwardingRuleRequest;
import com.google.cloud.compute.v1.ForwardingRule;
import com.google.cloud.compute.v1.ForwardingRuleAggregatedList;
import com.google.cloud.compute.v1.ForwardingRuleList;
import com.google.cloud.compute.v1.ForwardingRulesClient;
import com.google.cloud.compute.v1.GetForwardingRuleRequest;
import com.google.cloud.compute.v1.InsertForwardingRuleRequest;
import com.google.cloud.compute.v1.ListForwardingRulesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchForwardingRuleRequest;
import com.google.cloud.compute.v1.SetLabelsForwardingRuleRequest;
import com.google.cloud.compute.v1.SetTargetForwardingRuleRequest;
import com.google.cloud.compute.v1.stub.ForwardingRulesStub;
import com.google.cloud.compute.v1.stub.ForwardingRulesStubSettings;
import com.google.cloud.compute.v1.stub.HttpJsonForwardingRulesCallableFactory;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonForwardingRulesStub
extends ForwardingRulesStub {
    private static final ApiMethodDescriptor<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList> aggregatedListMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ForwardingRules/AggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/aggregated/forwardingRules", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasIncludeAllScopes()) {
            serializer.putQueryParam(fields, "includeAllScopes", (Object)request.getIncludeAllScopes());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ForwardingRuleAggregatedList.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<DeleteForwardingRuleRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ForwardingRules/Delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/forwardingRules/{forwardingRule}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "forwardingRule", (Object)request.getForwardingRule());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<GetForwardingRuleRequest, ForwardingRule> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ForwardingRules/Get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/forwardingRules/{forwardingRule}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "forwardingRule", (Object)request.getForwardingRule());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ForwardingRule.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<InsertForwardingRuleRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ForwardingRules/Insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/forwardingRules", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("forwardingRuleResource", (Message)request.getForwardingRuleResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<ListForwardingRulesRequest, ForwardingRuleList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ForwardingRules/List").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/forwardingRules", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ForwardingRuleList.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<PatchForwardingRuleRequest, Operation> patchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ForwardingRules/Patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/forwardingRules/{forwardingRule}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "forwardingRule", (Object)request.getForwardingRule());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("forwardingRuleResource", (Message)request.getForwardingRuleResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<SetLabelsForwardingRuleRequest, Operation> setLabelsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ForwardingRules/SetLabels").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/forwardingRules/{resource}/setLabels", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("regionSetLabelsRequestResource", (Message)request.getRegionSetLabelsRequestResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<SetTargetForwardingRuleRequest, Operation> setTargetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ForwardingRules/SetTarget").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/forwardingRules/{forwardingRule}/setTarget", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "forwardingRule", (Object)request.getForwardingRule());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("targetReferenceResource", (Message)request.getTargetReferenceResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private final UnaryCallable<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList> aggregatedListCallable;
    private final UnaryCallable<AggregatedListForwardingRulesRequest, ForwardingRulesClient.AggregatedListPagedResponse> aggregatedListPagedCallable;
    private final UnaryCallable<DeleteForwardingRuleRequest, Operation> deleteCallable;
    private final UnaryCallable<GetForwardingRuleRequest, ForwardingRule> getCallable;
    private final UnaryCallable<InsertForwardingRuleRequest, Operation> insertCallable;
    private final UnaryCallable<ListForwardingRulesRequest, ForwardingRuleList> listCallable;
    private final UnaryCallable<ListForwardingRulesRequest, ForwardingRulesClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<PatchForwardingRuleRequest, Operation> patchCallable;
    private final UnaryCallable<SetLabelsForwardingRuleRequest, Operation> setLabelsCallable;
    private final UnaryCallable<SetTargetForwardingRuleRequest, Operation> setTargetCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonForwardingRulesStub create(ForwardingRulesStubSettings settings) throws IOException {
        return new HttpJsonForwardingRulesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonForwardingRulesStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonForwardingRulesStub(ForwardingRulesStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonForwardingRulesStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonForwardingRulesStub(ForwardingRulesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonForwardingRulesStub(ForwardingRulesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonForwardingRulesCallableFactory());
    }

    protected HttpJsonForwardingRulesStub(ForwardingRulesStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings aggregatedListTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListMethodDescriptor).build();
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).build();
        HttpJsonCallSettings patchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchMethodDescriptor).build();
        HttpJsonCallSettings setLabelsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setLabelsMethodDescriptor).build();
        HttpJsonCallSettings setTargetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setTargetMethodDescriptor).build();
        this.aggregatedListCallable = callableFactory.createUnaryCallable(aggregatedListTransportSettings, settings.aggregatedListSettings(), clientContext);
        this.aggregatedListPagedCallable = callableFactory.createPagedCallable(aggregatedListTransportSettings, settings.aggregatedListSettings(), clientContext);
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.patchCallable = callableFactory.createUnaryCallable(patchTransportSettings, settings.patchSettings(), clientContext);
        this.setLabelsCallable = callableFactory.createUnaryCallable(setLabelsTransportSettings, settings.setLabelsSettings(), clientContext);
        this.setTargetCallable = callableFactory.createUnaryCallable(setTargetTransportSettings, settings.setTargetSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(aggregatedListMethodDescriptor);
        methodDescriptors.add(deleteMethodDescriptor);
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(insertMethodDescriptor);
        methodDescriptors.add(listMethodDescriptor);
        methodDescriptors.add(patchMethodDescriptor);
        methodDescriptors.add(setLabelsMethodDescriptor);
        methodDescriptors.add(setTargetMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList> aggregatedListCallable() {
        return this.aggregatedListCallable;
    }

    @Override
    public UnaryCallable<AggregatedListForwardingRulesRequest, ForwardingRulesClient.AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.aggregatedListPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteForwardingRuleRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public UnaryCallable<GetForwardingRuleRequest, ForwardingRule> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<InsertForwardingRuleRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public UnaryCallable<ListForwardingRulesRequest, ForwardingRuleList> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ListForwardingRulesRequest, ForwardingRulesClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<PatchForwardingRuleRequest, Operation> patchCallable() {
        return this.patchCallable;
    }

    @Override
    public UnaryCallable<SetLabelsForwardingRuleRequest, Operation> setLabelsCallable() {
        return this.setLabelsCallable;
    }

    @Override
    public UnaryCallable<SetTargetForwardingRuleRequest, Operation> setTargetCallable() {
        return this.setTargetCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

