/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddAssociationFirewallPolicyRequest;
import com.google.cloud.compute.v1.AddRuleFirewallPolicyRequest;
import com.google.cloud.compute.v1.CloneRulesFirewallPolicyRequest;
import com.google.cloud.compute.v1.DeleteFirewallPolicyRequest;
import com.google.cloud.compute.v1.FirewallPoliciesClient;
import com.google.cloud.compute.v1.FirewallPoliciesListAssociationsResponse;
import com.google.cloud.compute.v1.FirewallPolicy;
import com.google.cloud.compute.v1.FirewallPolicyAssociation;
import com.google.cloud.compute.v1.FirewallPolicyList;
import com.google.cloud.compute.v1.FirewallPolicyRule;
import com.google.cloud.compute.v1.GetAssociationFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetIamPolicyFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetRuleFirewallPolicyRequest;
import com.google.cloud.compute.v1.InsertFirewallPolicyRequest;
import com.google.cloud.compute.v1.ListAssociationsFirewallPolicyRequest;
import com.google.cloud.compute.v1.ListFirewallPoliciesRequest;
import com.google.cloud.compute.v1.MoveFirewallPolicyRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchFirewallPolicyRequest;
import com.google.cloud.compute.v1.PatchRuleFirewallPolicyRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RemoveAssociationFirewallPolicyRequest;
import com.google.cloud.compute.v1.RemoveRuleFirewallPolicyRequest;
import com.google.cloud.compute.v1.SetIamPolicyFirewallPolicyRequest;
import com.google.cloud.compute.v1.TestIamPermissionsFirewallPolicyRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.FirewallPoliciesStub;
import com.google.cloud.compute.v1.stub.HttpJsonFirewallPoliciesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class FirewallPoliciesStubSettings
extends StubSettings<FirewallPoliciesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddAssociationFirewallPolicyRequest, Operation> addAssociationSettings;
    private final UnaryCallSettings<AddRuleFirewallPolicyRequest, Operation> addRuleSettings;
    private final UnaryCallSettings<CloneRulesFirewallPolicyRequest, Operation> cloneRulesSettings;
    private final UnaryCallSettings<DeleteFirewallPolicyRequest, Operation> deleteSettings;
    private final UnaryCallSettings<GetFirewallPolicyRequest, FirewallPolicy> getSettings;
    private final UnaryCallSettings<GetAssociationFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationSettings;
    private final UnaryCallSettings<GetIamPolicyFirewallPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<GetRuleFirewallPolicyRequest, FirewallPolicyRule> getRuleSettings;
    private final UnaryCallSettings<InsertFirewallPolicyRequest, Operation> insertSettings;
    private final PagedCallSettings<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPoliciesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<ListAssociationsFirewallPolicyRequest, FirewallPoliciesListAssociationsResponse> listAssociationsSettings;
    private final UnaryCallSettings<MoveFirewallPolicyRequest, Operation> moveSettings;
    private final UnaryCallSettings<PatchFirewallPolicyRequest, Operation> patchSettings;
    private final UnaryCallSettings<PatchRuleFirewallPolicyRequest, Operation> patchRuleSettings;
    private final UnaryCallSettings<RemoveAssociationFirewallPolicyRequest, Operation> removeAssociationSettings;
    private final UnaryCallSettings<RemoveRuleFirewallPolicyRequest, Operation> removeRuleSettings;
    private final UnaryCallSettings<SetIamPolicyFirewallPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListFirewallPoliciesRequest injectToken(ListFirewallPoliciesRequest payload, String token) {
            return ListFirewallPoliciesRequest.newBuilder((ListFirewallPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListFirewallPoliciesRequest injectPageSize(ListFirewallPoliciesRequest payload, int pageSize) {
            return ListFirewallPoliciesRequest.newBuilder((ListFirewallPoliciesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListFirewallPoliciesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(FirewallPolicyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<FirewallPolicy> extractResources(FirewallPolicyList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPoliciesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPoliciesClient.ListPagedResponse>(){

        public ApiFuture<FirewallPoliciesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListFirewallPoliciesRequest, FirewallPolicyList> callable, ListFirewallPoliciesRequest request, ApiCallContext context, ApiFuture<FirewallPolicyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FirewallPoliciesClient.ListPagedResponse.createAsync((PageContext<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddAssociationFirewallPolicyRequest, Operation> addAssociationSettings() {
        return this.addAssociationSettings;
    }

    public UnaryCallSettings<AddRuleFirewallPolicyRequest, Operation> addRuleSettings() {
        return this.addRuleSettings;
    }

    public UnaryCallSettings<CloneRulesFirewallPolicyRequest, Operation> cloneRulesSettings() {
        return this.cloneRulesSettings;
    }

    public UnaryCallSettings<DeleteFirewallPolicyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<GetFirewallPolicyRequest, FirewallPolicy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetAssociationFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationSettings() {
        return this.getAssociationSettings;
    }

    public UnaryCallSettings<GetIamPolicyFirewallPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<GetRuleFirewallPolicyRequest, FirewallPolicyRule> getRuleSettings() {
        return this.getRuleSettings;
    }

    public UnaryCallSettings<InsertFirewallPolicyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPoliciesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<ListAssociationsFirewallPolicyRequest, FirewallPoliciesListAssociationsResponse> listAssociationsSettings() {
        return this.listAssociationsSettings;
    }

    public UnaryCallSettings<MoveFirewallPolicyRequest, Operation> moveSettings() {
        return this.moveSettings;
    }

    public UnaryCallSettings<PatchFirewallPolicyRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public UnaryCallSettings<PatchRuleFirewallPolicyRequest, Operation> patchRuleSettings() {
        return this.patchRuleSettings;
    }

    public UnaryCallSettings<RemoveAssociationFirewallPolicyRequest, Operation> removeAssociationSettings() {
        return this.removeAssociationSettings;
    }

    public UnaryCallSettings<RemoveRuleFirewallPolicyRequest, Operation> removeRuleSettings() {
        return this.removeRuleSettings;
    }

    public UnaryCallSettings<SetIamPolicyFirewallPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FirewallPoliciesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonFirewallPoliciesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FirewallPoliciesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FirewallPoliciesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FirewallPoliciesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addAssociationSettings = settingsBuilder.addAssociationSettings().build();
        this.addRuleSettings = settingsBuilder.addRuleSettings().build();
        this.cloneRulesSettings = settingsBuilder.cloneRulesSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getAssociationSettings = settingsBuilder.getAssociationSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.getRuleSettings = settingsBuilder.getRuleSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listAssociationsSettings = settingsBuilder.listAssociationsSettings().build();
        this.moveSettings = settingsBuilder.moveSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchRuleSettings = settingsBuilder.patchRuleSettings().build();
        this.removeAssociationSettings = settingsBuilder.removeAssociationSettings().build();
        this.removeRuleSettings = settingsBuilder.removeRuleSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FirewallPoliciesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddAssociationFirewallPolicyRequest, Operation> addAssociationSettings;
        private final UnaryCallSettings.Builder<AddRuleFirewallPolicyRequest, Operation> addRuleSettings;
        private final UnaryCallSettings.Builder<CloneRulesFirewallPolicyRequest, Operation> cloneRulesSettings;
        private final UnaryCallSettings.Builder<DeleteFirewallPolicyRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<GetFirewallPolicyRequest, FirewallPolicy> getSettings;
        private final UnaryCallSettings.Builder<GetAssociationFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyFirewallPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<GetRuleFirewallPolicyRequest, FirewallPolicyRule> getRuleSettings;
        private final UnaryCallSettings.Builder<InsertFirewallPolicyRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPoliciesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<ListAssociationsFirewallPolicyRequest, FirewallPoliciesListAssociationsResponse> listAssociationsSettings;
        private final UnaryCallSettings.Builder<MoveFirewallPolicyRequest, Operation> moveSettings;
        private final UnaryCallSettings.Builder<PatchFirewallPolicyRequest, Operation> patchSettings;
        private final UnaryCallSettings.Builder<PatchRuleFirewallPolicyRequest, Operation> patchRuleSettings;
        private final UnaryCallSettings.Builder<RemoveAssociationFirewallPolicyRequest, Operation> removeAssociationSettings;
        private final UnaryCallSettings.Builder<RemoveRuleFirewallPolicyRequest, Operation> removeRuleSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyFirewallPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cloneRulesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listAssociationsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.moveSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAssociationSettings, this.addRuleSettings, this.cloneRulesSettings, this.deleteSettings, this.getSettings, this.getAssociationSettings, this.getIamPolicySettings, this.getRuleSettings, this.insertSettings, this.listSettings, this.listAssociationsSettings, this.moveSettings, (Object[])new UnaryCallSettings.Builder[]{this.patchSettings, this.patchRuleSettings, this.removeAssociationSettings, this.removeRuleSettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(FirewallPoliciesStubSettings settings) {
            super((StubSettings)settings);
            this.addAssociationSettings = settings.addAssociationSettings.toBuilder();
            this.addRuleSettings = settings.addRuleSettings.toBuilder();
            this.cloneRulesSettings = settings.cloneRulesSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getAssociationSettings = settings.getAssociationSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.getRuleSettings = settings.getRuleSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listAssociationsSettings = settings.listAssociationsSettings.toBuilder();
            this.moveSettings = settings.moveSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchRuleSettings = settings.patchRuleSettings.toBuilder();
            this.removeAssociationSettings = settings.removeAssociationSettings.toBuilder();
            this.removeRuleSettings = settings.removeRuleSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAssociationSettings, this.addRuleSettings, this.cloneRulesSettings, this.deleteSettings, this.getSettings, this.getAssociationSettings, this.getIamPolicySettings, this.getRuleSettings, this.insertSettings, this.listSettings, this.listAssociationsSettings, this.moveSettings, (Object[])new UnaryCallSettings.Builder[]{this.patchSettings, this.patchRuleSettings, this.removeAssociationSettings, this.removeRuleSettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FirewallPoliciesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)FirewallPoliciesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FirewallPoliciesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(FirewallPoliciesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(FirewallPoliciesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.cloneRulesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAssociationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.moveSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddAssociationFirewallPolicyRequest, Operation> addAssociationSettings() {
            return this.addAssociationSettings;
        }

        public UnaryCallSettings.Builder<AddRuleFirewallPolicyRequest, Operation> addRuleSettings() {
            return this.addRuleSettings;
        }

        public UnaryCallSettings.Builder<CloneRulesFirewallPolicyRequest, Operation> cloneRulesSettings() {
            return this.cloneRulesSettings;
        }

        public UnaryCallSettings.Builder<DeleteFirewallPolicyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<GetFirewallPolicyRequest, FirewallPolicy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetAssociationFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationSettings() {
            return this.getAssociationSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyFirewallPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetRuleFirewallPolicyRequest, FirewallPolicyRule> getRuleSettings() {
            return this.getRuleSettings;
        }

        public UnaryCallSettings.Builder<InsertFirewallPolicyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPoliciesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<ListAssociationsFirewallPolicyRequest, FirewallPoliciesListAssociationsResponse> listAssociationsSettings() {
            return this.listAssociationsSettings;
        }

        public UnaryCallSettings.Builder<MoveFirewallPolicyRequest, Operation> moveSettings() {
            return this.moveSettings;
        }

        public UnaryCallSettings.Builder<PatchFirewallPolicyRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public UnaryCallSettings.Builder<PatchRuleFirewallPolicyRequest, Operation> patchRuleSettings() {
            return this.patchRuleSettings;
        }

        public UnaryCallSettings.Builder<RemoveAssociationFirewallPolicyRequest, Operation> removeAssociationSettings() {
            return this.removeAssociationSettings;
        }

        public UnaryCallSettings.Builder<RemoveRuleFirewallPolicyRequest, Operation> removeRuleSettings() {
            return this.removeRuleSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyFirewallPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public FirewallPoliciesStubSettings build() throws IOException {
            return new FirewallPoliciesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

