/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListVpnTunnelsRequest;
import com.google.cloud.compute.v1.DeleteVpnTunnelRequest;
import com.google.cloud.compute.v1.GetVpnTunnelRequest;
import com.google.cloud.compute.v1.InsertVpnTunnelRequest;
import com.google.cloud.compute.v1.ListVpnTunnelsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.VpnTunnel;
import com.google.cloud.compute.v1.VpnTunnelAggregatedList;
import com.google.cloud.compute.v1.VpnTunnelList;
import com.google.cloud.compute.v1.VpnTunnelsScopedList;
import com.google.cloud.compute.v1.VpnTunnelsSettings;
import com.google.cloud.compute.v1.stub.VpnTunnelsStub;
import com.google.cloud.compute.v1.stub.VpnTunnelsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class VpnTunnelsClient
implements BackgroundResource {
    private final VpnTunnelsSettings settings;
    private final VpnTunnelsStub stub;

    public static final VpnTunnelsClient create() throws IOException {
        return VpnTunnelsClient.create(VpnTunnelsSettings.newBuilder().build());
    }

    public static final VpnTunnelsClient create(VpnTunnelsSettings settings) throws IOException {
        return new VpnTunnelsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final VpnTunnelsClient create(VpnTunnelsStub stub) {
        return new VpnTunnelsClient(stub);
    }

    protected VpnTunnelsClient(VpnTunnelsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VpnTunnelsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected VpnTunnelsClient(VpnTunnelsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final VpnTunnelsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public VpnTunnelsStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListVpnTunnelsRequest request = AggregatedListVpnTunnelsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListVpnTunnelsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListVpnTunnelsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListVpnTunnelsRequest, VpnTunnelAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String region, String vpnTunnel) {
        DeleteVpnTunnelRequest request = DeleteVpnTunnelRequest.newBuilder().setProject(project).setRegion(region).setVpnTunnel(vpnTunnel).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteVpnTunnelRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteVpnTunnelRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final VpnTunnel get(String project, String region, String vpnTunnel) {
        GetVpnTunnelRequest request = GetVpnTunnelRequest.newBuilder().setProject(project).setRegion(region).setVpnTunnel(vpnTunnel).build();
        return this.get(request);
    }

    public final VpnTunnel get(GetVpnTunnelRequest request) {
        return (VpnTunnel)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetVpnTunnelRequest, VpnTunnel> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String region, VpnTunnel vpnTunnelResource) {
        InsertVpnTunnelRequest request = InsertVpnTunnelRequest.newBuilder().setProject(project).setRegion(region).setVpnTunnelResource(vpnTunnelResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertVpnTunnelRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertVpnTunnelRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListVpnTunnelsRequest request = ListVpnTunnelsRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListVpnTunnelsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVpnTunnelsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListVpnTunnelsRequest, VpnTunnelList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVpnTunnelsRequest, VpnTunnelList, VpnTunnel, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListVpnTunnelsRequest, VpnTunnelList, VpnTunnel, ListPage> {
        private ListPage(PageContext<ListVpnTunnelsRequest, VpnTunnelList, VpnTunnel> context, VpnTunnelList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListVpnTunnelsRequest, VpnTunnelList, VpnTunnel> context, VpnTunnelList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListVpnTunnelsRequest, VpnTunnelList, VpnTunnel> context, ApiFuture<VpnTunnelList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListVpnTunnelsRequest, VpnTunnelList, VpnTunnel, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListVpnTunnelsRequest, VpnTunnelList, VpnTunnel> context, ApiFuture<VpnTunnelList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListVpnTunnelsRequest, VpnTunnelAggregatedList, Map.Entry<String, VpnTunnelsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListVpnTunnelsRequest, VpnTunnelAggregatedList, Map.Entry<String, VpnTunnelsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListVpnTunnelsRequest, VpnTunnelAggregatedList, Map.Entry<String, VpnTunnelsScopedList>> context, VpnTunnelAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListVpnTunnelsRequest, VpnTunnelAggregatedList, Map.Entry<String, VpnTunnelsScopedList>> context, VpnTunnelAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListVpnTunnelsRequest, VpnTunnelAggregatedList, Map.Entry<String, VpnTunnelsScopedList>> context, ApiFuture<VpnTunnelAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListVpnTunnelsRequest, VpnTunnelAggregatedList, Map.Entry<String, VpnTunnelsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListVpnTunnelsRequest, VpnTunnelAggregatedList, Map.Entry<String, VpnTunnelsScopedList>> context, ApiFuture<VpnTunnelAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

