/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListUrlMapsRequest;
import com.google.cloud.compute.v1.CacheInvalidationRule;
import com.google.cloud.compute.v1.DeleteUrlMapRequest;
import com.google.cloud.compute.v1.GetUrlMapRequest;
import com.google.cloud.compute.v1.InsertUrlMapRequest;
import com.google.cloud.compute.v1.InvalidateCacheUrlMapRequest;
import com.google.cloud.compute.v1.ListUrlMapsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchUrlMapRequest;
import com.google.cloud.compute.v1.UpdateUrlMapRequest;
import com.google.cloud.compute.v1.UrlMap;
import com.google.cloud.compute.v1.UrlMapList;
import com.google.cloud.compute.v1.UrlMapsAggregatedList;
import com.google.cloud.compute.v1.UrlMapsScopedList;
import com.google.cloud.compute.v1.UrlMapsSettings;
import com.google.cloud.compute.v1.UrlMapsValidateRequest;
import com.google.cloud.compute.v1.UrlMapsValidateResponse;
import com.google.cloud.compute.v1.ValidateUrlMapRequest;
import com.google.cloud.compute.v1.stub.UrlMapsStub;
import com.google.cloud.compute.v1.stub.UrlMapsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class UrlMapsClient
implements BackgroundResource {
    private final UrlMapsSettings settings;
    private final UrlMapsStub stub;

    public static final UrlMapsClient create() throws IOException {
        return UrlMapsClient.create(UrlMapsSettings.newBuilder().build());
    }

    public static final UrlMapsClient create(UrlMapsSettings settings) throws IOException {
        return new UrlMapsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final UrlMapsClient create(UrlMapsStub stub) {
        return new UrlMapsClient(stub);
    }

    protected UrlMapsClient(UrlMapsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((UrlMapsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected UrlMapsClient(UrlMapsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final UrlMapsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public UrlMapsStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListUrlMapsRequest request = AggregatedListUrlMapsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListUrlMapsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListUrlMapsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListUrlMapsRequest, UrlMapsAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String urlMap) {
        DeleteUrlMapRequest request = DeleteUrlMapRequest.newBuilder().setProject(project).setUrlMap(urlMap).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteUrlMapRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteUrlMapRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final UrlMap get(String project, String urlMap) {
        GetUrlMapRequest request = GetUrlMapRequest.newBuilder().setProject(project).setUrlMap(urlMap).build();
        return this.get(request);
    }

    public final UrlMap get(GetUrlMapRequest request) {
        return (UrlMap)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetUrlMapRequest, UrlMap> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, UrlMap urlMapResource) {
        InsertUrlMapRequest request = InsertUrlMapRequest.newBuilder().setProject(project).setUrlMapResource(urlMapResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertUrlMapRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertUrlMapRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final Operation invalidateCache(String project, String urlMap, CacheInvalidationRule cacheInvalidationRuleResource) {
        InvalidateCacheUrlMapRequest request = InvalidateCacheUrlMapRequest.newBuilder().setProject(project).setUrlMap(urlMap).setCacheInvalidationRuleResource(cacheInvalidationRuleResource).build();
        return this.invalidateCache(request);
    }

    public final Operation invalidateCache(InvalidateCacheUrlMapRequest request) {
        return (Operation)this.invalidateCacheCallable().call((Object)request);
    }

    public final UnaryCallable<InvalidateCacheUrlMapRequest, Operation> invalidateCacheCallable() {
        return this.stub.invalidateCacheCallable();
    }

    public final ListPagedResponse list(String project) {
        ListUrlMapsRequest request = ListUrlMapsRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListUrlMapsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUrlMapsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListUrlMapsRequest, UrlMapList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String urlMap, UrlMap urlMapResource) {
        PatchUrlMapRequest request = PatchUrlMapRequest.newBuilder().setProject(project).setUrlMap(urlMap).setUrlMapResource(urlMapResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchUrlMapRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchUrlMapRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation update(String project, String urlMap, UrlMap urlMapResource) {
        UpdateUrlMapRequest request = UpdateUrlMapRequest.newBuilder().setProject(project).setUrlMap(urlMap).setUrlMapResource(urlMapResource).build();
        return this.update(request);
    }

    public final Operation update(UpdateUrlMapRequest request) {
        return (Operation)this.updateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateUrlMapRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final UrlMapsValidateResponse validate(String project, String urlMap, UrlMapsValidateRequest urlMapsValidateRequestResource) {
        ValidateUrlMapRequest request = ValidateUrlMapRequest.newBuilder().setProject(project).setUrlMap(urlMap).setUrlMapsValidateRequestResource(urlMapsValidateRequestResource).build();
        return this.validate(request);
    }

    public final UrlMapsValidateResponse validate(ValidateUrlMapRequest request) {
        return (UrlMapsValidateResponse)this.validateCallable().call((Object)request);
    }

    public final UnaryCallable<ValidateUrlMapRequest, UrlMapsValidateResponse> validateCallable() {
        return this.stub.validateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUrlMapsRequest, UrlMapList, UrlMap, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListUrlMapsRequest, UrlMapList, UrlMap, ListPage> {
        private ListPage(PageContext<ListUrlMapsRequest, UrlMapList, UrlMap> context, UrlMapList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListUrlMapsRequest, UrlMapList, UrlMap> context, UrlMapList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListUrlMapsRequest, UrlMapList, UrlMap> context, ApiFuture<UrlMapList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListUrlMapsRequest, UrlMapList, UrlMap, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListUrlMapsRequest, UrlMapList, UrlMap> context, ApiFuture<UrlMapList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, Map.Entry<String, UrlMapsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, Map.Entry<String, UrlMapsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, Map.Entry<String, UrlMapsScopedList>> context, UrlMapsAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, Map.Entry<String, UrlMapsScopedList>> context, UrlMapsAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, Map.Entry<String, UrlMapsScopedList>> context, ApiFuture<UrlMapsAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, Map.Entry<String, UrlMapsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListUrlMapsRequest, UrlMapsAggregatedList, Map.Entry<String, UrlMapsScopedList>> context, ApiFuture<UrlMapsAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

