/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddHealthCheckTargetPoolRequest;
import com.google.cloud.compute.v1.AddInstanceTargetPoolRequest;
import com.google.cloud.compute.v1.AggregatedListTargetPoolsRequest;
import com.google.cloud.compute.v1.DeleteTargetPoolRequest;
import com.google.cloud.compute.v1.GetHealthTargetPoolRequest;
import com.google.cloud.compute.v1.GetTargetPoolRequest;
import com.google.cloud.compute.v1.InsertTargetPoolRequest;
import com.google.cloud.compute.v1.InstanceReference;
import com.google.cloud.compute.v1.ListTargetPoolsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RemoveHealthCheckTargetPoolRequest;
import com.google.cloud.compute.v1.RemoveInstanceTargetPoolRequest;
import com.google.cloud.compute.v1.SetBackupTargetPoolRequest;
import com.google.cloud.compute.v1.TargetPool;
import com.google.cloud.compute.v1.TargetPoolAggregatedList;
import com.google.cloud.compute.v1.TargetPoolInstanceHealth;
import com.google.cloud.compute.v1.TargetPoolList;
import com.google.cloud.compute.v1.TargetPoolsAddHealthCheckRequest;
import com.google.cloud.compute.v1.TargetPoolsAddInstanceRequest;
import com.google.cloud.compute.v1.TargetPoolsRemoveHealthCheckRequest;
import com.google.cloud.compute.v1.TargetPoolsRemoveInstanceRequest;
import com.google.cloud.compute.v1.TargetPoolsScopedList;
import com.google.cloud.compute.v1.TargetPoolsSettings;
import com.google.cloud.compute.v1.TargetReference;
import com.google.cloud.compute.v1.stub.TargetPoolsStub;
import com.google.cloud.compute.v1.stub.TargetPoolsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TargetPoolsClient
implements BackgroundResource {
    private final TargetPoolsSettings settings;
    private final TargetPoolsStub stub;

    public static final TargetPoolsClient create() throws IOException {
        return TargetPoolsClient.create(TargetPoolsSettings.newBuilder().build());
    }

    public static final TargetPoolsClient create(TargetPoolsSettings settings) throws IOException {
        return new TargetPoolsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TargetPoolsClient create(TargetPoolsStub stub) {
        return new TargetPoolsClient(stub);
    }

    protected TargetPoolsClient(TargetPoolsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetPoolsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TargetPoolsClient(TargetPoolsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetPoolsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetPoolsStub getStub() {
        return this.stub;
    }

    public final Operation addHealthCheck(String project, String region, String targetPool, TargetPoolsAddHealthCheckRequest targetPoolsAddHealthCheckRequestResource) {
        AddHealthCheckTargetPoolRequest request = AddHealthCheckTargetPoolRequest.newBuilder().setProject(project).setRegion(region).setTargetPool(targetPool).setTargetPoolsAddHealthCheckRequestResource(targetPoolsAddHealthCheckRequestResource).build();
        return this.addHealthCheck(request);
    }

    public final Operation addHealthCheck(AddHealthCheckTargetPoolRequest request) {
        return (Operation)this.addHealthCheckCallable().call((Object)request);
    }

    public final UnaryCallable<AddHealthCheckTargetPoolRequest, Operation> addHealthCheckCallable() {
        return this.stub.addHealthCheckCallable();
    }

    public final Operation addInstance(String project, String region, String targetPool, TargetPoolsAddInstanceRequest targetPoolsAddInstanceRequestResource) {
        AddInstanceTargetPoolRequest request = AddInstanceTargetPoolRequest.newBuilder().setProject(project).setRegion(region).setTargetPool(targetPool).setTargetPoolsAddInstanceRequestResource(targetPoolsAddInstanceRequestResource).build();
        return this.addInstance(request);
    }

    public final Operation addInstance(AddInstanceTargetPoolRequest request) {
        return (Operation)this.addInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<AddInstanceTargetPoolRequest, Operation> addInstanceCallable() {
        return this.stub.addInstanceCallable();
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListTargetPoolsRequest request = AggregatedListTargetPoolsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListTargetPoolsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListTargetPoolsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String region, String targetPool) {
        DeleteTargetPoolRequest request = DeleteTargetPoolRequest.newBuilder().setProject(project).setRegion(region).setTargetPool(targetPool).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteTargetPoolRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTargetPoolRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final TargetPool get(String project, String region, String targetPool) {
        GetTargetPoolRequest request = GetTargetPoolRequest.newBuilder().setProject(project).setRegion(region).setTargetPool(targetPool).build();
        return this.get(request);
    }

    public final TargetPool get(GetTargetPoolRequest request) {
        return (TargetPool)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetPoolRequest, TargetPool> getCallable() {
        return this.stub.getCallable();
    }

    public final TargetPoolInstanceHealth getHealth(String project, String region, String targetPool, InstanceReference instanceReferenceResource) {
        GetHealthTargetPoolRequest request = GetHealthTargetPoolRequest.newBuilder().setProject(project).setRegion(region).setTargetPool(targetPool).setInstanceReferenceResource(instanceReferenceResource).build();
        return this.getHealth(request);
    }

    public final TargetPoolInstanceHealth getHealth(GetHealthTargetPoolRequest request) {
        return (TargetPoolInstanceHealth)this.getHealthCallable().call((Object)request);
    }

    public final UnaryCallable<GetHealthTargetPoolRequest, TargetPoolInstanceHealth> getHealthCallable() {
        return this.stub.getHealthCallable();
    }

    public final Operation insert(String project, String region, TargetPool targetPoolResource) {
        InsertTargetPoolRequest request = InsertTargetPoolRequest.newBuilder().setProject(project).setRegion(region).setTargetPoolResource(targetPoolResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertTargetPoolRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertTargetPoolRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListTargetPoolsRequest request = ListTargetPoolsRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListTargetPoolsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetPoolsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListTargetPoolsRequest, TargetPoolList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation removeHealthCheck(String project, String region, String targetPool, TargetPoolsRemoveHealthCheckRequest targetPoolsRemoveHealthCheckRequestResource) {
        RemoveHealthCheckTargetPoolRequest request = RemoveHealthCheckTargetPoolRequest.newBuilder().setProject(project).setRegion(region).setTargetPool(targetPool).setTargetPoolsRemoveHealthCheckRequestResource(targetPoolsRemoveHealthCheckRequestResource).build();
        return this.removeHealthCheck(request);
    }

    public final Operation removeHealthCheck(RemoveHealthCheckTargetPoolRequest request) {
        return (Operation)this.removeHealthCheckCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveHealthCheckTargetPoolRequest, Operation> removeHealthCheckCallable() {
        return this.stub.removeHealthCheckCallable();
    }

    public final Operation removeInstance(String project, String region, String targetPool, TargetPoolsRemoveInstanceRequest targetPoolsRemoveInstanceRequestResource) {
        RemoveInstanceTargetPoolRequest request = RemoveInstanceTargetPoolRequest.newBuilder().setProject(project).setRegion(region).setTargetPool(targetPool).setTargetPoolsRemoveInstanceRequestResource(targetPoolsRemoveInstanceRequestResource).build();
        return this.removeInstance(request);
    }

    public final Operation removeInstance(RemoveInstanceTargetPoolRequest request) {
        return (Operation)this.removeInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveInstanceTargetPoolRequest, Operation> removeInstanceCallable() {
        return this.stub.removeInstanceCallable();
    }

    public final Operation setBackup(String project, String region, String targetPool, TargetReference targetReferenceResource) {
        SetBackupTargetPoolRequest request = SetBackupTargetPoolRequest.newBuilder().setProject(project).setRegion(region).setTargetPool(targetPool).setTargetReferenceResource(targetReferenceResource).build();
        return this.setBackup(request);
    }

    public final Operation setBackup(SetBackupTargetPoolRequest request) {
        return (Operation)this.setBackupCallable().call((Object)request);
    }

    public final UnaryCallable<SetBackupTargetPoolRequest, Operation> setBackupCallable() {
        return this.stub.setBackupCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetPoolsRequest, TargetPoolList, TargetPool, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListTargetPoolsRequest, TargetPoolList, TargetPool, ListPage> {
        private ListPage(PageContext<ListTargetPoolsRequest, TargetPoolList, TargetPool> context, TargetPoolList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListTargetPoolsRequest, TargetPoolList, TargetPool> context, TargetPoolList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListTargetPoolsRequest, TargetPoolList, TargetPool> context, ApiFuture<TargetPoolList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListTargetPoolsRequest, TargetPoolList, TargetPool, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListTargetPoolsRequest, TargetPoolList, TargetPool> context, ApiFuture<TargetPoolList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, Map.Entry<String, TargetPoolsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, Map.Entry<String, TargetPoolsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, Map.Entry<String, TargetPoolsScopedList>> context, TargetPoolAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, Map.Entry<String, TargetPoolsScopedList>> context, TargetPoolAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, Map.Entry<String, TargetPoolsScopedList>> context, ApiFuture<TargetPoolAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, Map.Entry<String, TargetPoolsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, Map.Entry<String, TargetPoolsScopedList>> context, ApiFuture<TargetPoolAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

