/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListTargetHttpsProxiesRequest;
import com.google.cloud.compute.v1.DeleteTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.GetTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.InsertTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.ListTargetHttpsProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetQuicOverrideTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetSslCertificatesTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetSslPolicyTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetUrlMapTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SslPolicyReference;
import com.google.cloud.compute.v1.TargetHttpsProxiesScopedList;
import com.google.cloud.compute.v1.TargetHttpsProxiesSetQuicOverrideRequest;
import com.google.cloud.compute.v1.TargetHttpsProxiesSetSslCertificatesRequest;
import com.google.cloud.compute.v1.TargetHttpsProxiesSettings;
import com.google.cloud.compute.v1.TargetHttpsProxy;
import com.google.cloud.compute.v1.TargetHttpsProxyAggregatedList;
import com.google.cloud.compute.v1.TargetHttpsProxyList;
import com.google.cloud.compute.v1.UrlMapReference;
import com.google.cloud.compute.v1.stub.TargetHttpsProxiesStub;
import com.google.cloud.compute.v1.stub.TargetHttpsProxiesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TargetHttpsProxiesClient
implements BackgroundResource {
    private final TargetHttpsProxiesSettings settings;
    private final TargetHttpsProxiesStub stub;

    public static final TargetHttpsProxiesClient create() throws IOException {
        return TargetHttpsProxiesClient.create(TargetHttpsProxiesSettings.newBuilder().build());
    }

    public static final TargetHttpsProxiesClient create(TargetHttpsProxiesSettings settings) throws IOException {
        return new TargetHttpsProxiesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TargetHttpsProxiesClient create(TargetHttpsProxiesStub stub) {
        return new TargetHttpsProxiesClient(stub);
    }

    protected TargetHttpsProxiesClient(TargetHttpsProxiesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetHttpsProxiesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TargetHttpsProxiesClient(TargetHttpsProxiesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetHttpsProxiesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetHttpsProxiesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListTargetHttpsProxiesRequest request = AggregatedListTargetHttpsProxiesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListTargetHttpsProxiesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListTargetHttpsProxiesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String targetHttpsProxy) {
        DeleteTargetHttpsProxyRequest request = DeleteTargetHttpsProxyRequest.newBuilder().setProject(project).setTargetHttpsProxy(targetHttpsProxy).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteTargetHttpsProxyRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTargetHttpsProxyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final TargetHttpsProxy get(String project, String targetHttpsProxy) {
        GetTargetHttpsProxyRequest request = GetTargetHttpsProxyRequest.newBuilder().setProject(project).setTargetHttpsProxy(targetHttpsProxy).build();
        return this.get(request);
    }

    public final TargetHttpsProxy get(GetTargetHttpsProxyRequest request) {
        return (TargetHttpsProxy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetHttpsProxyRequest, TargetHttpsProxy> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, TargetHttpsProxy targetHttpsProxyResource) {
        InsertTargetHttpsProxyRequest request = InsertTargetHttpsProxyRequest.newBuilder().setProject(project).setTargetHttpsProxyResource(targetHttpsProxyResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertTargetHttpsProxyRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertTargetHttpsProxyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListTargetHttpsProxiesRequest request = ListTargetHttpsProxiesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListTargetHttpsProxiesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetHttpsProxiesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListTargetHttpsProxiesRequest, TargetHttpsProxyList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String targetHttpsProxy, TargetHttpsProxy targetHttpsProxyResource) {
        PatchTargetHttpsProxyRequest request = PatchTargetHttpsProxyRequest.newBuilder().setProject(project).setTargetHttpsProxy(targetHttpsProxy).setTargetHttpsProxyResource(targetHttpsProxyResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchTargetHttpsProxyRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchTargetHttpsProxyRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation setQuicOverride(String project, String targetHttpsProxy, TargetHttpsProxiesSetQuicOverrideRequest targetHttpsProxiesSetQuicOverrideRequestResource) {
        SetQuicOverrideTargetHttpsProxyRequest request = SetQuicOverrideTargetHttpsProxyRequest.newBuilder().setProject(project).setTargetHttpsProxy(targetHttpsProxy).setTargetHttpsProxiesSetQuicOverrideRequestResource(targetHttpsProxiesSetQuicOverrideRequestResource).build();
        return this.setQuicOverride(request);
    }

    public final Operation setQuicOverride(SetQuicOverrideTargetHttpsProxyRequest request) {
        return (Operation)this.setQuicOverrideCallable().call((Object)request);
    }

    public final UnaryCallable<SetQuicOverrideTargetHttpsProxyRequest, Operation> setQuicOverrideCallable() {
        return this.stub.setQuicOverrideCallable();
    }

    public final Operation setSslCertificates(String project, String targetHttpsProxy, TargetHttpsProxiesSetSslCertificatesRequest targetHttpsProxiesSetSslCertificatesRequestResource) {
        SetSslCertificatesTargetHttpsProxyRequest request = SetSslCertificatesTargetHttpsProxyRequest.newBuilder().setProject(project).setTargetHttpsProxy(targetHttpsProxy).setTargetHttpsProxiesSetSslCertificatesRequestResource(targetHttpsProxiesSetSslCertificatesRequestResource).build();
        return this.setSslCertificates(request);
    }

    public final Operation setSslCertificates(SetSslCertificatesTargetHttpsProxyRequest request) {
        return (Operation)this.setSslCertificatesCallable().call((Object)request);
    }

    public final UnaryCallable<SetSslCertificatesTargetHttpsProxyRequest, Operation> setSslCertificatesCallable() {
        return this.stub.setSslCertificatesCallable();
    }

    public final Operation setSslPolicy(String project, String targetHttpsProxy, SslPolicyReference sslPolicyReferenceResource) {
        SetSslPolicyTargetHttpsProxyRequest request = SetSslPolicyTargetHttpsProxyRequest.newBuilder().setProject(project).setTargetHttpsProxy(targetHttpsProxy).setSslPolicyReferenceResource(sslPolicyReferenceResource).build();
        return this.setSslPolicy(request);
    }

    public final Operation setSslPolicy(SetSslPolicyTargetHttpsProxyRequest request) {
        return (Operation)this.setSslPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetSslPolicyTargetHttpsProxyRequest, Operation> setSslPolicyCallable() {
        return this.stub.setSslPolicyCallable();
    }

    public final Operation setUrlMap(String project, String targetHttpsProxy, UrlMapReference urlMapReferenceResource) {
        SetUrlMapTargetHttpsProxyRequest request = SetUrlMapTargetHttpsProxyRequest.newBuilder().setProject(project).setTargetHttpsProxy(targetHttpsProxy).setUrlMapReferenceResource(urlMapReferenceResource).build();
        return this.setUrlMap(request);
    }

    public final Operation setUrlMap(SetUrlMapTargetHttpsProxyRequest request) {
        return (Operation)this.setUrlMapCallable().call((Object)request);
    }

    public final UnaryCallable<SetUrlMapTargetHttpsProxyRequest, Operation> setUrlMapCallable() {
        return this.stub.setUrlMapCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy, ListPage> {
        private ListPage(PageContext<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy> context, TargetHttpsProxyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy> context, TargetHttpsProxyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy> context, ApiFuture<TargetHttpsProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy> context, ApiFuture<TargetHttpsProxyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, Map.Entry<String, TargetHttpsProxiesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, Map.Entry<String, TargetHttpsProxiesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, Map.Entry<String, TargetHttpsProxiesScopedList>> context, TargetHttpsProxyAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, Map.Entry<String, TargetHttpsProxiesScopedList>> context, TargetHttpsProxyAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, Map.Entry<String, TargetHttpsProxiesScopedList>> context, ApiFuture<TargetHttpsProxyAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, Map.Entry<String, TargetHttpsProxiesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, Map.Entry<String, TargetHttpsProxiesScopedList>> context, ApiFuture<TargetHttpsProxyAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

