/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddResourcePoliciesRegionDiskRequest;
import com.google.cloud.compute.v1.CreateSnapshotRegionDiskRequest;
import com.google.cloud.compute.v1.DeleteRegionDiskRequest;
import com.google.cloud.compute.v1.Disk;
import com.google.cloud.compute.v1.DiskList;
import com.google.cloud.compute.v1.GetIamPolicyRegionDiskRequest;
import com.google.cloud.compute.v1.GetRegionDiskRequest;
import com.google.cloud.compute.v1.InsertRegionDiskRequest;
import com.google.cloud.compute.v1.ListRegionDisksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RegionDisksAddResourcePoliciesRequest;
import com.google.cloud.compute.v1.RegionDisksRemoveResourcePoliciesRequest;
import com.google.cloud.compute.v1.RegionDisksResizeRequest;
import com.google.cloud.compute.v1.RegionDisksSettings;
import com.google.cloud.compute.v1.RegionSetLabelsRequest;
import com.google.cloud.compute.v1.RegionSetPolicyRequest;
import com.google.cloud.compute.v1.RemoveResourcePoliciesRegionDiskRequest;
import com.google.cloud.compute.v1.ResizeRegionDiskRequest;
import com.google.cloud.compute.v1.SetIamPolicyRegionDiskRequest;
import com.google.cloud.compute.v1.SetLabelsRegionDiskRequest;
import com.google.cloud.compute.v1.Snapshot;
import com.google.cloud.compute.v1.TestIamPermissionsRegionDiskRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.RegionDisksStub;
import com.google.cloud.compute.v1.stub.RegionDisksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionDisksClient
implements BackgroundResource {
    private final RegionDisksSettings settings;
    private final RegionDisksStub stub;

    public static final RegionDisksClient create() throws IOException {
        return RegionDisksClient.create(RegionDisksSettings.newBuilder().build());
    }

    public static final RegionDisksClient create(RegionDisksSettings settings) throws IOException {
        return new RegionDisksClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionDisksClient create(RegionDisksStub stub) {
        return new RegionDisksClient(stub);
    }

    protected RegionDisksClient(RegionDisksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionDisksStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionDisksClient(RegionDisksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionDisksSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionDisksStub getStub() {
        return this.stub;
    }

    public final Operation addResourcePolicies(String project, String region, String disk, RegionDisksAddResourcePoliciesRequest regionDisksAddResourcePoliciesRequestResource) {
        AddResourcePoliciesRegionDiskRequest request = AddResourcePoliciesRegionDiskRequest.newBuilder().setProject(project).setRegion(region).setDisk(disk).setRegionDisksAddResourcePoliciesRequestResource(regionDisksAddResourcePoliciesRequestResource).build();
        return this.addResourcePolicies(request);
    }

    public final Operation addResourcePolicies(AddResourcePoliciesRegionDiskRequest request) {
        return (Operation)this.addResourcePoliciesCallable().call((Object)request);
    }

    public final UnaryCallable<AddResourcePoliciesRegionDiskRequest, Operation> addResourcePoliciesCallable() {
        return this.stub.addResourcePoliciesCallable();
    }

    public final Operation createSnapshot(String project, String region, String disk, Snapshot snapshotResource) {
        CreateSnapshotRegionDiskRequest request = CreateSnapshotRegionDiskRequest.newBuilder().setProject(project).setRegion(region).setDisk(disk).setSnapshotResource(snapshotResource).build();
        return this.createSnapshot(request);
    }

    public final Operation createSnapshot(CreateSnapshotRegionDiskRequest request) {
        return (Operation)this.createSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSnapshotRegionDiskRequest, Operation> createSnapshotCallable() {
        return this.stub.createSnapshotCallable();
    }

    public final Operation delete(String project, String region, String disk) {
        DeleteRegionDiskRequest request = DeleteRegionDiskRequest.newBuilder().setProject(project).setRegion(region).setDisk(disk).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteRegionDiskRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRegionDiskRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Disk get(String project, String region, String disk) {
        GetRegionDiskRequest request = GetRegionDiskRequest.newBuilder().setProject(project).setRegion(region).setDisk(disk).build();
        return this.get(request);
    }

    public final Disk get(GetRegionDiskRequest request) {
        return (Disk)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionDiskRequest, Disk> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String region, String resource) {
        GetIamPolicyRegionDiskRequest request = GetIamPolicyRegionDiskRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRegionDiskRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRegionDiskRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Operation insert(String project, String region, Disk diskResource) {
        InsertRegionDiskRequest request = InsertRegionDiskRequest.newBuilder().setProject(project).setRegion(region).setDiskResource(diskResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertRegionDiskRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertRegionDiskRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionDisksRequest request = ListRegionDisksRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionDisksRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionDisksRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionDisksRequest, DiskList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation removeResourcePolicies(String project, String region, String disk, RegionDisksRemoveResourcePoliciesRequest regionDisksRemoveResourcePoliciesRequestResource) {
        RemoveResourcePoliciesRegionDiskRequest request = RemoveResourcePoliciesRegionDiskRequest.newBuilder().setProject(project).setRegion(region).setDisk(disk).setRegionDisksRemoveResourcePoliciesRequestResource(regionDisksRemoveResourcePoliciesRequestResource).build();
        return this.removeResourcePolicies(request);
    }

    public final Operation removeResourcePolicies(RemoveResourcePoliciesRegionDiskRequest request) {
        return (Operation)this.removeResourcePoliciesCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveResourcePoliciesRegionDiskRequest, Operation> removeResourcePoliciesCallable() {
        return this.stub.removeResourcePoliciesCallable();
    }

    public final Operation resize(String project, String region, String disk, RegionDisksResizeRequest regionDisksResizeRequestResource) {
        ResizeRegionDiskRequest request = ResizeRegionDiskRequest.newBuilder().setProject(project).setRegion(region).setDisk(disk).setRegionDisksResizeRequestResource(regionDisksResizeRequestResource).build();
        return this.resize(request);
    }

    public final Operation resize(ResizeRegionDiskRequest request) {
        return (Operation)this.resizeCallable().call((Object)request);
    }

    public final UnaryCallable<ResizeRegionDiskRequest, Operation> resizeCallable() {
        return this.stub.resizeCallable();
    }

    public final Policy setIamPolicy(String project, String region, String resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicyRegionDiskRequest request = SetIamPolicyRegionDiskRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRegionDiskRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRegionDiskRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Operation setLabels(String project, String region, String resource, RegionSetLabelsRequest regionSetLabelsRequestResource) {
        SetLabelsRegionDiskRequest request = SetLabelsRegionDiskRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetLabelsRequestResource(regionSetLabelsRequestResource).build();
        return this.setLabels(request);
    }

    public final Operation setLabels(SetLabelsRegionDiskRequest request) {
        return (Operation)this.setLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<SetLabelsRegionDiskRequest, Operation> setLabelsCallable() {
        return this.stub.setLabelsCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String region, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsRegionDiskRequest request = TestIamPermissionsRegionDiskRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsRegionDiskRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRegionDiskRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionDisksRequest, DiskList, Disk, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionDisksRequest, DiskList, Disk, ListPage> {
        private ListPage(PageContext<ListRegionDisksRequest, DiskList, Disk> context, DiskList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionDisksRequest, DiskList, Disk> context, DiskList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionDisksRequest, DiskList, Disk> context, ApiFuture<DiskList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionDisksRequest, DiskList, Disk, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionDisksRequest, DiskList, Disk> context, ApiFuture<DiskList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

