/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddInstancesInstanceGroupRequest;
import com.google.cloud.compute.v1.AggregatedListInstanceGroupsRequest;
import com.google.cloud.compute.v1.DeleteInstanceGroupRequest;
import com.google.cloud.compute.v1.GetInstanceGroupRequest;
import com.google.cloud.compute.v1.InsertInstanceGroupRequest;
import com.google.cloud.compute.v1.InstanceGroup;
import com.google.cloud.compute.v1.InstanceGroupAggregatedList;
import com.google.cloud.compute.v1.InstanceGroupList;
import com.google.cloud.compute.v1.InstanceGroupsAddInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupsListInstances;
import com.google.cloud.compute.v1.InstanceGroupsListInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupsRemoveInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupsScopedList;
import com.google.cloud.compute.v1.InstanceGroupsSetNamedPortsRequest;
import com.google.cloud.compute.v1.InstanceGroupsSettings;
import com.google.cloud.compute.v1.InstanceWithNamedPorts;
import com.google.cloud.compute.v1.ListInstanceGroupsRequest;
import com.google.cloud.compute.v1.ListInstancesInstanceGroupsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RemoveInstancesInstanceGroupRequest;
import com.google.cloud.compute.v1.SetNamedPortsInstanceGroupRequest;
import com.google.cloud.compute.v1.stub.InstanceGroupsStub;
import com.google.cloud.compute.v1.stub.InstanceGroupsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InstanceGroupsClient
implements BackgroundResource {
    private final InstanceGroupsSettings settings;
    private final InstanceGroupsStub stub;

    public static final InstanceGroupsClient create() throws IOException {
        return InstanceGroupsClient.create(InstanceGroupsSettings.newBuilder().build());
    }

    public static final InstanceGroupsClient create(InstanceGroupsSettings settings) throws IOException {
        return new InstanceGroupsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InstanceGroupsClient create(InstanceGroupsStub stub) {
        return new InstanceGroupsClient(stub);
    }

    protected InstanceGroupsClient(InstanceGroupsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstanceGroupsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InstanceGroupsClient(InstanceGroupsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InstanceGroupsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstanceGroupsStub getStub() {
        return this.stub;
    }

    public final Operation addInstances(String project, String zone, String instanceGroup, InstanceGroupsAddInstancesRequest instanceGroupsAddInstancesRequestResource) {
        AddInstancesInstanceGroupRequest request = AddInstancesInstanceGroupRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroup(instanceGroup).setInstanceGroupsAddInstancesRequestResource(instanceGroupsAddInstancesRequestResource).build();
        return this.addInstances(request);
    }

    public final Operation addInstances(AddInstancesInstanceGroupRequest request) {
        return (Operation)this.addInstancesCallable().call((Object)request);
    }

    public final UnaryCallable<AddInstancesInstanceGroupRequest, Operation> addInstancesCallable() {
        return this.stub.addInstancesCallable();
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListInstanceGroupsRequest request = AggregatedListInstanceGroupsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListInstanceGroupsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListInstanceGroupsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String zone, String instanceGroup) {
        DeleteInstanceGroupRequest request = DeleteInstanceGroupRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroup(instanceGroup).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteInstanceGroupRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteInstanceGroupRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final InstanceGroup get(String project, String zone, String instanceGroup) {
        GetInstanceGroupRequest request = GetInstanceGroupRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroup(instanceGroup).build();
        return this.get(request);
    }

    public final InstanceGroup get(GetInstanceGroupRequest request) {
        return (InstanceGroup)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceGroupRequest, InstanceGroup> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String zone, InstanceGroup instanceGroupResource) {
        InsertInstanceGroupRequest request = InsertInstanceGroupRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupResource(instanceGroupResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertInstanceGroupRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertInstanceGroupRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListInstanceGroupsRequest request = ListInstanceGroupsRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListInstanceGroupsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstanceGroupsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListInstanceGroupsRequest, InstanceGroupList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListInstancesPagedResponse listInstances(String project, String zone, String instanceGroup, InstanceGroupsListInstancesRequest instanceGroupsListInstancesRequestResource) {
        ListInstancesInstanceGroupsRequest request = ListInstancesInstanceGroupsRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroup(instanceGroup).setInstanceGroupsListInstancesRequestResource(instanceGroupsListInstancesRequestResource).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesInstanceGroupsRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesInstanceGroupsRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Operation removeInstances(String project, String zone, String instanceGroup, InstanceGroupsRemoveInstancesRequest instanceGroupsRemoveInstancesRequestResource) {
        RemoveInstancesInstanceGroupRequest request = RemoveInstancesInstanceGroupRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroup(instanceGroup).setInstanceGroupsRemoveInstancesRequestResource(instanceGroupsRemoveInstancesRequestResource).build();
        return this.removeInstances(request);
    }

    public final Operation removeInstances(RemoveInstancesInstanceGroupRequest request) {
        return (Operation)this.removeInstancesCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveInstancesInstanceGroupRequest, Operation> removeInstancesCallable() {
        return this.stub.removeInstancesCallable();
    }

    public final Operation setNamedPorts(String project, String zone, String instanceGroup, InstanceGroupsSetNamedPortsRequest instanceGroupsSetNamedPortsRequestResource) {
        SetNamedPortsInstanceGroupRequest request = SetNamedPortsInstanceGroupRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroup(instanceGroup).setInstanceGroupsSetNamedPortsRequestResource(instanceGroupsSetNamedPortsRequestResource).build();
        return this.setNamedPorts(request);
    }

    public final Operation setNamedPorts(SetNamedPortsInstanceGroupRequest request) {
        return (Operation)this.setNamedPortsCallable().call((Object)request);
    }

    public final UnaryCallable<SetNamedPortsInstanceGroupRequest, Operation> setNamedPortsCallable() {
        return this.stub.setNamedPortsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceWithNamedPorts, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceWithNamedPorts, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceWithNamedPorts> context, InstanceGroupsListInstances response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceWithNamedPorts> context, InstanceGroupsListInstances response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceWithNamedPorts> context, ApiFuture<InstanceGroupsListInstances> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceWithNamedPorts, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances, InstanceWithNamedPorts> context, ApiFuture<InstanceGroupsListInstances> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancesPagedResponse((ListInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroup, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroup, ListPage> {
        private ListPage(PageContext<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroup> context, InstanceGroupList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroup> context, InstanceGroupList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroup> context, ApiFuture<InstanceGroupList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroup, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListInstanceGroupsRequest, InstanceGroupList, InstanceGroup> context, ApiFuture<InstanceGroupList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, Map.Entry<String, InstanceGroupsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, Map.Entry<String, InstanceGroupsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, Map.Entry<String, InstanceGroupsScopedList>> context, InstanceGroupAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, Map.Entry<String, InstanceGroupsScopedList>> context, InstanceGroupAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, Map.Entry<String, InstanceGroupsScopedList>> context, ApiFuture<InstanceGroupAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, Map.Entry<String, InstanceGroupsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList, Map.Entry<String, InstanceGroupsScopedList>> context, ApiFuture<InstanceGroupAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

