/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.DeleteGlobalNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.GetGlobalNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.GlobalNetworkEndpointGroupsAttachEndpointsRequest;
import com.google.cloud.compute.v1.GlobalNetworkEndpointGroupsDetachEndpointsRequest;
import com.google.cloud.compute.v1.GlobalNetworkEndpointGroupsSettings;
import com.google.cloud.compute.v1.InsertGlobalNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.ListGlobalNetworkEndpointGroupsRequest;
import com.google.cloud.compute.v1.ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroup;
import com.google.cloud.compute.v1.NetworkEndpointGroupList;
import com.google.cloud.compute.v1.NetworkEndpointGroupsListNetworkEndpoints;
import com.google.cloud.compute.v1.NetworkEndpointWithHealthStatus;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.stub.GlobalNetworkEndpointGroupsStub;
import com.google.cloud.compute.v1.stub.GlobalNetworkEndpointGroupsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class GlobalNetworkEndpointGroupsClient
implements BackgroundResource {
    private final GlobalNetworkEndpointGroupsSettings settings;
    private final GlobalNetworkEndpointGroupsStub stub;

    public static final GlobalNetworkEndpointGroupsClient create() throws IOException {
        return GlobalNetworkEndpointGroupsClient.create(GlobalNetworkEndpointGroupsSettings.newBuilder().build());
    }

    public static final GlobalNetworkEndpointGroupsClient create(GlobalNetworkEndpointGroupsSettings settings) throws IOException {
        return new GlobalNetworkEndpointGroupsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GlobalNetworkEndpointGroupsClient create(GlobalNetworkEndpointGroupsStub stub) {
        return new GlobalNetworkEndpointGroupsClient(stub);
    }

    protected GlobalNetworkEndpointGroupsClient(GlobalNetworkEndpointGroupsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GlobalNetworkEndpointGroupsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GlobalNetworkEndpointGroupsClient(GlobalNetworkEndpointGroupsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GlobalNetworkEndpointGroupsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalNetworkEndpointGroupsStub getStub() {
        return this.stub;
    }

    public final Operation attachNetworkEndpoints(String project, String networkEndpointGroup, GlobalNetworkEndpointGroupsAttachEndpointsRequest globalNetworkEndpointGroupsAttachEndpointsRequestResource) {
        AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest request = AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest.newBuilder().setProject(project).setNetworkEndpointGroup(networkEndpointGroup).setGlobalNetworkEndpointGroupsAttachEndpointsRequestResource(globalNetworkEndpointGroupsAttachEndpointsRequestResource).build();
        return this.attachNetworkEndpoints(request);
    }

    public final Operation attachNetworkEndpoints(AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest request) {
        return (Operation)this.attachNetworkEndpointsCallable().call((Object)request);
    }

    public final UnaryCallable<AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest, Operation> attachNetworkEndpointsCallable() {
        return this.stub.attachNetworkEndpointsCallable();
    }

    public final Operation delete(String project, String networkEndpointGroup) {
        DeleteGlobalNetworkEndpointGroupRequest request = DeleteGlobalNetworkEndpointGroupRequest.newBuilder().setProject(project).setNetworkEndpointGroup(networkEndpointGroup).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteGlobalNetworkEndpointGroupRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteGlobalNetworkEndpointGroupRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Operation detachNetworkEndpoints(String project, String networkEndpointGroup, GlobalNetworkEndpointGroupsDetachEndpointsRequest globalNetworkEndpointGroupsDetachEndpointsRequestResource) {
        DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest request = DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest.newBuilder().setProject(project).setNetworkEndpointGroup(networkEndpointGroup).setGlobalNetworkEndpointGroupsDetachEndpointsRequestResource(globalNetworkEndpointGroupsDetachEndpointsRequestResource).build();
        return this.detachNetworkEndpoints(request);
    }

    public final Operation detachNetworkEndpoints(DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest request) {
        return (Operation)this.detachNetworkEndpointsCallable().call((Object)request);
    }

    public final UnaryCallable<DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest, Operation> detachNetworkEndpointsCallable() {
        return this.stub.detachNetworkEndpointsCallable();
    }

    public final NetworkEndpointGroup get(String project, String networkEndpointGroup) {
        GetGlobalNetworkEndpointGroupRequest request = GetGlobalNetworkEndpointGroupRequest.newBuilder().setProject(project).setNetworkEndpointGroup(networkEndpointGroup).build();
        return this.get(request);
    }

    public final NetworkEndpointGroup get(GetGlobalNetworkEndpointGroupRequest request) {
        return (NetworkEndpointGroup)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetGlobalNetworkEndpointGroupRequest, NetworkEndpointGroup> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, NetworkEndpointGroup networkEndpointGroupResource) {
        InsertGlobalNetworkEndpointGroupRequest request = InsertGlobalNetworkEndpointGroupRequest.newBuilder().setProject(project).setNetworkEndpointGroupResource(networkEndpointGroupResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertGlobalNetworkEndpointGroupRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertGlobalNetworkEndpointGroupRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListGlobalNetworkEndpointGroupsRequest request = ListGlobalNetworkEndpointGroupsRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListGlobalNetworkEndpointGroupsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGlobalNetworkEndpointGroupsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListNetworkEndpointsPagedResponse listNetworkEndpoints(String project, String networkEndpointGroup) {
        ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest request = ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest.newBuilder().setProject(project).setNetworkEndpointGroup(networkEndpointGroup).build();
        return this.listNetworkEndpoints(request);
    }

    public final ListNetworkEndpointsPagedResponse listNetworkEndpoints(ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest request) {
        return (ListNetworkEndpointsPagedResponse)((Object)this.listNetworkEndpointsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest, ListNetworkEndpointsPagedResponse> listNetworkEndpointsPagedCallable() {
        return this.stub.listNetworkEndpointsPagedCallable();
    }

    public final UnaryCallable<ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints> listNetworkEndpointsCallable() {
        return this.stub.listNetworkEndpointsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListNetworkEndpointsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus, ListNetworkEndpointsPage, ListNetworkEndpointsFixedSizeCollection> {
        private ListNetworkEndpointsFixedSizeCollection(List<ListNetworkEndpointsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNetworkEndpointsFixedSizeCollection createEmptyCollection() {
            return new ListNetworkEndpointsFixedSizeCollection(null, 0);
        }

        protected ListNetworkEndpointsFixedSizeCollection createCollection(List<ListNetworkEndpointsPage> pages, int collectionSize) {
            return new ListNetworkEndpointsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNetworkEndpointsPage
    extends AbstractPage<ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus, ListNetworkEndpointsPage> {
        private ListNetworkEndpointsPage(PageContext<ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> context, NetworkEndpointGroupsListNetworkEndpoints response) {
            super(context, (Object)response);
        }

        private static ListNetworkEndpointsPage createEmptyPage() {
            return new ListNetworkEndpointsPage(null, null);
        }

        protected ListNetworkEndpointsPage createPage(PageContext<ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> context, NetworkEndpointGroupsListNetworkEndpoints response) {
            return new ListNetworkEndpointsPage(context, response);
        }

        public ApiFuture<ListNetworkEndpointsPage> createPageAsync(PageContext<ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> context, ApiFuture<NetworkEndpointGroupsListNetworkEndpoints> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNetworkEndpointsPagedResponse
    extends AbstractPagedListResponse<ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus, ListNetworkEndpointsPage, ListNetworkEndpointsFixedSizeCollection> {
        public static ApiFuture<ListNetworkEndpointsPagedResponse> createAsync(PageContext<ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> context, ApiFuture<NetworkEndpointGroupsListNetworkEndpoints> futureResponse) {
            ApiFuture<ListNetworkEndpointsPage> futurePage = ListNetworkEndpointsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNetworkEndpointsPagedResponse((ListNetworkEndpointsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNetworkEndpointsPagedResponse(ListNetworkEndpointsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNetworkEndpointsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListPage> {
        private ListPage(PageContext<ListGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, NetworkEndpointGroupList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, NetworkEndpointGroupList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListGlobalNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

