/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AttachNetworkEndpointsRegionNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.DeleteRegionNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.DetachNetworkEndpointsRegionNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.GetRegionNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.InsertRegionNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.ListNetworkEndpointsRegionNetworkEndpointGroupsRequest;
import com.google.cloud.compute.v1.ListRegionNetworkEndpointGroupsRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroup;
import com.google.cloud.compute.v1.NetworkEndpointGroupList;
import com.google.cloud.compute.v1.NetworkEndpointGroupsListNetworkEndpoints;
import com.google.cloud.compute.v1.NetworkEndpointWithHealthStatus;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionNetworkEndpointGroupsClient;
import com.google.cloud.compute.v1.stub.HttpJsonRegionNetworkEndpointGroupsStub;
import com.google.cloud.compute.v1.stub.RegionNetworkEndpointGroupsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RegionNetworkEndpointGroupsStubSettings
extends StubSettings<RegionNetworkEndpointGroupsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AttachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation> attachNetworkEndpointsSettings;
    private final OperationCallSettings<AttachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation, Operation> attachNetworkEndpointsOperationSettings;
    private final UnaryCallSettings<DeleteRegionNetworkEndpointGroupRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteRegionNetworkEndpointGroupRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<DetachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation> detachNetworkEndpointsSettings;
    private final OperationCallSettings<DetachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation, Operation> detachNetworkEndpointsOperationSettings;
    private final UnaryCallSettings<GetRegionNetworkEndpointGroupRequest, NetworkEndpointGroup> getSettings;
    private final UnaryCallSettings<InsertRegionNetworkEndpointGroupRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertRegionNetworkEndpointGroupRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, RegionNetworkEndpointGroupsClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListNetworkEndpointsRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, RegionNetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse> listNetworkEndpointsSettings;
    private static final PagedListDescriptor<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionNetworkEndpointGroupsRequest injectToken(ListRegionNetworkEndpointGroupsRequest payload, String token) {
            return ListRegionNetworkEndpointGroupsRequest.newBuilder((ListRegionNetworkEndpointGroupsRequest)payload).setPageToken(token).build();
        }

        public ListRegionNetworkEndpointGroupsRequest injectPageSize(ListRegionNetworkEndpointGroupsRequest payload, int pageSize) {
            return ListRegionNetworkEndpointGroupsRequest.newBuilder((ListRegionNetworkEndpointGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionNetworkEndpointGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkEndpointGroupList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NetworkEndpointGroup> extractResources(NetworkEndpointGroupList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListNetworkEndpointsRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> LIST_NETWORK_ENDPOINTS_PAGE_STR_DESC = new PagedListDescriptor<ListNetworkEndpointsRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus>(){

        public String emptyToken() {
            return "";
        }

        public ListNetworkEndpointsRegionNetworkEndpointGroupsRequest injectToken(ListNetworkEndpointsRegionNetworkEndpointGroupsRequest payload, String token) {
            return ListNetworkEndpointsRegionNetworkEndpointGroupsRequest.newBuilder((ListNetworkEndpointsRegionNetworkEndpointGroupsRequest)payload).setPageToken(token).build();
        }

        public ListNetworkEndpointsRegionNetworkEndpointGroupsRequest injectPageSize(ListNetworkEndpointsRegionNetworkEndpointGroupsRequest payload, int pageSize) {
            return ListNetworkEndpointsRegionNetworkEndpointGroupsRequest.newBuilder((ListNetworkEndpointsRegionNetworkEndpointGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNetworkEndpointsRegionNetworkEndpointGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkEndpointGroupsListNetworkEndpoints payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NetworkEndpointWithHealthStatus> extractResources(NetworkEndpointGroupsListNetworkEndpoints payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, RegionNetworkEndpointGroupsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, RegionNetworkEndpointGroupsClient.ListPagedResponse>(){

        public ApiFuture<RegionNetworkEndpointGroupsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList> callable, ListRegionNetworkEndpointGroupsRequest request, ApiCallContext context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionNetworkEndpointGroupsClient.ListPagedResponse.createAsync((PageContext<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNetworkEndpointsRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, RegionNetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse> LIST_NETWORK_ENDPOINTS_PAGE_STR_FACT = new PagedListResponseFactory<ListNetworkEndpointsRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, RegionNetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse>(){

        public ApiFuture<RegionNetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse> getFuturePagedResponse(UnaryCallable<ListNetworkEndpointsRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints> callable, ListNetworkEndpointsRegionNetworkEndpointGroupsRequest request, ApiCallContext context, ApiFuture<NetworkEndpointGroupsListNetworkEndpoints> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NETWORK_ENDPOINTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionNetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse.createAsync((PageContext<ListNetworkEndpointsRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AttachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation> attachNetworkEndpointsSettings() {
        return this.attachNetworkEndpointsSettings;
    }

    public OperationCallSettings<AttachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation, Operation> attachNetworkEndpointsOperationSettings() {
        return this.attachNetworkEndpointsOperationSettings;
    }

    public UnaryCallSettings<DeleteRegionNetworkEndpointGroupRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteRegionNetworkEndpointGroupRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<DetachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation> detachNetworkEndpointsSettings() {
        return this.detachNetworkEndpointsSettings;
    }

    public OperationCallSettings<DetachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation, Operation> detachNetworkEndpointsOperationSettings() {
        return this.detachNetworkEndpointsOperationSettings;
    }

    public UnaryCallSettings<GetRegionNetworkEndpointGroupRequest, NetworkEndpointGroup> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertRegionNetworkEndpointGroupRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertRegionNetworkEndpointGroupRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, RegionNetworkEndpointGroupsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListNetworkEndpointsRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, RegionNetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse> listNetworkEndpointsSettings() {
        return this.listNetworkEndpointsSettings;
    }

    public RegionNetworkEndpointGroupsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionNetworkEndpointGroupsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return RegionNetworkEndpointGroupsStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionNetworkEndpointGroupsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionNetworkEndpointGroupsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionNetworkEndpointGroupsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.attachNetworkEndpointsSettings = settingsBuilder.attachNetworkEndpointsSettings().build();
        this.attachNetworkEndpointsOperationSettings = settingsBuilder.attachNetworkEndpointsOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.detachNetworkEndpointsSettings = settingsBuilder.detachNetworkEndpointsSettings().build();
        this.detachNetworkEndpointsOperationSettings = settingsBuilder.detachNetworkEndpointsOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listNetworkEndpointsSettings = settingsBuilder.listNetworkEndpointsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionNetworkEndpointGroupsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AttachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation> attachNetworkEndpointsSettings;
        private final OperationCallSettings.Builder<AttachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation, Operation> attachNetworkEndpointsOperationSettings;
        private final UnaryCallSettings.Builder<DeleteRegionNetworkEndpointGroupRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteRegionNetworkEndpointGroupRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<DetachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation> detachNetworkEndpointsSettings;
        private final OperationCallSettings.Builder<DetachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation, Operation> detachNetworkEndpointsOperationSettings;
        private final UnaryCallSettings.Builder<GetRegionNetworkEndpointGroupRequest, NetworkEndpointGroup> getSettings;
        private final UnaryCallSettings.Builder<InsertRegionNetworkEndpointGroupRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertRegionNetworkEndpointGroupRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, RegionNetworkEndpointGroupsClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListNetworkEndpointsRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, RegionNetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse> listNetworkEndpointsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.attachNetworkEndpointsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.attachNetworkEndpointsOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.detachNetworkEndpointsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.detachNetworkEndpointsOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listNetworkEndpointsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NETWORK_ENDPOINTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.attachNetworkEndpointsSettings, this.deleteSettings, this.detachNetworkEndpointsSettings, this.getSettings, this.insertSettings, this.listSettings, this.listNetworkEndpointsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(RegionNetworkEndpointGroupsStubSettings settings) {
            super((StubSettings)settings);
            this.attachNetworkEndpointsSettings = settings.attachNetworkEndpointsSettings.toBuilder();
            this.attachNetworkEndpointsOperationSettings = settings.attachNetworkEndpointsOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.detachNetworkEndpointsSettings = settings.detachNetworkEndpointsSettings.toBuilder();
            this.detachNetworkEndpointsOperationSettings = settings.detachNetworkEndpointsOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listNetworkEndpointsSettings = settings.listNetworkEndpointsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.attachNetworkEndpointsSettings, this.deleteSettings, this.detachNetworkEndpointsSettings, this.getSettings, this.insertSettings, this.listSettings, this.listNetworkEndpointsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionNetworkEndpointGroupsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionNetworkEndpointGroupsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionNetworkEndpointGroupsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RegionNetworkEndpointGroupsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.attachNetworkEndpointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.detachNetworkEndpointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listNetworkEndpointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.attachNetworkEndpointsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.detachNetworkEndpointsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AttachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation> attachNetworkEndpointsSettings() {
            return this.attachNetworkEndpointsSettings;
        }

        public OperationCallSettings.Builder<AttachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation, Operation> attachNetworkEndpointsOperationSettings() {
            return this.attachNetworkEndpointsOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteRegionNetworkEndpointGroupRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteRegionNetworkEndpointGroupRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<DetachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation> detachNetworkEndpointsSettings() {
            return this.detachNetworkEndpointsSettings;
        }

        public OperationCallSettings.Builder<DetachNetworkEndpointsRegionNetworkEndpointGroupRequest, Operation, Operation> detachNetworkEndpointsOperationSettings() {
            return this.detachNetworkEndpointsOperationSettings;
        }

        public UnaryCallSettings.Builder<GetRegionNetworkEndpointGroupRequest, NetworkEndpointGroup> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionNetworkEndpointGroupRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertRegionNetworkEndpointGroupRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupList, RegionNetworkEndpointGroupsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListNetworkEndpointsRegionNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, RegionNetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse> listNetworkEndpointsSettings() {
            return this.listNetworkEndpointsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return RegionNetworkEndpointGroupsStubSettings.getDefaultEndpoint();
        }

        public RegionNetworkEndpointGroupsStubSettings build() throws IOException {
            return new RegionNetworkEndpointGroupsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

