/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListInstantSnapshotsRequest;
import com.google.cloud.compute.v1.DeleteInstantSnapshotRequest;
import com.google.cloud.compute.v1.GetIamPolicyInstantSnapshotRequest;
import com.google.cloud.compute.v1.GetInstantSnapshotRequest;
import com.google.cloud.compute.v1.InsertInstantSnapshotRequest;
import com.google.cloud.compute.v1.InstantSnapshot;
import com.google.cloud.compute.v1.InstantSnapshotAggregatedList;
import com.google.cloud.compute.v1.InstantSnapshotList;
import com.google.cloud.compute.v1.InstantSnapshotsScopedList;
import com.google.cloud.compute.v1.InstantSnapshotsSettings;
import com.google.cloud.compute.v1.ListInstantSnapshotsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyInstantSnapshotRequest;
import com.google.cloud.compute.v1.SetLabelsInstantSnapshotRequest;
import com.google.cloud.compute.v1.TestIamPermissionsInstantSnapshotRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.ZoneSetLabelsRequest;
import com.google.cloud.compute.v1.ZoneSetPolicyRequest;
import com.google.cloud.compute.v1.stub.InstantSnapshotsStub;
import com.google.cloud.compute.v1.stub.InstantSnapshotsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InstantSnapshotsClient
implements BackgroundResource {
    private final InstantSnapshotsSettings settings;
    private final InstantSnapshotsStub stub;

    public static final InstantSnapshotsClient create() throws IOException {
        return InstantSnapshotsClient.create(InstantSnapshotsSettings.newBuilder().build());
    }

    public static final InstantSnapshotsClient create(InstantSnapshotsSettings settings) throws IOException {
        return new InstantSnapshotsClient(settings);
    }

    public static final InstantSnapshotsClient create(InstantSnapshotsStub stub) {
        return new InstantSnapshotsClient(stub);
    }

    protected InstantSnapshotsClient(InstantSnapshotsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstantSnapshotsStubSettings)settings.getStubSettings()).createStub();
    }

    protected InstantSnapshotsClient(InstantSnapshotsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InstantSnapshotsSettings getSettings() {
        return this.settings;
    }

    public InstantSnapshotsStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListInstantSnapshotsRequest request = AggregatedListInstantSnapshotsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListInstantSnapshotsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListInstantSnapshotsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListInstantSnapshotsRequest, InstantSnapshotAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String zone, String instantSnapshot) {
        DeleteInstantSnapshotRequest request = DeleteInstantSnapshotRequest.newBuilder().setProject(project).setZone(zone).setInstantSnapshot(instantSnapshot).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteInstantSnapshotRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInstantSnapshotRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteInstantSnapshotRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final InstantSnapshot get(String project, String zone, String instantSnapshot) {
        GetInstantSnapshotRequest request = GetInstantSnapshotRequest.newBuilder().setProject(project).setZone(zone).setInstantSnapshot(instantSnapshot).build();
        return this.get(request);
    }

    public final InstantSnapshot get(GetInstantSnapshotRequest request) {
        return (InstantSnapshot)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstantSnapshotRequest, InstantSnapshot> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String zone, String resource) {
        GetIamPolicyInstantSnapshotRequest request = GetIamPolicyInstantSnapshotRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyInstantSnapshotRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyInstantSnapshotRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String zone, InstantSnapshot instantSnapshotResource) {
        InsertInstantSnapshotRequest request = InsertInstantSnapshotRequest.newBuilder().setProject(project).setZone(zone).setInstantSnapshotResource(instantSnapshotResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertInstantSnapshotRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertInstantSnapshotRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertInstantSnapshotRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListInstantSnapshotsRequest request = ListInstantSnapshotsRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListInstantSnapshotsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstantSnapshotsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListInstantSnapshotsRequest, InstantSnapshotList> listCallable() {
        return this.stub.listCallable();
    }

    public final Policy setIamPolicy(String project, String zone, String resource, ZoneSetPolicyRequest zoneSetPolicyRequestResource) {
        SetIamPolicyInstantSnapshotRequest request = SetIamPolicyInstantSnapshotRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).setZoneSetPolicyRequestResource(zoneSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyInstantSnapshotRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyInstantSnapshotRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> setLabelsAsync(String project, String zone, String resource, ZoneSetLabelsRequest zoneSetLabelsRequestResource) {
        SetLabelsInstantSnapshotRequest request = SetLabelsInstantSnapshotRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).setZoneSetLabelsRequestResource(zoneSetLabelsRequestResource).build();
        return this.setLabelsAsync(request);
    }

    public final OperationFuture<Operation, Operation> setLabelsAsync(SetLabelsInstantSnapshotRequest request) {
        return this.setLabelsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetLabelsInstantSnapshotRequest, Operation, Operation> setLabelsOperationCallable() {
        return this.stub.setLabelsOperationCallable();
    }

    public final UnaryCallable<SetLabelsInstantSnapshotRequest, Operation> setLabelsCallable() {
        return this.stub.setLabelsCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String zone, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsInstantSnapshotRequest request = TestIamPermissionsInstantSnapshotRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsInstantSnapshotRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsInstantSnapshotRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot, ListPage> {
        private ListPage(PageContext<ListInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot> context, InstantSnapshotList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot> context, InstantSnapshotList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot> context, ApiFuture<InstantSnapshotList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot> context, ApiFuture<InstantSnapshotList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListInstantSnapshotsRequest, InstantSnapshotAggregatedList, Map.Entry<String, InstantSnapshotsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListInstantSnapshotsRequest, InstantSnapshotAggregatedList, Map.Entry<String, InstantSnapshotsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListInstantSnapshotsRequest, InstantSnapshotAggregatedList, Map.Entry<String, InstantSnapshotsScopedList>> context, InstantSnapshotAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListInstantSnapshotsRequest, InstantSnapshotAggregatedList, Map.Entry<String, InstantSnapshotsScopedList>> context, InstantSnapshotAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListInstantSnapshotsRequest, InstantSnapshotAggregatedList, Map.Entry<String, InstantSnapshotsScopedList>> context, ApiFuture<InstantSnapshotAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListInstantSnapshotsRequest, InstantSnapshotAggregatedList, Map.Entry<String, InstantSnapshotsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListInstantSnapshotsRequest, InstantSnapshotAggregatedList, Map.Entry<String, InstantSnapshotsScopedList>> context, ApiFuture<InstantSnapshotAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

