/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteInterconnectRequest;
import com.google.cloud.compute.v1.GetDiagnosticsInterconnectRequest;
import com.google.cloud.compute.v1.GetInterconnectRequest;
import com.google.cloud.compute.v1.GetMacsecConfigInterconnectRequest;
import com.google.cloud.compute.v1.InsertInterconnectRequest;
import com.google.cloud.compute.v1.Interconnect;
import com.google.cloud.compute.v1.InterconnectList;
import com.google.cloud.compute.v1.InterconnectsClient;
import com.google.cloud.compute.v1.InterconnectsGetDiagnosticsResponse;
import com.google.cloud.compute.v1.InterconnectsGetMacsecConfigResponse;
import com.google.cloud.compute.v1.ListInterconnectsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInterconnectRequest;
import com.google.cloud.compute.v1.SetLabelsInterconnectRequest;
import com.google.cloud.compute.v1.stub.HttpJsonGlobalOperationsStub;
import com.google.cloud.compute.v1.stub.HttpJsonInterconnectsCallableFactory;
import com.google.cloud.compute.v1.stub.InterconnectsStub;
import com.google.cloud.compute.v1.stub.InterconnectsStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonInterconnectsStub
extends InterconnectsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Operation.getDescriptor()).build();
    private static final ApiMethodDescriptor<DeleteInterconnectRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Interconnects/Delete").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnects/{interconnect}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "interconnect", (Object)request.getInterconnect());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<GetInterconnectRequest, Interconnect> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Interconnects/Get").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnects/{interconnect}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "interconnect", (Object)request.getInterconnect());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Interconnect.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetDiagnosticsInterconnectRequest, InterconnectsGetDiagnosticsResponse> getDiagnosticsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Interconnects/GetDiagnostics").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnects/{interconnect}/getDiagnostics", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "interconnect", (Object)request.getInterconnect());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)InterconnectsGetDiagnosticsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetMacsecConfigInterconnectRequest, InterconnectsGetMacsecConfigResponse> getMacsecConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Interconnects/GetMacsecConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnects/{interconnect}/getMacsecConfig", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "interconnect", (Object)request.getInterconnect());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)InterconnectsGetMacsecConfigResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<InsertInterconnectRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Interconnects/Insert").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnects", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("interconnectResource", (Message)request.getInterconnectResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<ListInterconnectsRequest, InterconnectList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Interconnects/List").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnects", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)InterconnectList.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<PatchInterconnectRequest, Operation> patchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Interconnects/Patch").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnects/{interconnect}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "interconnect", (Object)request.getInterconnect());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("interconnectResource", (Message)request.getInterconnectResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<SetLabelsInterconnectRequest, Operation> setLabelsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Interconnects/SetLabels").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnects/{resource}/setLabels", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("globalSetLabelsRequestResource", (Message)request.getGlobalSetLabelsRequestResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private final UnaryCallable<DeleteInterconnectRequest, Operation> deleteCallable;
    private final OperationCallable<DeleteInterconnectRequest, Operation, Operation> deleteOperationCallable;
    private final UnaryCallable<GetInterconnectRequest, Interconnect> getCallable;
    private final UnaryCallable<GetDiagnosticsInterconnectRequest, InterconnectsGetDiagnosticsResponse> getDiagnosticsCallable;
    private final UnaryCallable<GetMacsecConfigInterconnectRequest, InterconnectsGetMacsecConfigResponse> getMacsecConfigCallable;
    private final UnaryCallable<InsertInterconnectRequest, Operation> insertCallable;
    private final OperationCallable<InsertInterconnectRequest, Operation, Operation> insertOperationCallable;
    private final UnaryCallable<ListInterconnectsRequest, InterconnectList> listCallable;
    private final UnaryCallable<ListInterconnectsRequest, InterconnectsClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<PatchInterconnectRequest, Operation> patchCallable;
    private final OperationCallable<PatchInterconnectRequest, Operation, Operation> patchOperationCallable;
    private final UnaryCallable<SetLabelsInterconnectRequest, Operation> setLabelsCallable;
    private final OperationCallable<SetLabelsInterconnectRequest, Operation, Operation> setLabelsOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonGlobalOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonInterconnectsStub create(InterconnectsStubSettings settings) throws IOException {
        return new HttpJsonInterconnectsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonInterconnectsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonInterconnectsStub(InterconnectsStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonInterconnectsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonInterconnectsStub(InterconnectsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonInterconnectsStub(InterconnectsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonInterconnectsCallableFactory());
    }

    protected HttpJsonInterconnectsStub(InterconnectsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonGlobalOperationsStub.create(clientContext, callableFactory);
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("interconnect", String.valueOf(request.getInterconnect()));
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("interconnect", String.valueOf(request.getInterconnect()));
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getDiagnosticsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDiagnosticsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("interconnect", String.valueOf(request.getInterconnect()));
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getMacsecConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMacsecConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("interconnect", String.valueOf(request.getInterconnect()));
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings patchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("interconnect", String.valueOf(request.getInterconnect()));
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings setLabelsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setLabelsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.deleteOperationCallable = callableFactory.createOperationCallable(deleteTransportSettings, settings.deleteOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.getDiagnosticsCallable = callableFactory.createUnaryCallable(getDiagnosticsTransportSettings, settings.getDiagnosticsSettings(), clientContext);
        this.getMacsecConfigCallable = callableFactory.createUnaryCallable(getMacsecConfigTransportSettings, settings.getMacsecConfigSettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.insertOperationCallable = callableFactory.createOperationCallable(insertTransportSettings, settings.insertOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.patchCallable = callableFactory.createUnaryCallable(patchTransportSettings, settings.patchSettings(), clientContext);
        this.patchOperationCallable = callableFactory.createOperationCallable(patchTransportSettings, settings.patchOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.setLabelsCallable = callableFactory.createUnaryCallable(setLabelsTransportSettings, settings.setLabelsSettings(), clientContext);
        this.setLabelsOperationCallable = callableFactory.createOperationCallable(setLabelsTransportSettings, settings.setLabelsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(deleteMethodDescriptor);
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(getDiagnosticsMethodDescriptor);
        methodDescriptors.add(getMacsecConfigMethodDescriptor);
        methodDescriptors.add(insertMethodDescriptor);
        methodDescriptors.add(listMethodDescriptor);
        methodDescriptors.add(patchMethodDescriptor);
        methodDescriptors.add(setLabelsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<DeleteInterconnectRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public OperationCallable<DeleteInterconnectRequest, Operation, Operation> deleteOperationCallable() {
        return this.deleteOperationCallable;
    }

    @Override
    public UnaryCallable<GetInterconnectRequest, Interconnect> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<GetDiagnosticsInterconnectRequest, InterconnectsGetDiagnosticsResponse> getDiagnosticsCallable() {
        return this.getDiagnosticsCallable;
    }

    @Override
    public UnaryCallable<GetMacsecConfigInterconnectRequest, InterconnectsGetMacsecConfigResponse> getMacsecConfigCallable() {
        return this.getMacsecConfigCallable;
    }

    @Override
    public UnaryCallable<InsertInterconnectRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public OperationCallable<InsertInterconnectRequest, Operation, Operation> insertOperationCallable() {
        return this.insertOperationCallable;
    }

    @Override
    public UnaryCallable<ListInterconnectsRequest, InterconnectList> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ListInterconnectsRequest, InterconnectsClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<PatchInterconnectRequest, Operation> patchCallable() {
        return this.patchCallable;
    }

    @Override
    public OperationCallable<PatchInterconnectRequest, Operation, Operation> patchOperationCallable() {
        return this.patchOperationCallable;
    }

    @Override
    public UnaryCallable<SetLabelsInterconnectRequest, Operation> setLabelsCallable() {
        return this.setLabelsCallable;
    }

    @Override
    public OperationCallable<SetLabelsInterconnectRequest, Operation, Operation> setLabelsOperationCallable() {
        return this.setLabelsOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

