/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteLicenseRequest;
import com.google.cloud.compute.v1.GetIamPolicyLicenseRequest;
import com.google.cloud.compute.v1.GetLicenseRequest;
import com.google.cloud.compute.v1.GlobalSetPolicyRequest;
import com.google.cloud.compute.v1.InsertLicenseRequest;
import com.google.cloud.compute.v1.License;
import com.google.cloud.compute.v1.LicensesListResponse;
import com.google.cloud.compute.v1.LicensesSettings;
import com.google.cloud.compute.v1.ListLicensesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyLicenseRequest;
import com.google.cloud.compute.v1.TestIamPermissionsLicenseRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.LicensesStub;
import com.google.cloud.compute.v1.stub.LicensesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class LicensesClient
implements BackgroundResource {
    private final LicensesSettings settings;
    private final LicensesStub stub;

    public static final LicensesClient create() throws IOException {
        return LicensesClient.create(LicensesSettings.newBuilder().build());
    }

    public static final LicensesClient create(LicensesSettings settings) throws IOException {
        return new LicensesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final LicensesClient create(LicensesStub stub) {
        return new LicensesClient(stub);
    }

    protected LicensesClient(LicensesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LicensesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected LicensesClient(LicensesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LicensesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public LicensesStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String license) {
        DeleteLicenseRequest request = DeleteLicenseRequest.newBuilder().setProject(project).setLicense(license).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteLicenseRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteLicenseRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final License get(String project, String license) {
        GetLicenseRequest request = GetLicenseRequest.newBuilder().setProject(project).setLicense(license).build();
        return this.get(request);
    }

    public final License get(GetLicenseRequest request) {
        return (License)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetLicenseRequest, License> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String resource) {
        GetIamPolicyLicenseRequest request = GetIamPolicyLicenseRequest.newBuilder().setProject(project).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyLicenseRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyLicenseRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Operation insert(String project, License licenseResource) {
        InsertLicenseRequest request = InsertLicenseRequest.newBuilder().setProject(project).setLicenseResource(licenseResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertLicenseRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertLicenseRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListLicensesRequest request = ListLicensesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListLicensesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLicensesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListLicensesRequest, LicensesListResponse> listCallable() {
        return this.stub.listCallable();
    }

    public final Policy setIamPolicy(String project, String resource, GlobalSetPolicyRequest globalSetPolicyRequestResource) {
        SetIamPolicyLicenseRequest request = SetIamPolicyLicenseRequest.newBuilder().setProject(project).setResource(resource).setGlobalSetPolicyRequestResource(globalSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyLicenseRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyLicenseRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsLicenseRequest request = TestIamPermissionsLicenseRequest.newBuilder().setProject(project).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsLicenseRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsLicenseRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLicensesRequest, LicensesListResponse, License, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListLicensesRequest, LicensesListResponse, License, ListPage> {
        private ListPage(PageContext<ListLicensesRequest, LicensesListResponse, License> context, LicensesListResponse response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListLicensesRequest, LicensesListResponse, License> context, LicensesListResponse response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListLicensesRequest, LicensesListResponse, License> context, ApiFuture<LicensesListResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListLicensesRequest, LicensesListResponse, License, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListLicensesRequest, LicensesListResponse, License> context, ApiFuture<LicensesListResponse> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

