/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListPacketMirroringsRequest;
import com.google.cloud.compute.v1.DeletePacketMirroringRequest;
import com.google.cloud.compute.v1.GetPacketMirroringRequest;
import com.google.cloud.compute.v1.InsertPacketMirroringRequest;
import com.google.cloud.compute.v1.ListPacketMirroringsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PacketMirroring;
import com.google.cloud.compute.v1.PacketMirroringAggregatedList;
import com.google.cloud.compute.v1.PacketMirroringList;
import com.google.cloud.compute.v1.PacketMirroringsClient;
import com.google.cloud.compute.v1.PacketMirroringsScopedList;
import com.google.cloud.compute.v1.PatchPacketMirroringRequest;
import com.google.cloud.compute.v1.TestIamPermissionsPacketMirroringRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonPacketMirroringsStub;
import com.google.cloud.compute.v1.stub.PacketMirroringsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class PacketMirroringsStubSettings
extends StubSettings<PacketMirroringsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, PacketMirroringsClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeletePacketMirroringRequest, Operation> deleteSettings;
    private final UnaryCallSettings<GetPacketMirroringRequest, PacketMirroring> getSettings;
    private final UnaryCallSettings<InsertPacketMirroringRequest, Operation> insertSettings;
    private final PagedCallSettings<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroringsClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchPacketMirroringRequest, Operation> patchSettings;
    private final UnaryCallSettings<TestIamPermissionsPacketMirroringRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, Map.Entry<String, PacketMirroringsScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, Map.Entry<String, PacketMirroringsScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListPacketMirroringsRequest injectToken(AggregatedListPacketMirroringsRequest payload, String token) {
            return AggregatedListPacketMirroringsRequest.newBuilder((AggregatedListPacketMirroringsRequest)payload).setPageToken(token).build();
        }

        public AggregatedListPacketMirroringsRequest injectPageSize(AggregatedListPacketMirroringsRequest payload, int pageSize) {
            return AggregatedListPacketMirroringsRequest.newBuilder((AggregatedListPacketMirroringsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListPacketMirroringsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(PacketMirroringAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, PacketMirroringsScopedList>> extractResources(PacketMirroringAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroring> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroring>(){

        public String emptyToken() {
            return "";
        }

        public ListPacketMirroringsRequest injectToken(ListPacketMirroringsRequest payload, String token) {
            return ListPacketMirroringsRequest.newBuilder((ListPacketMirroringsRequest)payload).setPageToken(token).build();
        }

        public ListPacketMirroringsRequest injectPageSize(ListPacketMirroringsRequest payload, int pageSize) {
            return ListPacketMirroringsRequest.newBuilder((ListPacketMirroringsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListPacketMirroringsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(PacketMirroringList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PacketMirroring> extractResources(PacketMirroringList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, PacketMirroringsClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, PacketMirroringsClient.AggregatedListPagedResponse>(){

        public ApiFuture<PacketMirroringsClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList> callable, AggregatedListPacketMirroringsRequest request, ApiCallContext context, ApiFuture<PacketMirroringAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PacketMirroringsClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, Map.Entry<String, PacketMirroringsScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroringsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroringsClient.ListPagedResponse>(){

        public ApiFuture<PacketMirroringsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListPacketMirroringsRequest, PacketMirroringList> callable, ListPacketMirroringsRequest request, ApiCallContext context, ApiFuture<PacketMirroringList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PacketMirroringsClient.ListPagedResponse.createAsync((PageContext<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroring>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, PacketMirroringsClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeletePacketMirroringRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<GetPacketMirroringRequest, PacketMirroring> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertPacketMirroringRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroringsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchPacketMirroringRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public UnaryCallSettings<TestIamPermissionsPacketMirroringRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PacketMirroringsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPacketMirroringsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PacketMirroringsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PacketMirroringsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PacketMirroringsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PacketMirroringsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, PacketMirroringsClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeletePacketMirroringRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<GetPacketMirroringRequest, PacketMirroring> getSettings;
        private final UnaryCallSettings.Builder<InsertPacketMirroringRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroringsClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchPacketMirroringRequest, Operation> patchSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsPacketMirroringRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PacketMirroringsStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PacketMirroringsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PacketMirroringsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PacketMirroringsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(PacketMirroringsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(PacketMirroringsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, PacketMirroringsClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeletePacketMirroringRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<GetPacketMirroringRequest, PacketMirroring> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertPacketMirroringRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroringsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchPacketMirroringRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsPacketMirroringRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public PacketMirroringsStubSettings build() throws IOException {
            return new PacketMirroringsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

