/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionHealthCheckRequest;
import com.google.cloud.compute.v1.GetRegionHealthCheckRequest;
import com.google.cloud.compute.v1.HealthCheck;
import com.google.cloud.compute.v1.HealthCheckList;
import com.google.cloud.compute.v1.InsertRegionHealthCheckRequest;
import com.google.cloud.compute.v1.ListRegionHealthChecksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionHealthCheckRequest;
import com.google.cloud.compute.v1.RegionHealthChecksSettings;
import com.google.cloud.compute.v1.UpdateRegionHealthCheckRequest;
import com.google.cloud.compute.v1.stub.RegionHealthChecksStub;
import com.google.cloud.compute.v1.stub.RegionHealthChecksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionHealthChecksClient
implements BackgroundResource {
    private final RegionHealthChecksSettings settings;
    private final RegionHealthChecksStub stub;

    public static final RegionHealthChecksClient create() throws IOException {
        return RegionHealthChecksClient.create(RegionHealthChecksSettings.newBuilder().build());
    }

    public static final RegionHealthChecksClient create(RegionHealthChecksSettings settings) throws IOException {
        return new RegionHealthChecksClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionHealthChecksClient create(RegionHealthChecksStub stub) {
        return new RegionHealthChecksClient(stub);
    }

    protected RegionHealthChecksClient(RegionHealthChecksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionHealthChecksStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionHealthChecksClient(RegionHealthChecksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionHealthChecksSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionHealthChecksStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String region, String healthCheck) {
        DeleteRegionHealthCheckRequest request = DeleteRegionHealthCheckRequest.newBuilder().setProject(project).setRegion(region).setHealthCheck(healthCheck).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteRegionHealthCheckRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRegionHealthCheckRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final HealthCheck get(String project, String region, String healthCheck) {
        GetRegionHealthCheckRequest request = GetRegionHealthCheckRequest.newBuilder().setProject(project).setRegion(region).setHealthCheck(healthCheck).build();
        return this.get(request);
    }

    public final HealthCheck get(GetRegionHealthCheckRequest request) {
        return (HealthCheck)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionHealthCheckRequest, HealthCheck> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String region, HealthCheck healthCheckResource) {
        InsertRegionHealthCheckRequest request = InsertRegionHealthCheckRequest.newBuilder().setProject(project).setRegion(region).setHealthCheckResource(healthCheckResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertRegionHealthCheckRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertRegionHealthCheckRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionHealthChecksRequest request = ListRegionHealthChecksRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionHealthChecksRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionHealthChecksRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionHealthChecksRequest, HealthCheckList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String region, String healthCheck, HealthCheck healthCheckResource) {
        PatchRegionHealthCheckRequest request = PatchRegionHealthCheckRequest.newBuilder().setProject(project).setRegion(region).setHealthCheck(healthCheck).setHealthCheckResource(healthCheckResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchRegionHealthCheckRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchRegionHealthCheckRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation update(String project, String region, String healthCheck, HealthCheck healthCheckResource) {
        UpdateRegionHealthCheckRequest request = UpdateRegionHealthCheckRequest.newBuilder().setProject(project).setRegion(region).setHealthCheck(healthCheck).setHealthCheckResource(healthCheckResource).build();
        return this.update(request);
    }

    public final Operation update(UpdateRegionHealthCheckRequest request) {
        return (Operation)this.updateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRegionHealthCheckRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck, ListPage> {
        private ListPage(PageContext<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck> context, HealthCheckList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck> context, HealthCheckList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck> context, ApiFuture<HealthCheckList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck> context, ApiFuture<HealthCheckList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

