/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetImageFamilyViewRequest;
import com.google.cloud.compute.v1.ImageFamilyView;
import com.google.cloud.compute.v1.ImageFamilyViewsSettings;
import com.google.cloud.compute.v1.stub.ImageFamilyViewsStub;
import com.google.cloud.compute.v1.stub.ImageFamilyViewsStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ImageFamilyViewsClient
implements BackgroundResource {
    private final ImageFamilyViewsSettings settings;
    private final ImageFamilyViewsStub stub;

    public static final ImageFamilyViewsClient create() throws IOException {
        return ImageFamilyViewsClient.create(ImageFamilyViewsSettings.newBuilder().build());
    }

    public static final ImageFamilyViewsClient create(ImageFamilyViewsSettings settings) throws IOException {
        return new ImageFamilyViewsClient(settings);
    }

    public static final ImageFamilyViewsClient create(ImageFamilyViewsStub stub) {
        return new ImageFamilyViewsClient(stub);
    }

    protected ImageFamilyViewsClient(ImageFamilyViewsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ImageFamilyViewsStubSettings)settings.getStubSettings()).createStub();
    }

    protected ImageFamilyViewsClient(ImageFamilyViewsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ImageFamilyViewsSettings getSettings() {
        return this.settings;
    }

    public ImageFamilyViewsStub getStub() {
        return this.stub;
    }

    public final ImageFamilyView get(String project, String zone, String family) {
        GetImageFamilyViewRequest request = GetImageFamilyViewRequest.newBuilder().setProject(project).setZone(zone).setFamily(family).build();
        return this.get(request);
    }

    public final ImageFamilyView get(GetImageFamilyViewRequest request) {
        return (ImageFamilyView)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetImageFamilyViewRequest, ImageFamilyView> getCallable() {
        return this.stub.getCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

