/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNetworkEndpointGroupsRequest;
import com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.DeleteNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.DetachNetworkEndpointsNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.GetNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.InsertNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.ListNetworkEndpointGroupsRequest;
import com.google.cloud.compute.v1.ListNetworkEndpointsNetworkEndpointGroupsRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroup;
import com.google.cloud.compute.v1.NetworkEndpointGroupAggregatedList;
import com.google.cloud.compute.v1.NetworkEndpointGroupList;
import com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroupsDetachEndpointsRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroupsListEndpointsRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroupsListNetworkEndpoints;
import com.google.cloud.compute.v1.NetworkEndpointGroupsScopedList;
import com.google.cloud.compute.v1.NetworkEndpointGroupsSettings;
import com.google.cloud.compute.v1.NetworkEndpointWithHealthStatus;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.TestIamPermissionsNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.NetworkEndpointGroupsStub;
import com.google.cloud.compute.v1.stub.NetworkEndpointGroupsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class NetworkEndpointGroupsClient
implements BackgroundResource {
    private final NetworkEndpointGroupsSettings settings;
    private final NetworkEndpointGroupsStub stub;

    public static final NetworkEndpointGroupsClient create() throws IOException {
        return NetworkEndpointGroupsClient.create(NetworkEndpointGroupsSettings.newBuilder().build());
    }

    public static final NetworkEndpointGroupsClient create(NetworkEndpointGroupsSettings settings) throws IOException {
        return new NetworkEndpointGroupsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final NetworkEndpointGroupsClient create(NetworkEndpointGroupsStub stub) {
        return new NetworkEndpointGroupsClient(stub);
    }

    protected NetworkEndpointGroupsClient(NetworkEndpointGroupsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NetworkEndpointGroupsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected NetworkEndpointGroupsClient(NetworkEndpointGroupsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NetworkEndpointGroupsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NetworkEndpointGroupsStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListNetworkEndpointGroupsRequest request = AggregatedListNetworkEndpointGroupsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListNetworkEndpointGroupsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListNetworkEndpointGroupsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation attachNetworkEndpoints(String project, String zone, String networkEndpointGroup, NetworkEndpointGroupsAttachEndpointsRequest networkEndpointGroupsAttachEndpointsRequestResource) {
        AttachNetworkEndpointsNetworkEndpointGroupRequest request = AttachNetworkEndpointsNetworkEndpointGroupRequest.newBuilder().setProject(project).setZone(zone).setNetworkEndpointGroup(networkEndpointGroup).setNetworkEndpointGroupsAttachEndpointsRequestResource(networkEndpointGroupsAttachEndpointsRequestResource).build();
        return this.attachNetworkEndpoints(request);
    }

    public final Operation attachNetworkEndpoints(AttachNetworkEndpointsNetworkEndpointGroupRequest request) {
        return (Operation)this.attachNetworkEndpointsCallable().call((Object)request);
    }

    public final UnaryCallable<AttachNetworkEndpointsNetworkEndpointGroupRequest, Operation> attachNetworkEndpointsCallable() {
        return this.stub.attachNetworkEndpointsCallable();
    }

    public final Operation delete(String project, String zone, String networkEndpointGroup) {
        DeleteNetworkEndpointGroupRequest request = DeleteNetworkEndpointGroupRequest.newBuilder().setProject(project).setZone(zone).setNetworkEndpointGroup(networkEndpointGroup).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteNetworkEndpointGroupRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteNetworkEndpointGroupRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Operation detachNetworkEndpoints(String project, String zone, String networkEndpointGroup, NetworkEndpointGroupsDetachEndpointsRequest networkEndpointGroupsDetachEndpointsRequestResource) {
        DetachNetworkEndpointsNetworkEndpointGroupRequest request = DetachNetworkEndpointsNetworkEndpointGroupRequest.newBuilder().setProject(project).setZone(zone).setNetworkEndpointGroup(networkEndpointGroup).setNetworkEndpointGroupsDetachEndpointsRequestResource(networkEndpointGroupsDetachEndpointsRequestResource).build();
        return this.detachNetworkEndpoints(request);
    }

    public final Operation detachNetworkEndpoints(DetachNetworkEndpointsNetworkEndpointGroupRequest request) {
        return (Operation)this.detachNetworkEndpointsCallable().call((Object)request);
    }

    public final UnaryCallable<DetachNetworkEndpointsNetworkEndpointGroupRequest, Operation> detachNetworkEndpointsCallable() {
        return this.stub.detachNetworkEndpointsCallable();
    }

    public final NetworkEndpointGroup get(String project, String zone, String networkEndpointGroup) {
        GetNetworkEndpointGroupRequest request = GetNetworkEndpointGroupRequest.newBuilder().setProject(project).setZone(zone).setNetworkEndpointGroup(networkEndpointGroup).build();
        return this.get(request);
    }

    public final NetworkEndpointGroup get(GetNetworkEndpointGroupRequest request) {
        return (NetworkEndpointGroup)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkEndpointGroupRequest, NetworkEndpointGroup> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String zone, NetworkEndpointGroup networkEndpointGroupResource) {
        InsertNetworkEndpointGroupRequest request = InsertNetworkEndpointGroupRequest.newBuilder().setProject(project).setZone(zone).setNetworkEndpointGroupResource(networkEndpointGroupResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertNetworkEndpointGroupRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertNetworkEndpointGroupRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListNetworkEndpointGroupsRequest request = ListNetworkEndpointGroupsRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListNetworkEndpointGroupsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworkEndpointGroupsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListNetworkEndpointsPagedResponse listNetworkEndpoints(String project, String zone, String networkEndpointGroup, NetworkEndpointGroupsListEndpointsRequest networkEndpointGroupsListEndpointsRequestResource) {
        ListNetworkEndpointsNetworkEndpointGroupsRequest request = ListNetworkEndpointsNetworkEndpointGroupsRequest.newBuilder().setProject(project).setZone(zone).setNetworkEndpointGroup(networkEndpointGroup).setNetworkEndpointGroupsListEndpointsRequestResource(networkEndpointGroupsListEndpointsRequestResource).build();
        return this.listNetworkEndpoints(request);
    }

    public final ListNetworkEndpointsPagedResponse listNetworkEndpoints(ListNetworkEndpointsNetworkEndpointGroupsRequest request) {
        return (ListNetworkEndpointsPagedResponse)((Object)this.listNetworkEndpointsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworkEndpointsNetworkEndpointGroupsRequest, ListNetworkEndpointsPagedResponse> listNetworkEndpointsPagedCallable() {
        return this.stub.listNetworkEndpointsPagedCallable();
    }

    public final UnaryCallable<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints> listNetworkEndpointsCallable() {
        return this.stub.listNetworkEndpointsCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String zone, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsNetworkEndpointGroupRequest request = TestIamPermissionsNetworkEndpointGroupRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsNetworkEndpointGroupRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsNetworkEndpointGroupRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListNetworkEndpointsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus, ListNetworkEndpointsPage, ListNetworkEndpointsFixedSizeCollection> {
        private ListNetworkEndpointsFixedSizeCollection(List<ListNetworkEndpointsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNetworkEndpointsFixedSizeCollection createEmptyCollection() {
            return new ListNetworkEndpointsFixedSizeCollection(null, 0);
        }

        protected ListNetworkEndpointsFixedSizeCollection createCollection(List<ListNetworkEndpointsPage> pages, int collectionSize) {
            return new ListNetworkEndpointsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNetworkEndpointsPage
    extends AbstractPage<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus, ListNetworkEndpointsPage> {
        private ListNetworkEndpointsPage(PageContext<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> context, NetworkEndpointGroupsListNetworkEndpoints response) {
            super(context, (Object)response);
        }

        private static ListNetworkEndpointsPage createEmptyPage() {
            return new ListNetworkEndpointsPage(null, null);
        }

        protected ListNetworkEndpointsPage createPage(PageContext<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> context, NetworkEndpointGroupsListNetworkEndpoints response) {
            return new ListNetworkEndpointsPage(context, response);
        }

        public ApiFuture<ListNetworkEndpointsPage> createPageAsync(PageContext<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> context, ApiFuture<NetworkEndpointGroupsListNetworkEndpoints> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNetworkEndpointsPagedResponse
    extends AbstractPagedListResponse<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus, ListNetworkEndpointsPage, ListNetworkEndpointsFixedSizeCollection> {
        public static ApiFuture<ListNetworkEndpointsPagedResponse> createAsync(PageContext<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> context, ApiFuture<NetworkEndpointGroupsListNetworkEndpoints> futureResponse) {
            ApiFuture<ListNetworkEndpointsPage> futurePage = ListNetworkEndpointsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListNetworkEndpointsPage, ListNetworkEndpointsPagedResponse>(){

                public ListNetworkEndpointsPagedResponse apply(ListNetworkEndpointsPage input) {
                    return new ListNetworkEndpointsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListNetworkEndpointsPagedResponse(ListNetworkEndpointsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNetworkEndpointsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListPage> {
        private ListPage(PageContext<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, NetworkEndpointGroupList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, NetworkEndpointGroupList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, Map.Entry<String, NetworkEndpointGroupsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, Map.Entry<String, NetworkEndpointGroupsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, Map.Entry<String, NetworkEndpointGroupsScopedList>> context, NetworkEndpointGroupAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, Map.Entry<String, NetworkEndpointGroupsScopedList>> context, NetworkEndpointGroupAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, Map.Entry<String, NetworkEndpointGroupsScopedList>> context, ApiFuture<NetworkEndpointGroupAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, Map.Entry<String, NetworkEndpointGroupsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, Map.Entry<String, NetworkEndpointGroupsScopedList>> context, ApiFuture<NetworkEndpointGroupAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListPage, AggregatedListPagedResponse>(){

                public AggregatedListPagedResponse apply(AggregatedListPage input) {
                    return new AggregatedListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

