/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetLicenseCodeRequest;
import com.google.cloud.compute.v1.LicenseCode;
import com.google.cloud.compute.v1.LicenseCodesSettings;
import com.google.cloud.compute.v1.TestIamPermissionsLicenseCodeRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.LicenseCodesStub;
import com.google.cloud.compute.v1.stub.LicenseCodesStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class LicenseCodesClient
implements BackgroundResource {
    private final LicenseCodesSettings settings;
    private final LicenseCodesStub stub;

    public static final LicenseCodesClient create() throws IOException {
        return LicenseCodesClient.create(LicenseCodesSettings.newBuilder().build());
    }

    public static final LicenseCodesClient create(LicenseCodesSettings settings) throws IOException {
        return new LicenseCodesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final LicenseCodesClient create(LicenseCodesStub stub) {
        return new LicenseCodesClient(stub);
    }

    protected LicenseCodesClient(LicenseCodesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LicenseCodesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected LicenseCodesClient(LicenseCodesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LicenseCodesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public LicenseCodesStub getStub() {
        return this.stub;
    }

    public final LicenseCode get(String project, String licenseCode) {
        GetLicenseCodeRequest request = GetLicenseCodeRequest.newBuilder().setProject(project).setLicenseCode(licenseCode).build();
        return this.get(request);
    }

    public final LicenseCode get(GetLicenseCodeRequest request) {
        return (LicenseCode)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetLicenseCodeRequest, LicenseCode> getCallable() {
        return this.stub.getCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsLicenseCodeRequest request = TestIamPermissionsLicenseCodeRequest.newBuilder().setProject(project).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsLicenseCodeRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsLicenseCodeRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

