/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListGlobalOperationsRequest;
import com.google.cloud.compute.v1.DeleteGlobalOperationRequest;
import com.google.cloud.compute.v1.DeleteGlobalOperationResponse;
import com.google.cloud.compute.v1.GetGlobalOperationRequest;
import com.google.cloud.compute.v1.GlobalOperationsSettings;
import com.google.cloud.compute.v1.ListGlobalOperationsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationAggregatedList;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.OperationsScopedList;
import com.google.cloud.compute.v1.WaitGlobalOperationRequest;
import com.google.cloud.compute.v1.stub.GlobalOperationsStub;
import com.google.cloud.compute.v1.stub.GlobalOperationsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GlobalOperationsClient
implements BackgroundResource {
    private final GlobalOperationsSettings settings;
    private final GlobalOperationsStub stub;

    public static final GlobalOperationsClient create() throws IOException {
        return GlobalOperationsClient.create(GlobalOperationsSettings.newBuilder().build());
    }

    public static final GlobalOperationsClient create(GlobalOperationsSettings settings) throws IOException {
        return new GlobalOperationsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GlobalOperationsClient create(GlobalOperationsStub stub) {
        return new GlobalOperationsClient(stub);
    }

    protected GlobalOperationsClient(GlobalOperationsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GlobalOperationsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GlobalOperationsClient(GlobalOperationsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GlobalOperationsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalOperationsStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListGlobalOperationsRequest request = AggregatedListGlobalOperationsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListGlobalOperationsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListGlobalOperationsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListGlobalOperationsRequest, OperationAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final DeleteGlobalOperationResponse delete(String project, String operation) {
        DeleteGlobalOperationRequest request = DeleteGlobalOperationRequest.newBuilder().setProject(project).setOperation(operation).build();
        return this.delete(request);
    }

    public final DeleteGlobalOperationResponse delete(DeleteGlobalOperationRequest request) {
        return (DeleteGlobalOperationResponse)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteGlobalOperationRequest, DeleteGlobalOperationResponse> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Operation get(String project, String operation) {
        GetGlobalOperationRequest request = GetGlobalOperationRequest.newBuilder().setProject(project).setOperation(operation).build();
        return this.get(request);
    }

    public final Operation get(GetGlobalOperationRequest request) {
        return (Operation)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetGlobalOperationRequest, Operation> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project) {
        ListGlobalOperationsRequest request = ListGlobalOperationsRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListGlobalOperationsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGlobalOperationsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListGlobalOperationsRequest, OperationList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation wait(String project, String operation) {
        WaitGlobalOperationRequest request = WaitGlobalOperationRequest.newBuilder().setProject(project).setOperation(operation).build();
        return this.wait(request);
    }

    public final Operation wait(WaitGlobalOperationRequest request) {
        return (Operation)this.waitCallable().call((Object)request);
    }

    public final UnaryCallable<WaitGlobalOperationRequest, Operation> waitCallable() {
        return this.stub.waitCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlobalOperationsRequest, OperationList, Operation, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListGlobalOperationsRequest, OperationList, Operation, ListPage> {
        private ListPage(PageContext<ListGlobalOperationsRequest, OperationList, Operation> context, OperationList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListGlobalOperationsRequest, OperationList, Operation> context, OperationList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListGlobalOperationsRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListGlobalOperationsRequest, OperationList, Operation, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListGlobalOperationsRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListGlobalOperationsRequest, OperationAggregatedList, Map.Entry<String, OperationsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListGlobalOperationsRequest, OperationAggregatedList, Map.Entry<String, OperationsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListGlobalOperationsRequest, OperationAggregatedList, Map.Entry<String, OperationsScopedList>> context, OperationAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListGlobalOperationsRequest, OperationAggregatedList, Map.Entry<String, OperationsScopedList>> context, OperationAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListGlobalOperationsRequest, OperationAggregatedList, Map.Entry<String, OperationsScopedList>> context, ApiFuture<OperationAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListGlobalOperationsRequest, OperationAggregatedList, Map.Entry<String, OperationsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListGlobalOperationsRequest, OperationAggregatedList, Map.Entry<String, OperationsScopedList>> context, ApiFuture<OperationAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListPage, AggregatedListPagedResponse>(){

                public AggregatedListPagedResponse apply(AggregatedListPage input) {
                    return new AggregatedListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

