/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.CustomerEncryptionKey;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AttachedDiskInitializeParams
implements ApiMessage {
    private final String description;
    private final String diskName;
    private final String diskSizeGb;
    private final String diskType;
    private final Map<String, String> labels;
    private final String sourceImage;
    private final CustomerEncryptionKey sourceImageEncryptionKey;
    private final String sourceSnapshot;
    private final CustomerEncryptionKey sourceSnapshotEncryptionKey;
    private static final AttachedDiskInitializeParams DEFAULT_INSTANCE = new AttachedDiskInitializeParams();

    private AttachedDiskInitializeParams() {
        this.description = null;
        this.diskName = null;
        this.diskSizeGb = null;
        this.diskType = null;
        this.labels = null;
        this.sourceImage = null;
        this.sourceImageEncryptionKey = null;
        this.sourceSnapshot = null;
        this.sourceSnapshotEncryptionKey = null;
    }

    private AttachedDiskInitializeParams(String description, String diskName, String diskSizeGb, String diskType, Map<String, String> labels, String sourceImage, CustomerEncryptionKey sourceImageEncryptionKey, String sourceSnapshot, CustomerEncryptionKey sourceSnapshotEncryptionKey) {
        this.description = description;
        this.diskName = diskName;
        this.diskSizeGb = diskSizeGb;
        this.diskType = diskType;
        this.labels = labels;
        this.sourceImage = sourceImage;
        this.sourceImageEncryptionKey = sourceImageEncryptionKey;
        this.sourceSnapshot = sourceSnapshot;
        this.sourceSnapshotEncryptionKey = sourceSnapshotEncryptionKey;
    }

    public Object getFieldValue(String fieldName) {
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("diskName".equals(fieldName)) {
            return this.diskName;
        }
        if ("diskSizeGb".equals(fieldName)) {
            return this.diskSizeGb;
        }
        if ("diskType".equals(fieldName)) {
            return this.diskType;
        }
        if ("labels".equals(fieldName)) {
            return this.labels;
        }
        if ("sourceImage".equals(fieldName)) {
            return this.sourceImage;
        }
        if ("sourceImageEncryptionKey".equals(fieldName)) {
            return this.sourceImageEncryptionKey;
        }
        if ("sourceSnapshot".equals(fieldName)) {
            return this.sourceSnapshot;
        }
        if ("sourceSnapshotEncryptionKey".equals(fieldName)) {
            return this.sourceSnapshotEncryptionKey;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDiskName() {
        return this.diskName;
    }

    public String getDiskSizeGb() {
        return this.diskSizeGb;
    }

    public String getDiskType() {
        return this.diskType;
    }

    public Map<String, String> getLabelsMap() {
        return this.labels;
    }

    public String getSourceImage() {
        return this.sourceImage;
    }

    public CustomerEncryptionKey getSourceImageEncryptionKey() {
        return this.sourceImageEncryptionKey;
    }

    public String getSourceSnapshot() {
        return this.sourceSnapshot;
    }

    public CustomerEncryptionKey getSourceSnapshotEncryptionKey() {
        return this.sourceSnapshotEncryptionKey;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AttachedDiskInitializeParams prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AttachedDiskInitializeParams getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AttachedDiskInitializeParams{description=" + this.description + ", diskName=" + this.diskName + ", diskSizeGb=" + this.diskSizeGb + ", diskType=" + this.diskType + ", labels=" + this.labels + ", sourceImage=" + this.sourceImage + ", sourceImageEncryptionKey=" + this.sourceImageEncryptionKey + ", sourceSnapshot=" + this.sourceSnapshot + ", sourceSnapshotEncryptionKey=" + this.sourceSnapshotEncryptionKey + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AttachedDiskInitializeParams) {
            AttachedDiskInitializeParams that = (AttachedDiskInitializeParams)o;
            return Objects.equals(this.description, that.getDescription()) && Objects.equals(this.diskName, that.getDiskName()) && Objects.equals(this.diskSizeGb, that.getDiskSizeGb()) && Objects.equals(this.diskType, that.getDiskType()) && Objects.equals(this.labels, that.getLabelsMap()) && Objects.equals(this.sourceImage, that.getSourceImage()) && Objects.equals(this.sourceImageEncryptionKey, that.getSourceImageEncryptionKey()) && Objects.equals(this.sourceSnapshot, that.getSourceSnapshot()) && Objects.equals(this.sourceSnapshotEncryptionKey, that.getSourceSnapshotEncryptionKey());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.description, this.diskName, this.diskSizeGb, this.diskType, this.labels, this.sourceImage, this.sourceImageEncryptionKey, this.sourceSnapshot, this.sourceSnapshotEncryptionKey);
    }

    public static class Builder {
        private String description;
        private String diskName;
        private String diskSizeGb;
        private String diskType;
        private Map<String, String> labels;
        private String sourceImage;
        private CustomerEncryptionKey sourceImageEncryptionKey;
        private String sourceSnapshot;
        private CustomerEncryptionKey sourceSnapshotEncryptionKey;

        Builder() {
        }

        public Builder mergeFrom(AttachedDiskInitializeParams other) {
            if (other == AttachedDiskInitializeParams.getDefaultInstance()) {
                return this;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getDiskName() != null) {
                this.diskName = other.diskName;
            }
            if (other.getDiskSizeGb() != null) {
                this.diskSizeGb = other.diskSizeGb;
            }
            if (other.getDiskType() != null) {
                this.diskType = other.diskType;
            }
            if (other.getLabelsMap() != null) {
                this.labels = other.labels;
            }
            if (other.getSourceImage() != null) {
                this.sourceImage = other.sourceImage;
            }
            if (other.getSourceImageEncryptionKey() != null) {
                this.sourceImageEncryptionKey = other.sourceImageEncryptionKey;
            }
            if (other.getSourceSnapshot() != null) {
                this.sourceSnapshot = other.sourceSnapshot;
            }
            if (other.getSourceSnapshotEncryptionKey() != null) {
                this.sourceSnapshotEncryptionKey = other.sourceSnapshotEncryptionKey;
            }
            return this;
        }

        Builder(AttachedDiskInitializeParams source) {
            this.description = source.description;
            this.diskName = source.diskName;
            this.diskSizeGb = source.diskSizeGb;
            this.diskType = source.diskType;
            this.labels = source.labels;
            this.sourceImage = source.sourceImage;
            this.sourceImageEncryptionKey = source.sourceImageEncryptionKey;
            this.sourceSnapshot = source.sourceSnapshot;
            this.sourceSnapshotEncryptionKey = source.sourceSnapshotEncryptionKey;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getDiskName() {
            return this.diskName;
        }

        public Builder setDiskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public String getDiskSizeGb() {
            return this.diskSizeGb;
        }

        public Builder setDiskSizeGb(String diskSizeGb) {
            this.diskSizeGb = diskSizeGb;
            return this;
        }

        public String getDiskType() {
            return this.diskType;
        }

        public Builder setDiskType(String diskType) {
            this.diskType = diskType;
            return this;
        }

        public Map<String, String> getLabelsMap() {
            return this.labels;
        }

        public Builder putAllLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public String getSourceImage() {
            return this.sourceImage;
        }

        public Builder setSourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public CustomerEncryptionKey getSourceImageEncryptionKey() {
            return this.sourceImageEncryptionKey;
        }

        public Builder setSourceImageEncryptionKey(CustomerEncryptionKey sourceImageEncryptionKey) {
            this.sourceImageEncryptionKey = sourceImageEncryptionKey;
            return this;
        }

        public String getSourceSnapshot() {
            return this.sourceSnapshot;
        }

        public Builder setSourceSnapshot(String sourceSnapshot) {
            this.sourceSnapshot = sourceSnapshot;
            return this;
        }

        public CustomerEncryptionKey getSourceSnapshotEncryptionKey() {
            return this.sourceSnapshotEncryptionKey;
        }

        public Builder setSourceSnapshotEncryptionKey(CustomerEncryptionKey sourceSnapshotEncryptionKey) {
            this.sourceSnapshotEncryptionKey = sourceSnapshotEncryptionKey;
            return this;
        }

        public AttachedDiskInitializeParams build() {
            return new AttachedDiskInitializeParams(this.description, this.diskName, this.diskSizeGb, this.diskType, this.labels, this.sourceImage, this.sourceImageEncryptionKey, this.sourceSnapshot, this.sourceSnapshotEncryptionKey);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setDescription(this.description);
            newBuilder.setDiskName(this.diskName);
            newBuilder.setDiskSizeGb(this.diskSizeGb);
            newBuilder.setDiskType(this.diskType);
            newBuilder.putAllLabels(this.labels);
            newBuilder.setSourceImage(this.sourceImage);
            newBuilder.setSourceImageEncryptionKey(this.sourceImageEncryptionKey);
            newBuilder.setSourceSnapshot(this.sourceSnapshot);
            newBuilder.setSourceSnapshotEncryptionKey(this.sourceSnapshotEncryptionKey);
            return newBuilder;
        }
    }
}

