/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddRuleSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.DeleteSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.GetRuleSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.GetSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.InsertSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.ListSecurityPoliciesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRuleSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.PatchSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.RemoveRuleSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.SecurityPolicy;
import com.google.cloud.compute.v1.SecurityPolicyClient;
import com.google.cloud.compute.v1.SecurityPolicyList;
import com.google.cloud.compute.v1.SecurityPolicyRule;
import com.google.cloud.compute.v1.stub.HttpJsonSecurityPolicyStub;
import com.google.cloud.compute.v1.stub.SecurityPolicyStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SecurityPolicyStubSettings
extends StubSettings<SecurityPolicyStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<AddRuleSecurityPolicyHttpRequest, Operation> addRuleSecurityPolicySettings;
    private final UnaryCallSettings<DeleteSecurityPolicyHttpRequest, Operation> deleteSecurityPolicySettings;
    private final UnaryCallSettings<GetSecurityPolicyHttpRequest, SecurityPolicy> getSecurityPolicySettings;
    private final UnaryCallSettings<GetRuleSecurityPolicyHttpRequest, SecurityPolicyRule> getRuleSecurityPolicySettings;
    private final UnaryCallSettings<InsertSecurityPolicyHttpRequest, Operation> insertSecurityPolicySettings;
    private final PagedCallSettings<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicyClient.ListSecurityPoliciesPagedResponse> listSecurityPoliciesSettings;
    private final UnaryCallSettings<PatchSecurityPolicyHttpRequest, Operation> patchSecurityPolicySettings;
    private final UnaryCallSettings<PatchRuleSecurityPolicyHttpRequest, Operation> patchRuleSecurityPolicySettings;
    private final UnaryCallSettings<RemoveRuleSecurityPolicyHttpRequest, Operation> removeRuleSecurityPolicySettings;
    private static final PagedListDescriptor<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicy> LIST_SECURITY_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListSecurityPoliciesHttpRequest injectToken(ListSecurityPoliciesHttpRequest payload, String token) {
            return ListSecurityPoliciesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListSecurityPoliciesHttpRequest injectPageSize(ListSecurityPoliciesHttpRequest payload, int pageSize) {
            return ListSecurityPoliciesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListSecurityPoliciesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SecurityPolicyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SecurityPolicy> extractResources(SecurityPolicyList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicyClient.ListSecurityPoliciesPagedResponse> LIST_SECURITY_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicyClient.ListSecurityPoliciesPagedResponse>(){

        public ApiFuture<SecurityPolicyClient.ListSecurityPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSecurityPoliciesHttpRequest, SecurityPolicyList> callable, ListSecurityPoliciesHttpRequest request, ApiCallContext context, ApiFuture<SecurityPolicyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SECURITY_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityPolicyClient.ListSecurityPoliciesPagedResponse.createAsync((PageContext<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddRuleSecurityPolicyHttpRequest, Operation> addRuleSecurityPolicySettings() {
        return this.addRuleSecurityPolicySettings;
    }

    public UnaryCallSettings<DeleteSecurityPolicyHttpRequest, Operation> deleteSecurityPolicySettings() {
        return this.deleteSecurityPolicySettings;
    }

    public UnaryCallSettings<GetSecurityPolicyHttpRequest, SecurityPolicy> getSecurityPolicySettings() {
        return this.getSecurityPolicySettings;
    }

    public UnaryCallSettings<GetRuleSecurityPolicyHttpRequest, SecurityPolicyRule> getRuleSecurityPolicySettings() {
        return this.getRuleSecurityPolicySettings;
    }

    public UnaryCallSettings<InsertSecurityPolicyHttpRequest, Operation> insertSecurityPolicySettings() {
        return this.insertSecurityPolicySettings;
    }

    public PagedCallSettings<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicyClient.ListSecurityPoliciesPagedResponse> listSecurityPoliciesSettings() {
        return this.listSecurityPoliciesSettings;
    }

    public UnaryCallSettings<PatchSecurityPolicyHttpRequest, Operation> patchSecurityPolicySettings() {
        return this.patchSecurityPolicySettings;
    }

    public UnaryCallSettings<PatchRuleSecurityPolicyHttpRequest, Operation> patchRuleSecurityPolicySettings() {
        return this.patchRuleSecurityPolicySettings;
    }

    public UnaryCallSettings<RemoveRuleSecurityPolicyHttpRequest, Operation> removeRuleSecurityPolicySettings() {
        return this.removeRuleSecurityPolicySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SecurityPolicyStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSecurityPolicyStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SecurityPolicyStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SecurityPolicyStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SecurityPolicyStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addRuleSecurityPolicySettings = settingsBuilder.addRuleSecurityPolicySettings().build();
        this.deleteSecurityPolicySettings = settingsBuilder.deleteSecurityPolicySettings().build();
        this.getSecurityPolicySettings = settingsBuilder.getSecurityPolicySettings().build();
        this.getRuleSecurityPolicySettings = settingsBuilder.getRuleSecurityPolicySettings().build();
        this.insertSecurityPolicySettings = settingsBuilder.insertSecurityPolicySettings().build();
        this.listSecurityPoliciesSettings = settingsBuilder.listSecurityPoliciesSettings().build();
        this.patchSecurityPolicySettings = settingsBuilder.patchSecurityPolicySettings().build();
        this.patchRuleSecurityPolicySettings = settingsBuilder.patchRuleSecurityPolicySettings().build();
        this.removeRuleSecurityPolicySettings = settingsBuilder.removeRuleSecurityPolicySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SecurityPolicyStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddRuleSecurityPolicyHttpRequest, Operation> addRuleSecurityPolicySettings;
        private final UnaryCallSettings.Builder<DeleteSecurityPolicyHttpRequest, Operation> deleteSecurityPolicySettings;
        private final UnaryCallSettings.Builder<GetSecurityPolicyHttpRequest, SecurityPolicy> getSecurityPolicySettings;
        private final UnaryCallSettings.Builder<GetRuleSecurityPolicyHttpRequest, SecurityPolicyRule> getRuleSecurityPolicySettings;
        private final UnaryCallSettings.Builder<InsertSecurityPolicyHttpRequest, Operation> insertSecurityPolicySettings;
        private final PagedCallSettings.Builder<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicyClient.ListSecurityPoliciesPagedResponse> listSecurityPoliciesSettings;
        private final UnaryCallSettings.Builder<PatchSecurityPolicyHttpRequest, Operation> patchSecurityPolicySettings;
        private final UnaryCallSettings.Builder<PatchRuleSecurityPolicyHttpRequest, Operation> patchRuleSecurityPolicySettings;
        private final UnaryCallSettings.Builder<RemoveRuleSecurityPolicyHttpRequest, Operation> removeRuleSecurityPolicySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addRuleSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRuleSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSecurityPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SECURITY_POLICIES_PAGE_STR_FACT);
            this.patchSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchRuleSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeRuleSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addRuleSecurityPolicySettings, this.deleteSecurityPolicySettings, this.getSecurityPolicySettings, this.getRuleSecurityPolicySettings, this.insertSecurityPolicySettings, this.listSecurityPoliciesSettings, this.patchSecurityPolicySettings, this.patchRuleSecurityPolicySettings, this.removeRuleSecurityPolicySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SecurityPolicyStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SecurityPolicyStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SecurityPolicyStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SecurityPolicyStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addRuleSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRuleSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSecurityPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchRuleSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.removeRuleSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(SecurityPolicyStubSettings settings) {
            super((StubSettings)settings);
            this.addRuleSecurityPolicySettings = settings.addRuleSecurityPolicySettings.toBuilder();
            this.deleteSecurityPolicySettings = settings.deleteSecurityPolicySettings.toBuilder();
            this.getSecurityPolicySettings = settings.getSecurityPolicySettings.toBuilder();
            this.getRuleSecurityPolicySettings = settings.getRuleSecurityPolicySettings.toBuilder();
            this.insertSecurityPolicySettings = settings.insertSecurityPolicySettings.toBuilder();
            this.listSecurityPoliciesSettings = settings.listSecurityPoliciesSettings.toBuilder();
            this.patchSecurityPolicySettings = settings.patchSecurityPolicySettings.toBuilder();
            this.patchRuleSecurityPolicySettings = settings.patchRuleSecurityPolicySettings.toBuilder();
            this.removeRuleSecurityPolicySettings = settings.removeRuleSecurityPolicySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addRuleSecurityPolicySettings, this.deleteSecurityPolicySettings, this.getSecurityPolicySettings, this.getRuleSecurityPolicySettings, this.insertSecurityPolicySettings, this.listSecurityPoliciesSettings, this.patchSecurityPolicySettings, this.patchRuleSecurityPolicySettings, this.removeRuleSecurityPolicySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddRuleSecurityPolicyHttpRequest, Operation> addRuleSecurityPolicySettings() {
            return this.addRuleSecurityPolicySettings;
        }

        public UnaryCallSettings.Builder<DeleteSecurityPolicyHttpRequest, Operation> deleteSecurityPolicySettings() {
            return this.deleteSecurityPolicySettings;
        }

        public UnaryCallSettings.Builder<GetSecurityPolicyHttpRequest, SecurityPolicy> getSecurityPolicySettings() {
            return this.getSecurityPolicySettings;
        }

        public UnaryCallSettings.Builder<GetRuleSecurityPolicyHttpRequest, SecurityPolicyRule> getRuleSecurityPolicySettings() {
            return this.getRuleSecurityPolicySettings;
        }

        public UnaryCallSettings.Builder<InsertSecurityPolicyHttpRequest, Operation> insertSecurityPolicySettings() {
            return this.insertSecurityPolicySettings;
        }

        public PagedCallSettings.Builder<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicyClient.ListSecurityPoliciesPagedResponse> listSecurityPoliciesSettings() {
            return this.listSecurityPoliciesSettings;
        }

        public UnaryCallSettings.Builder<PatchSecurityPolicyHttpRequest, Operation> patchSecurityPolicySettings() {
            return this.patchSecurityPolicySettings;
        }

        public UnaryCallSettings.Builder<PatchRuleSecurityPolicyHttpRequest, Operation> patchRuleSecurityPolicySettings() {
            return this.patchRuleSecurityPolicySettings;
        }

        public UnaryCallSettings.Builder<RemoveRuleSecurityPolicyHttpRequest, Operation> removeRuleSecurityPolicySettings() {
            return this.removeRuleSecurityPolicySettings;
        }

        public SecurityPolicyStubSettings build() throws IOException {
            return new SecurityPolicyStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

