/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneAutoscalerName
implements ResourceName {
    private final String autoscaler;
    private final String project;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/zones/{zone}/autoscalers/{autoscaler}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneAutoscalerName(Builder builder) {
        this.autoscaler = (String)Preconditions.checkNotNull((Object)builder.getAutoscaler());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneAutoscalerName of(String autoscaler, String project, String zone) {
        return ProjectZoneAutoscalerName.newBuilder().setAutoscaler(autoscaler).setProject(project).setZone(zone).build();
    }

    public static String format(String autoscaler, String project, String zone) {
        return ProjectZoneAutoscalerName.of(autoscaler, project, zone).toString();
    }

    public String getAutoscaler() {
        return this.autoscaler;
    }

    public String getProject() {
        return this.project;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneAutoscalerName projectZoneAutoscalerName = this;
            synchronized (projectZoneAutoscalerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"autoscaler", (Object)this.autoscaler);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneAutoscalerName> newFactory() {
        return new ResourceNameFactory<ProjectZoneAutoscalerName>(){

            public ProjectZoneAutoscalerName parse(String formattedString) {
                return ProjectZoneAutoscalerName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneAutoscalerName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectZoneAutoscalerName.parse: formattedString not in valid format");
        return ProjectZoneAutoscalerName.of((String)matchMap.get("autoscaler"), (String)matchMap.get("project"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"autoscaler", this.autoscaler, "project", this.project, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneAutoscalerName) {
            ProjectZoneAutoscalerName that = (ProjectZoneAutoscalerName)o;
            return Objects.equals(this.autoscaler, that.getAutoscaler()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.autoscaler, this.project, this.zone);
    }

    public static class Builder {
        private String autoscaler;
        private String project;
        private String zone;

        public String getAutoscaler() {
            return this.autoscaler;
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setAutoscaler(String autoscaler) {
            this.autoscaler = autoscaler;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneAutoscalerName projectZoneAutoscalerName) {
            this.autoscaler = projectZoneAutoscalerName.autoscaler;
            this.project = projectZoneAutoscalerName.project;
            this.zone = projectZoneAutoscalerName.zone;
        }

        public ProjectZoneAutoscalerName build() {
            return new ProjectZoneAutoscalerName(this);
        }
    }
}

