/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Network;
import com.google.cloud.compute.NetworkConfiguration;
import com.google.cloud.compute.SubnetworkId;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;

public class SubnetNetworkConfiguration
extends NetworkConfiguration {
    private static final long serialVersionUID = -5286394393047479494L;
    private final Boolean autoCreateSubnetworks;
    private final List<SubnetworkId> subnetworks;

    SubnetNetworkConfiguration(boolean autoCreateSubnetworks, List<SubnetworkId> subnetworks) {
        super(NetworkConfiguration.Type.SUBNET);
        this.autoCreateSubnetworks = autoCreateSubnetworks;
        this.subnetworks = subnetworks;
    }

    public Boolean autoCreateSubnetworks() {
        return this.autoCreateSubnetworks;
    }

    @Deprecated
    public List<SubnetworkId> subnetworks() {
        return this.getSubnetworks();
    }

    public List<SubnetworkId> getSubnetworks() {
        return this.subnetworks;
    }

    public final int hashCode() {
        return Objects.hash(this.autoCreateSubnetworks, this.subnetworks);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(SubnetNetworkConfiguration.class) && Objects.equals(this.toPb(), ((SubnetNetworkConfiguration)obj).toPb());
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("autoCreateSubnetworks", (Object)this.autoCreateSubnetworks).add("subnetworks", this.subnetworks);
    }

    @Override
    Network toPb() {
        Network networkPb = new Network().setAutoCreateSubnetworks(this.autoCreateSubnetworks);
        if (this.subnetworks != null) {
            networkPb.setSubnetworks(Lists.transform(this.subnetworks, SubnetworkId.TO_URL_FUNCTION));
        }
        return networkPb;
    }

    public static SubnetNetworkConfiguration of(boolean autoCreateSubnetworks) {
        return new SubnetNetworkConfiguration(autoCreateSubnetworks, null);
    }

    static SubnetNetworkConfiguration fromPb(Network networkPb) {
        List subnetworks = null;
        if (networkPb.getSubnetworks() != null) {
            subnetworks = Lists.transform((List)networkPb.getSubnetworks(), SubnetworkId.FROM_URL_FUNCTION);
        }
        return new SubnetNetworkConfiguration(networkPb.getAutoCreateSubnetworks(), subnetworks);
    }
}

