/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskImageConfiguration;
import com.google.cloud.compute.DiskInfo;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.ImageInfo;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.SnapshotId;
import com.google.cloud.compute.SnapshotInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Objects;

public class Disk
extends DiskInfo {
    private static final long serialVersionUID = 7234747955588262204L;
    private final ComputeOptions options;
    private transient Compute compute;

    Disk(Compute compute, DiskInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.compute = (Compute)Preconditions.checkNotNull((Object)compute);
        this.options = (ComputeOptions)compute.getOptions();
    }

    public boolean exists() {
        return this.reload(Compute.DiskOption.fields(new Compute.DiskField[0])) != null;
    }

    public Disk reload(Compute.DiskOption ... options) {
        return this.compute.getDisk(this.getDiskId(), options);
    }

    public Operation delete(Compute.OperationOption ... options) {
        return this.compute.deleteDisk(this.getDiskId(), options);
    }

    public Operation createSnapshot(String snapshot, Compute.OperationOption ... options) {
        return this.compute.create(SnapshotInfo.of(SnapshotId.of(snapshot), this.getDiskId()), options);
    }

    public Operation createSnapshot(String snapshot, String description, Compute.OperationOption ... options) {
        SnapshotInfo snapshotInfo = SnapshotInfo.newBuilder(SnapshotId.of(snapshot), this.getDiskId()).setDescription(description).build();
        return this.compute.create(snapshotInfo, options);
    }

    public Operation createImage(String image, Compute.OperationOption ... options) {
        ImageInfo imageInfo = ImageInfo.of(ImageId.of(image), DiskImageConfiguration.of(this.getDiskId()));
        return this.compute.create(imageInfo, options);
    }

    public Operation createImage(String image, String description, Compute.OperationOption ... options) {
        ImageInfo imageInfo = ImageInfo.newBuilder(ImageId.of(image), DiskImageConfiguration.of(this.getDiskId())).setDescription(description).build();
        return this.compute.create(imageInfo, options);
    }

    public Operation resize(long sizeGb, Compute.OperationOption ... options) {
        return this.compute.resize(this.getDiskId(), sizeGb, options);
    }

    @Deprecated
    public Compute compute() {
        return this.getCompute();
    }

    public Compute getCompute() {
        return this.compute;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Disk.class)) {
            return false;
        }
        Disk other = (Disk)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.getService();
    }

    static Disk fromPb(Compute compute, com.google.api.services.compute.model.Disk diskPb) {
        return new Disk(compute, new DiskInfo.BuilderImpl(diskPb));
    }

    public static class Builder
    extends DiskInfo.Builder {
        private final Compute compute;
        private final DiskInfo.BuilderImpl infoBuilder;

        Builder(Compute compute, DiskId diskId, DiskConfiguration diskConfiguration) {
            this.compute = compute;
            this.infoBuilder = new DiskInfo.BuilderImpl(diskId, diskConfiguration);
        }

        Builder(Disk disk) {
            this.compute = disk.compute;
            this.infoBuilder = new DiskInfo.BuilderImpl(disk);
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        @Deprecated
        public Builder configuration(DiskConfiguration configuration) {
            return this.setConfiguration(configuration);
        }

        @Override
        public Builder setConfiguration(DiskConfiguration configuration) {
            this.infoBuilder.setConfiguration(configuration);
            return this;
        }

        @Override
        @Deprecated
        public Builder diskId(DiskId diskId) {
            return this.setDiskId(diskId);
        }

        @Override
        public Builder setDiskId(DiskId diskId) {
            this.infoBuilder.setDiskId(diskId);
            return this;
        }

        @Override
        Builder setCreationTimestamp(Long creationTimestamp) {
            this.infoBuilder.setCreationTimestamp(creationTimestamp);
            return this;
        }

        @Override
        Builder setCreationStatus(DiskInfo.CreationStatus creationStatus) {
            this.infoBuilder.setCreationStatus(creationStatus);
            return this;
        }

        @Override
        @Deprecated
        public Builder description(String description) {
            return this.setDescription(description);
        }

        @Override
        public Builder setDescription(String description) {
            this.infoBuilder.setDescription(description);
            return this;
        }

        @Override
        Builder setLicenses(List<LicenseId> licenses) {
            this.infoBuilder.setLicenses((List)licenses);
            return this;
        }

        @Override
        Builder setAttachedInstances(List<InstanceId> attachedInstances) {
            this.infoBuilder.setAttachedInstances((List)attachedInstances);
            return this;
        }

        @Override
        Builder setLastAttachTimestamp(Long lastAttachTimestamp) {
            this.infoBuilder.setLastAttachTimestamp(lastAttachTimestamp);
            return this;
        }

        @Override
        Builder setLastDetachTimestamp(Long lastDetachTimestamp) {
            this.infoBuilder.setLastDetachTimestamp(lastDetachTimestamp);
            return this;
        }

        @Override
        public Disk build() {
            return new Disk(this.compute, this.infoBuilder);
        }
    }
}

