/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.CustomerEncryptionKey;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Snapshot
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final String diskSizeGb;
    private final String id;
    private final String kind;
    private final String labelFingerprint;
    private final Map<String, String> labels;
    private final List<String> licenseCodes;
    private final List<String> licenses;
    private final String name;
    private final String selfLink;
    private final CustomerEncryptionKey snapshotEncryptionKey;
    private final String sourceDisk;
    private final CustomerEncryptionKey sourceDiskEncryptionKey;
    private final String sourceDiskId;
    private final String status;
    private final String storageBytes;
    private final String storageBytesStatus;
    private static final Snapshot DEFAULT_INSTANCE = new Snapshot();

    private Snapshot() {
        this.creationTimestamp = null;
        this.description = null;
        this.diskSizeGb = null;
        this.id = null;
        this.kind = null;
        this.labelFingerprint = null;
        this.labels = null;
        this.licenseCodes = null;
        this.licenses = null;
        this.name = null;
        this.selfLink = null;
        this.snapshotEncryptionKey = null;
        this.sourceDisk = null;
        this.sourceDiskEncryptionKey = null;
        this.sourceDiskId = null;
        this.status = null;
        this.storageBytes = null;
        this.storageBytesStatus = null;
    }

    private Snapshot(String creationTimestamp, String description, String diskSizeGb, String id, String kind, String labelFingerprint, Map<String, String> labels, List<String> licenseCodes, List<String> licenses, String name, String selfLink, CustomerEncryptionKey snapshotEncryptionKey, String sourceDisk, CustomerEncryptionKey sourceDiskEncryptionKey, String sourceDiskId, String status, String storageBytes, String storageBytesStatus) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.diskSizeGb = diskSizeGb;
        this.id = id;
        this.kind = kind;
        this.labelFingerprint = labelFingerprint;
        this.labels = labels;
        this.licenseCodes = licenseCodes;
        this.licenses = licenses;
        this.name = name;
        this.selfLink = selfLink;
        this.snapshotEncryptionKey = snapshotEncryptionKey;
        this.sourceDisk = sourceDisk;
        this.sourceDiskEncryptionKey = sourceDiskEncryptionKey;
        this.sourceDiskId = sourceDiskId;
        this.status = status;
        this.storageBytes = storageBytes;
        this.storageBytesStatus = storageBytesStatus;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("diskSizeGb".equals(fieldName)) {
            return this.diskSizeGb;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("labelFingerprint".equals(fieldName)) {
            return this.labelFingerprint;
        }
        if ("labels".equals(fieldName)) {
            return this.labels;
        }
        if ("licenseCodes".equals(fieldName)) {
            return this.licenseCodes;
        }
        if ("licenses".equals(fieldName)) {
            return this.licenses;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("snapshotEncryptionKey".equals(fieldName)) {
            return this.snapshotEncryptionKey;
        }
        if ("sourceDisk".equals(fieldName)) {
            return this.sourceDisk;
        }
        if ("sourceDiskEncryptionKey".equals(fieldName)) {
            return this.sourceDiskEncryptionKey;
        }
        if ("sourceDiskId".equals(fieldName)) {
            return this.sourceDiskId;
        }
        if ("status".equals(fieldName)) {
            return this.status;
        }
        if ("storageBytes".equals(fieldName)) {
            return this.storageBytes;
        }
        if ("storageBytesStatus".equals(fieldName)) {
            return this.storageBytesStatus;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDiskSizeGb() {
        return this.diskSizeGb;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getLabelFingerprint() {
        return this.labelFingerprint;
    }

    public Map<String, String> getLabelsMap() {
        return this.labels;
    }

    public List<String> getLicenseCodesList() {
        return this.licenseCodes;
    }

    public List<String> getLicensesList() {
        return this.licenses;
    }

    public String getName() {
        return this.name;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public CustomerEncryptionKey getSnapshotEncryptionKey() {
        return this.snapshotEncryptionKey;
    }

    public String getSourceDisk() {
        return this.sourceDisk;
    }

    public CustomerEncryptionKey getSourceDiskEncryptionKey() {
        return this.sourceDiskEncryptionKey;
    }

    public String getSourceDiskId() {
        return this.sourceDiskId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStorageBytes() {
        return this.storageBytes;
    }

    public String getStorageBytesStatus() {
        return this.storageBytesStatus;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Snapshot prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Snapshot getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Snapshot{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", diskSizeGb=" + this.diskSizeGb + ", id=" + this.id + ", kind=" + this.kind + ", labelFingerprint=" + this.labelFingerprint + ", labels=" + this.labels + ", licenseCodes=" + this.licenseCodes + ", licenses=" + this.licenses + ", name=" + this.name + ", selfLink=" + this.selfLink + ", snapshotEncryptionKey=" + this.snapshotEncryptionKey + ", sourceDisk=" + this.sourceDisk + ", sourceDiskEncryptionKey=" + this.sourceDiskEncryptionKey + ", sourceDiskId=" + this.sourceDiskId + ", status=" + this.status + ", storageBytes=" + this.storageBytes + ", storageBytesStatus=" + this.storageBytesStatus + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Snapshot) {
            Snapshot that = (Snapshot)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.diskSizeGb, that.getDiskSizeGb()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.labelFingerprint, that.getLabelFingerprint()) && Objects.equals(this.labels, that.getLabelsMap()) && Objects.equals(this.licenseCodes, that.getLicenseCodesList()) && Objects.equals(this.licenses, that.getLicensesList()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.snapshotEncryptionKey, that.getSnapshotEncryptionKey()) && Objects.equals(this.sourceDisk, that.getSourceDisk()) && Objects.equals(this.sourceDiskEncryptionKey, that.getSourceDiskEncryptionKey()) && Objects.equals(this.sourceDiskId, that.getSourceDiskId()) && Objects.equals(this.status, that.getStatus()) && Objects.equals(this.storageBytes, that.getStorageBytes()) && Objects.equals(this.storageBytesStatus, that.getStorageBytesStatus());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.diskSizeGb, this.id, this.kind, this.labelFingerprint, this.labels, this.licenseCodes, this.licenses, this.name, this.selfLink, this.snapshotEncryptionKey, this.sourceDisk, this.sourceDiskEncryptionKey, this.sourceDiskId, this.status, this.storageBytes, this.storageBytesStatus);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private String diskSizeGb;
        private String id;
        private String kind;
        private String labelFingerprint;
        private Map<String, String> labels;
        private List<String> licenseCodes;
        private List<String> licenses;
        private String name;
        private String selfLink;
        private CustomerEncryptionKey snapshotEncryptionKey;
        private String sourceDisk;
        private CustomerEncryptionKey sourceDiskEncryptionKey;
        private String sourceDiskId;
        private String status;
        private String storageBytes;
        private String storageBytesStatus;

        Builder() {
        }

        public Builder mergeFrom(Snapshot other) {
            if (other == Snapshot.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getDiskSizeGb() != null) {
                this.diskSizeGb = other.diskSizeGb;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getLabelFingerprint() != null) {
                this.labelFingerprint = other.labelFingerprint;
            }
            if (other.getLabelsMap() != null) {
                this.labels = other.labels;
            }
            if (other.getLicenseCodesList() != null) {
                this.licenseCodes = other.licenseCodes;
            }
            if (other.getLicensesList() != null) {
                this.licenses = other.licenses;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getSnapshotEncryptionKey() != null) {
                this.snapshotEncryptionKey = other.snapshotEncryptionKey;
            }
            if (other.getSourceDisk() != null) {
                this.sourceDisk = other.sourceDisk;
            }
            if (other.getSourceDiskEncryptionKey() != null) {
                this.sourceDiskEncryptionKey = other.sourceDiskEncryptionKey;
            }
            if (other.getSourceDiskId() != null) {
                this.sourceDiskId = other.sourceDiskId;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            if (other.getStorageBytes() != null) {
                this.storageBytes = other.storageBytes;
            }
            if (other.getStorageBytesStatus() != null) {
                this.storageBytesStatus = other.storageBytesStatus;
            }
            return this;
        }

        Builder(Snapshot source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.diskSizeGb = source.diskSizeGb;
            this.id = source.id;
            this.kind = source.kind;
            this.labelFingerprint = source.labelFingerprint;
            this.labels = source.labels;
            this.licenseCodes = source.licenseCodes;
            this.licenses = source.licenses;
            this.name = source.name;
            this.selfLink = source.selfLink;
            this.snapshotEncryptionKey = source.snapshotEncryptionKey;
            this.sourceDisk = source.sourceDisk;
            this.sourceDiskEncryptionKey = source.sourceDiskEncryptionKey;
            this.sourceDiskId = source.sourceDiskId;
            this.status = source.status;
            this.storageBytes = source.storageBytes;
            this.storageBytesStatus = source.storageBytesStatus;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getDiskSizeGb() {
            return this.diskSizeGb;
        }

        public Builder setDiskSizeGb(String diskSizeGb) {
            this.diskSizeGb = diskSizeGb;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getLabelFingerprint() {
            return this.labelFingerprint;
        }

        public Builder setLabelFingerprint(String labelFingerprint) {
            this.labelFingerprint = labelFingerprint;
            return this;
        }

        public Map<String, String> getLabelsMap() {
            return this.labels;
        }

        public Builder putAllLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public List<String> getLicenseCodesList() {
            return this.licenseCodes;
        }

        public Builder addAllLicenseCodes(List<String> licenseCodes) {
            if (this.licenseCodes == null) {
                this.licenseCodes = new LinkedList<String>();
            }
            this.licenseCodes.addAll(licenseCodes);
            return this;
        }

        public Builder addLicenseCodes(String licenseCodes) {
            if (this.licenseCodes == null) {
                this.licenseCodes = new LinkedList<String>();
            }
            this.licenseCodes.add(licenseCodes);
            return this;
        }

        public List<String> getLicensesList() {
            return this.licenses;
        }

        public Builder addAllLicenses(List<String> licenses) {
            if (this.licenses == null) {
                this.licenses = new LinkedList<String>();
            }
            this.licenses.addAll(licenses);
            return this;
        }

        public Builder addLicenses(String licenses) {
            if (this.licenses == null) {
                this.licenses = new LinkedList<String>();
            }
            this.licenses.add(licenses);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public CustomerEncryptionKey getSnapshotEncryptionKey() {
            return this.snapshotEncryptionKey;
        }

        public Builder setSnapshotEncryptionKey(CustomerEncryptionKey snapshotEncryptionKey) {
            this.snapshotEncryptionKey = snapshotEncryptionKey;
            return this;
        }

        public String getSourceDisk() {
            return this.sourceDisk;
        }

        public Builder setSourceDisk(String sourceDisk) {
            this.sourceDisk = sourceDisk;
            return this;
        }

        public CustomerEncryptionKey getSourceDiskEncryptionKey() {
            return this.sourceDiskEncryptionKey;
        }

        public Builder setSourceDiskEncryptionKey(CustomerEncryptionKey sourceDiskEncryptionKey) {
            this.sourceDiskEncryptionKey = sourceDiskEncryptionKey;
            return this;
        }

        public String getSourceDiskId() {
            return this.sourceDiskId;
        }

        public Builder setSourceDiskId(String sourceDiskId) {
            this.sourceDiskId = sourceDiskId;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public String getStorageBytes() {
            return this.storageBytes;
        }

        public Builder setStorageBytes(String storageBytes) {
            this.storageBytes = storageBytes;
            return this;
        }

        public String getStorageBytesStatus() {
            return this.storageBytesStatus;
        }

        public Builder setStorageBytesStatus(String storageBytesStatus) {
            this.storageBytesStatus = storageBytesStatus;
            return this;
        }

        public Snapshot build() {
            return new Snapshot(this.creationTimestamp, this.description, this.diskSizeGb, this.id, this.kind, this.labelFingerprint, this.labels, this.licenseCodes, this.licenses, this.name, this.selfLink, this.snapshotEncryptionKey, this.sourceDisk, this.sourceDiskEncryptionKey, this.sourceDiskId, this.status, this.storageBytes, this.storageBytesStatus);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setDiskSizeGb(this.diskSizeGb);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setLabelFingerprint(this.labelFingerprint);
            newBuilder.putAllLabels(this.labels);
            newBuilder.addAllLicenseCodes(this.licenseCodes);
            newBuilder.addAllLicenses(this.licenses);
            newBuilder.setName(this.name);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setSnapshotEncryptionKey(this.snapshotEncryptionKey);
            newBuilder.setSourceDisk(this.sourceDisk);
            newBuilder.setSourceDiskEncryptionKey(this.sourceDiskEncryptionKey);
            newBuilder.setSourceDiskId(this.sourceDiskId);
            newBuilder.setStatus(this.status);
            newBuilder.setStorageBytes(this.storageBytes);
            newBuilder.setStorageBytesStatus(this.storageBytesStatus);
            return newBuilder;
        }
    }
}

