/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Backend
implements ApiMessage {
    private final String balancingMode;
    private final Float capacityScaler;
    private final String description;
    private final String group;
    private final Integer maxConnections;
    private final Integer maxConnectionsPerInstance;
    private final Integer maxRate;
    private final Float maxRatePerInstance;
    private final Float maxUtilization;
    private static final Backend DEFAULT_INSTANCE = new Backend();

    private Backend() {
        this.balancingMode = null;
        this.capacityScaler = null;
        this.description = null;
        this.group = null;
        this.maxConnections = null;
        this.maxConnectionsPerInstance = null;
        this.maxRate = null;
        this.maxRatePerInstance = null;
        this.maxUtilization = null;
    }

    private Backend(String balancingMode, Float capacityScaler, String description, String group, Integer maxConnections, Integer maxConnectionsPerInstance, Integer maxRate, Float maxRatePerInstance, Float maxUtilization) {
        this.balancingMode = balancingMode;
        this.capacityScaler = capacityScaler;
        this.description = description;
        this.group = group;
        this.maxConnections = maxConnections;
        this.maxConnectionsPerInstance = maxConnectionsPerInstance;
        this.maxRate = maxRate;
        this.maxRatePerInstance = maxRatePerInstance;
        this.maxUtilization = maxUtilization;
    }

    public Object getFieldValue(String fieldName) {
        if ("balancingMode".equals(fieldName)) {
            return this.balancingMode;
        }
        if ("capacityScaler".equals(fieldName)) {
            return this.capacityScaler;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("group".equals(fieldName)) {
            return this.group;
        }
        if ("maxConnections".equals(fieldName)) {
            return this.maxConnections;
        }
        if ("maxConnectionsPerInstance".equals(fieldName)) {
            return this.maxConnectionsPerInstance;
        }
        if ("maxRate".equals(fieldName)) {
            return this.maxRate;
        }
        if ("maxRatePerInstance".equals(fieldName)) {
            return this.maxRatePerInstance;
        }
        if ("maxUtilization".equals(fieldName)) {
            return this.maxUtilization;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getBalancingMode() {
        return this.balancingMode;
    }

    public Float getCapacityScaler() {
        return this.capacityScaler;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroup() {
        return this.group;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Integer getMaxConnectionsPerInstance() {
        return this.maxConnectionsPerInstance;
    }

    public Integer getMaxRate() {
        return this.maxRate;
    }

    public Float getMaxRatePerInstance() {
        return this.maxRatePerInstance;
    }

    public Float getMaxUtilization() {
        return this.maxUtilization;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Backend prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Backend getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Backend{balancingMode=" + this.balancingMode + ", capacityScaler=" + this.capacityScaler + ", description=" + this.description + ", group=" + this.group + ", maxConnections=" + this.maxConnections + ", maxConnectionsPerInstance=" + this.maxConnectionsPerInstance + ", maxRate=" + this.maxRate + ", maxRatePerInstance=" + this.maxRatePerInstance + ", maxUtilization=" + this.maxUtilization + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Backend) {
            Backend that = (Backend)o;
            return Objects.equals(this.balancingMode, that.getBalancingMode()) && Objects.equals(this.capacityScaler, that.getCapacityScaler()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.group, that.getGroup()) && Objects.equals(this.maxConnections, that.getMaxConnections()) && Objects.equals(this.maxConnectionsPerInstance, that.getMaxConnectionsPerInstance()) && Objects.equals(this.maxRate, that.getMaxRate()) && Objects.equals(this.maxRatePerInstance, that.getMaxRatePerInstance()) && Objects.equals(this.maxUtilization, that.getMaxUtilization());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.balancingMode, this.capacityScaler, this.description, this.group, this.maxConnections, this.maxConnectionsPerInstance, this.maxRate, this.maxRatePerInstance, this.maxUtilization);
    }

    public static class Builder {
        private String balancingMode;
        private Float capacityScaler;
        private String description;
        private String group;
        private Integer maxConnections;
        private Integer maxConnectionsPerInstance;
        private Integer maxRate;
        private Float maxRatePerInstance;
        private Float maxUtilization;

        Builder() {
        }

        public Builder mergeFrom(Backend other) {
            if (other == Backend.getDefaultInstance()) {
                return this;
            }
            if (other.getBalancingMode() != null) {
                this.balancingMode = other.balancingMode;
            }
            if (other.getCapacityScaler() != null) {
                this.capacityScaler = other.capacityScaler;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getGroup() != null) {
                this.group = other.group;
            }
            if (other.getMaxConnections() != null) {
                this.maxConnections = other.maxConnections;
            }
            if (other.getMaxConnectionsPerInstance() != null) {
                this.maxConnectionsPerInstance = other.maxConnectionsPerInstance;
            }
            if (other.getMaxRate() != null) {
                this.maxRate = other.maxRate;
            }
            if (other.getMaxRatePerInstance() != null) {
                this.maxRatePerInstance = other.maxRatePerInstance;
            }
            if (other.getMaxUtilization() != null) {
                this.maxUtilization = other.maxUtilization;
            }
            return this;
        }

        Builder(Backend source) {
            this.balancingMode = source.balancingMode;
            this.capacityScaler = source.capacityScaler;
            this.description = source.description;
            this.group = source.group;
            this.maxConnections = source.maxConnections;
            this.maxConnectionsPerInstance = source.maxConnectionsPerInstance;
            this.maxRate = source.maxRate;
            this.maxRatePerInstance = source.maxRatePerInstance;
            this.maxUtilization = source.maxUtilization;
        }

        public String getBalancingMode() {
            return this.balancingMode;
        }

        public Builder setBalancingMode(String balancingMode) {
            this.balancingMode = balancingMode;
            return this;
        }

        public Float getCapacityScaler() {
            return this.capacityScaler;
        }

        public Builder setCapacityScaler(Float capacityScaler) {
            this.capacityScaler = capacityScaler;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getGroup() {
            return this.group;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        public Integer getMaxConnections() {
            return this.maxConnections;
        }

        public Builder setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Integer getMaxConnectionsPerInstance() {
            return this.maxConnectionsPerInstance;
        }

        public Builder setMaxConnectionsPerInstance(Integer maxConnectionsPerInstance) {
            this.maxConnectionsPerInstance = maxConnectionsPerInstance;
            return this;
        }

        public Integer getMaxRate() {
            return this.maxRate;
        }

        public Builder setMaxRate(Integer maxRate) {
            this.maxRate = maxRate;
            return this;
        }

        public Float getMaxRatePerInstance() {
            return this.maxRatePerInstance;
        }

        public Builder setMaxRatePerInstance(Float maxRatePerInstance) {
            this.maxRatePerInstance = maxRatePerInstance;
            return this;
        }

        public Float getMaxUtilization() {
            return this.maxUtilization;
        }

        public Builder setMaxUtilization(Float maxUtilization) {
            this.maxUtilization = maxUtilization;
            return this;
        }

        public Backend build() {
            return new Backend(this.balancingMode, this.capacityScaler, this.description, this.group, this.maxConnections, this.maxConnectionsPerInstance, this.maxRate, this.maxRatePerInstance, this.maxUtilization);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setBalancingMode(this.balancingMode);
            newBuilder.setCapacityScaler(this.capacityScaler);
            newBuilder.setDescription(this.description);
            newBuilder.setGroup(this.group);
            newBuilder.setMaxConnections(this.maxConnections);
            newBuilder.setMaxConnectionsPerInstance(this.maxConnectionsPerInstance);
            newBuilder.setMaxRate(this.maxRate);
            newBuilder.setMaxRatePerInstance(this.maxRatePerInstance);
            newBuilder.setMaxUtilization(this.maxUtilization);
            return newBuilder;
        }
    }
}

