/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.DiskInstantiationConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SourceInstanceParams
implements ApiMessage {
    private final List<DiskInstantiationConfig> diskConfigs;
    private static final SourceInstanceParams DEFAULT_INSTANCE = new SourceInstanceParams();

    private SourceInstanceParams() {
        this.diskConfigs = null;
    }

    private SourceInstanceParams(List<DiskInstantiationConfig> diskConfigs) {
        this.diskConfigs = diskConfigs;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("diskConfigs")) {
            return this.diskConfigs;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<DiskInstantiationConfig> getDiskConfigsList() {
        return this.diskConfigs;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SourceInstanceParams prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SourceInstanceParams getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SourceInstanceParams{diskConfigs=" + this.diskConfigs + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SourceInstanceParams) {
            SourceInstanceParams that = (SourceInstanceParams)o;
            return Objects.equals(this.diskConfigs, that.getDiskConfigsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.diskConfigs);
    }

    public static class Builder {
        private List<DiskInstantiationConfig> diskConfigs;

        Builder() {
        }

        public Builder mergeFrom(SourceInstanceParams other) {
            if (other == SourceInstanceParams.getDefaultInstance()) {
                return this;
            }
            if (other.getDiskConfigsList() != null) {
                this.diskConfigs = other.diskConfigs;
            }
            return this;
        }

        Builder(SourceInstanceParams source) {
            this.diskConfigs = source.diskConfigs;
        }

        public List<DiskInstantiationConfig> getDiskConfigsList() {
            return this.diskConfigs;
        }

        public Builder addAllDiskConfigs(List<DiskInstantiationConfig> diskConfigs) {
            if (this.diskConfigs == null) {
                this.diskConfigs = new LinkedList<DiskInstantiationConfig>();
            }
            this.diskConfigs.addAll(diskConfigs);
            return this;
        }

        public Builder addDiskConfigs(DiskInstantiationConfig diskConfigs) {
            if (this.diskConfigs == null) {
                this.diskConfigs = new LinkedList<DiskInstantiationConfig>();
            }
            this.diskConfigs.add(diskConfigs);
            return this;
        }

        public SourceInstanceParams build() {
            return new SourceInstanceParams(this.diskConfigs);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllDiskConfigs(this.diskConfigs);
            return newBuilder;
        }
    }
}

