/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class BackendBucketCdnPolicy
implements ApiMessage {
    private final String signedUrlCacheMaxAgeSec;
    private final List<String> signedUrlKeyNames;
    private static final BackendBucketCdnPolicy DEFAULT_INSTANCE = new BackendBucketCdnPolicy();

    private BackendBucketCdnPolicy() {
        this.signedUrlCacheMaxAgeSec = null;
        this.signedUrlKeyNames = null;
    }

    private BackendBucketCdnPolicy(String signedUrlCacheMaxAgeSec, List<String> signedUrlKeyNames) {
        this.signedUrlCacheMaxAgeSec = signedUrlCacheMaxAgeSec;
        this.signedUrlKeyNames = signedUrlKeyNames;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("signedUrlCacheMaxAgeSec")) {
            return this.signedUrlCacheMaxAgeSec;
        }
        if (fieldName.equals("signedUrlKeyNames")) {
            return this.signedUrlKeyNames;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getSignedUrlCacheMaxAgeSec() {
        return this.signedUrlCacheMaxAgeSec;
    }

    public List<String> getSignedUrlKeyNamesList() {
        return this.signedUrlKeyNames;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(BackendBucketCdnPolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static BackendBucketCdnPolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "BackendBucketCdnPolicy{signedUrlCacheMaxAgeSec=" + this.signedUrlCacheMaxAgeSec + ", signedUrlKeyNames=" + this.signedUrlKeyNames + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BackendBucketCdnPolicy) {
            BackendBucketCdnPolicy that = (BackendBucketCdnPolicy)o;
            return Objects.equals(this.signedUrlCacheMaxAgeSec, that.getSignedUrlCacheMaxAgeSec()) && Objects.equals(this.signedUrlKeyNames, that.getSignedUrlKeyNamesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.signedUrlCacheMaxAgeSec, this.signedUrlKeyNames);
    }

    public static class Builder {
        private String signedUrlCacheMaxAgeSec;
        private List<String> signedUrlKeyNames;

        Builder() {
        }

        public Builder mergeFrom(BackendBucketCdnPolicy other) {
            if (other == BackendBucketCdnPolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getSignedUrlCacheMaxAgeSec() != null) {
                this.signedUrlCacheMaxAgeSec = other.signedUrlCacheMaxAgeSec;
            }
            if (other.getSignedUrlKeyNamesList() != null) {
                this.signedUrlKeyNames = other.signedUrlKeyNames;
            }
            return this;
        }

        Builder(BackendBucketCdnPolicy source) {
            this.signedUrlCacheMaxAgeSec = source.signedUrlCacheMaxAgeSec;
            this.signedUrlKeyNames = source.signedUrlKeyNames;
        }

        public String getSignedUrlCacheMaxAgeSec() {
            return this.signedUrlCacheMaxAgeSec;
        }

        public Builder setSignedUrlCacheMaxAgeSec(String signedUrlCacheMaxAgeSec) {
            this.signedUrlCacheMaxAgeSec = signedUrlCacheMaxAgeSec;
            return this;
        }

        public List<String> getSignedUrlKeyNamesList() {
            return this.signedUrlKeyNames;
        }

        public Builder addAllSignedUrlKeyNames(List<String> signedUrlKeyNames) {
            if (this.signedUrlKeyNames == null) {
                this.signedUrlKeyNames = new LinkedList<String>();
            }
            this.signedUrlKeyNames.addAll(signedUrlKeyNames);
            return this;
        }

        public Builder addSignedUrlKeyNames(String signedUrlKeyNames) {
            if (this.signedUrlKeyNames == null) {
                this.signedUrlKeyNames = new LinkedList<String>();
            }
            this.signedUrlKeyNames.add(signedUrlKeyNames);
            return this;
        }

        public BackendBucketCdnPolicy build() {
            return new BackendBucketCdnPolicy(this.signedUrlCacheMaxAgeSec, this.signedUrlKeyNames);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setSignedUrlCacheMaxAgeSec(this.signedUrlCacheMaxAgeSec);
            newBuilder.addAllSignedUrlKeyNames(this.signedUrlKeyNames);
            return newBuilder;
        }
    }
}

