/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Router;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class PreviewRouterHttpRequest
implements ApiMessage {
    private final String access_token;
    private final String callback;
    private final String fields;
    private final String key;
    private final String prettyPrint;
    private final String quotaUser;
    private final String router;
    private final Router routerResource;
    private final String userIp;
    private static final PreviewRouterHttpRequest DEFAULT_INSTANCE = new PreviewRouterHttpRequest();

    private PreviewRouterHttpRequest() {
        this.access_token = null;
        this.callback = null;
        this.fields = null;
        this.key = null;
        this.prettyPrint = null;
        this.quotaUser = null;
        this.router = null;
        this.routerResource = null;
        this.userIp = null;
    }

    private PreviewRouterHttpRequest(String access_token, String callback, String fields, String key, String prettyPrint, String quotaUser, String router, Router routerResource, String userIp) {
        this.access_token = access_token;
        this.callback = callback;
        this.fields = fields;
        this.key = key;
        this.prettyPrint = prettyPrint;
        this.quotaUser = quotaUser;
        this.router = router;
        this.routerResource = routerResource;
        this.userIp = userIp;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("access_token")) {
            return this.access_token;
        }
        if (fieldName.equals("callback")) {
            return this.callback;
        }
        if (fieldName.equals("fields")) {
            return this.fields;
        }
        if (fieldName.equals("key")) {
            return this.key;
        }
        if (fieldName.equals("prettyPrint")) {
            return this.prettyPrint;
        }
        if (fieldName.equals("quotaUser")) {
            return this.quotaUser;
        }
        if (fieldName.equals("router")) {
            return this.router;
        }
        if (fieldName.equals("routerResource")) {
            return this.routerResource;
        }
        if (fieldName.equals("userIp")) {
            return this.userIp;
        }
        return null;
    }

    @Nullable
    public Router getApiMessageRequestBody() {
        return this.routerResource;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getFields() {
        return this.fields;
    }

    public String getKey() {
        return this.key;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public String getQuotaUser() {
        return this.quotaUser;
    }

    public String getRouter() {
        return this.router;
    }

    public Router getRouterResource() {
        return this.routerResource;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PreviewRouterHttpRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static PreviewRouterHttpRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "PreviewRouterHttpRequest{access_token=" + this.access_token + ", callback=" + this.callback + ", fields=" + this.fields + ", key=" + this.key + ", prettyPrint=" + this.prettyPrint + ", quotaUser=" + this.quotaUser + ", router=" + this.router + ", routerResource=" + this.routerResource + ", userIp=" + this.userIp + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PreviewRouterHttpRequest) {
            PreviewRouterHttpRequest that = (PreviewRouterHttpRequest)o;
            return Objects.equals(this.access_token, that.getAccessToken()) && Objects.equals(this.callback, that.getCallback()) && Objects.equals(this.fields, that.getFields()) && Objects.equals(this.key, that.getKey()) && Objects.equals(this.prettyPrint, that.getPrettyPrint()) && Objects.equals(this.quotaUser, that.getQuotaUser()) && Objects.equals(this.router, that.getRouter()) && Objects.equals(this.routerResource, that.getRouterResource()) && Objects.equals(this.userIp, that.getUserIp());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.access_token, this.callback, this.fields, this.key, this.prettyPrint, this.quotaUser, this.router, this.routerResource, this.userIp);
    }

    public static class Builder {
        private String access_token;
        private String callback;
        private String fields;
        private String key;
        private String prettyPrint;
        private String quotaUser;
        private String router;
        private Router routerResource;
        private String userIp;

        Builder() {
        }

        public Builder mergeFrom(PreviewRouterHttpRequest other) {
            if (other == PreviewRouterHttpRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getAccessToken() != null) {
                this.access_token = other.access_token;
            }
            if (other.getCallback() != null) {
                this.callback = other.callback;
            }
            if (other.getFields() != null) {
                this.fields = other.fields;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getPrettyPrint() != null) {
                this.prettyPrint = other.prettyPrint;
            }
            if (other.getQuotaUser() != null) {
                this.quotaUser = other.quotaUser;
            }
            if (other.getRouter() != null) {
                this.router = other.router;
            }
            if (other.getRouterResource() != null) {
                this.routerResource = other.routerResource;
            }
            if (other.getUserIp() != null) {
                this.userIp = other.userIp;
            }
            return this;
        }

        Builder(PreviewRouterHttpRequest source) {
            this.access_token = source.access_token;
            this.callback = source.callback;
            this.fields = source.fields;
            this.key = source.key;
            this.prettyPrint = source.prettyPrint;
            this.quotaUser = source.quotaUser;
            this.router = source.router;
            this.routerResource = source.routerResource;
            this.userIp = source.userIp;
        }

        public String getAccessToken() {
            return this.access_token;
        }

        public Builder setAccessToken(String access_token) {
            this.access_token = access_token;
            return this;
        }

        public String getCallback() {
            return this.callback;
        }

        public Builder setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public String getFields() {
            return this.fields;
        }

        public Builder setFields(String fields) {
            this.fields = fields;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getPrettyPrint() {
            return this.prettyPrint;
        }

        public Builder setPrettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public String getQuotaUser() {
            return this.quotaUser;
        }

        public Builder setQuotaUser(String quotaUser) {
            this.quotaUser = quotaUser;
            return this;
        }

        public String getRouter() {
            return this.router;
        }

        public Builder setRouter(String router) {
            this.router = router;
            return this;
        }

        public Router getRouterResource() {
            return this.routerResource;
        }

        public Builder setRouterResource(Router routerResource) {
            this.routerResource = routerResource;
            return this;
        }

        public String getUserIp() {
            return this.userIp;
        }

        public Builder setUserIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public PreviewRouterHttpRequest build() {
            String missing = "";
            if (this.router == null) {
                missing = missing + " router";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new PreviewRouterHttpRequest(this.access_token, this.callback, this.fields, this.key, this.prettyPrint, this.quotaUser, this.router, this.routerResource, this.userIp);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAccessToken(this.access_token);
            newBuilder.setCallback(this.callback);
            newBuilder.setFields(this.fields);
            newBuilder.setKey(this.key);
            newBuilder.setPrettyPrint(this.prettyPrint);
            newBuilder.setQuotaUser(this.quotaUser);
            newBuilder.setRouter(this.router);
            newBuilder.setRouterResource(this.routerResource);
            newBuilder.setUserIp(this.userIp);
            return newBuilder;
        }
    }
}

