/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneInstanceName
implements ResourceName {
    private final String instance;
    private final String project;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/zones/{zone}/instances/{instance}");
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneInstanceName(Builder builder) {
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneInstanceName of(String instance, String project, String zone) {
        return ProjectZoneInstanceName.newBuilder().setInstance(instance).setProject(project).setZone(zone).build();
    }

    public static String format(String instance, String project, String zone) {
        return ProjectZoneInstanceName.of(instance, project, zone).toString();
    }

    public String getInstance() {
        return this.instance;
    }

    public String getProject() {
        return this.project;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneInstanceName projectZoneInstanceName = this;
            synchronized (projectZoneInstanceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneInstanceName> newFactory() {
        return new ResourceNameFactory<ProjectZoneInstanceName>(){

            public ProjectZoneInstanceName parse(String formattedString) {
                return ProjectZoneInstanceName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneInstanceName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectZoneInstanceName.parse: formattedString not in valid format");
        return ProjectZoneInstanceName.of((String)matchMap.get("instance"), (String)matchMap.get("project"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"instance", this.instance, "project", this.project, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneInstanceName) {
            ProjectZoneInstanceName that = (ProjectZoneInstanceName)o;
            return Objects.equals(this.instance, that.getInstance()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instance, this.project, this.zone);
    }

    public static class Builder {
        private String instance;
        private String project;
        private String zone;

        public String getInstance() {
            return this.instance;
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneInstanceName projectZoneInstanceName) {
            this.instance = projectZoneInstanceName.instance;
            this.project = projectZoneInstanceName.project;
            this.zone = projectZoneInstanceName.zone;
        }

        public ProjectZoneInstanceName build() {
            return new ProjectZoneInstanceName(this);
        }
    }
}

